/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift;

import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TIOStreamTransport;

public class TDeserializer {
    private final TProtocolFactory protocolFactory_;

    public TDeserializer() {
        this(new TBinaryProtocol.Factory());
    }

    public TDeserializer(TProtocolFactory protocolFactory) {
        this.protocolFactory_ = protocolFactory;
    }

    public void deserialize(TBase base, byte[] bytes) throws TException {
        base.read(this.protocolFactory_.getProtocol(new TIOStreamTransport(new ByteArrayInputStream(bytes))));
    }

    public void deserialize(TBase base, String data, String charset) throws TException {
        try {
            this.deserialize(base, data.getBytes(charset));
        }
        catch (UnsupportedEncodingException uex) {
            throw new TException("JVM DOES NOT SUPPORT ENCODING: " + charset);
        }
    }

    public void toString(TBase base, String data) throws TException {
        this.deserialize(base, data.getBytes());
    }
}

