/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.columnar;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.serde2.columnar.BytesRefArrayWritable;
import org.apache.hadoop.hive.serde2.columnar.BytesRefWritable;
import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.lazy.LazyFactory;
import org.apache.hadoop.hive.serde2.lazy.LazyObject;
import org.apache.hadoop.hive.serde2.lazy.LazyUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.Text;

public class ColumnarStruct {
    LazyObject[] fields;
    private static final Log LOG = LogFactory.getLog(ColumnarStruct.class);
    int[] prjColIDs = null;
    ByteArrayRef[] cachedByteArrayRef = null;
    BytesRefWritable[] rawBytesField = null;
    boolean[] inited = null;
    boolean[] fieldSkipped = null;
    ArrayList<Object> cachedList;

    public ColumnarStruct(ObjectInspector oi) {
        this(oi, null);
    }

    public ColumnarStruct(ObjectInspector oi, ArrayList<Integer> notSkippedColumnIDs) {
        int i;
        List<? extends StructField> fieldRefs = ((StructObjectInspector)oi).getAllStructFieldRefs();
        int num = fieldRefs.size();
        this.fields = new LazyObject[num];
        this.cachedByteArrayRef = new ByteArrayRef[num];
        this.rawBytesField = new BytesRefWritable[num];
        this.fieldSkipped = new boolean[num];
        this.inited = new boolean[num];
        if (notSkippedColumnIDs == null || notSkippedColumnIDs.size() == 0) {
            for (i = 0; i < num; ++i) {
                notSkippedColumnIDs.add(i);
            }
        }
        for (i = 0; i < num; ++i) {
            this.fields[i] = LazyFactory.createLazyObject(fieldRefs.get(i).getFieldObjectInspector());
            this.cachedByteArrayRef[i] = new ByteArrayRef();
            if (!notSkippedColumnIDs.contains(i)) {
                this.fieldSkipped[i] = true;
                this.inited[i] = true;
                continue;
            }
            this.inited[i] = false;
        }
        int min = notSkippedColumnIDs.size() > num ? num : notSkippedColumnIDs.size();
        this.prjColIDs = new int[min];
        int index = 0;
        for (int i2 = 0; i2 < notSkippedColumnIDs.size(); ++i2) {
            int readCol = notSkippedColumnIDs.get(i2);
            if (readCol >= num) continue;
            this.prjColIDs[index] = readCol;
            ++index;
        }
    }

    public Object getField(int fieldID, Text nullSequence) {
        return this.uncheckedGetField(fieldID, nullSequence);
    }

    protected Object uncheckedGetField(int fieldID, Text nullSequence) {
        if (this.fieldSkipped[fieldID]) {
            return null;
        }
        if (!this.inited[fieldID]) {
            BytesRefWritable passedInField = this.rawBytesField[fieldID];
            try {
                this.cachedByteArrayRef[fieldID].setData(passedInField.getData());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.fields[fieldID].init(this.cachedByteArrayRef[fieldID], passedInField.getStart(), passedInField.getLength());
            this.inited[fieldID] = true;
        }
        byte[] data = this.cachedByteArrayRef[fieldID].getData();
        int fieldLen = this.rawBytesField[fieldID].length;
        if (fieldLen == nullSequence.getLength() && LazyUtils.compare(data, this.rawBytesField[fieldID].getStart(), fieldLen, nullSequence.getBytes(), 0, nullSequence.getLength()) == 0) {
            return null;
        }
        return this.fields[fieldID].getObject();
    }

    public void init(BytesRefArrayWritable cols) {
        for (int i = 0; i < this.prjColIDs.length; ++i) {
            int fieldIndex = this.prjColIDs[i];
            if (fieldIndex < cols.size()) {
                this.rawBytesField[fieldIndex] = cols.unCheckedGet(fieldIndex);
                this.inited[fieldIndex] = false;
                continue;
            }
            this.fieldSkipped[fieldIndex] = true;
        }
    }

    public ArrayList<Object> getFieldsAsList(Text nullSequence) {
        if (this.cachedList == null) {
            this.cachedList = new ArrayList();
        } else {
            this.cachedList.clear();
        }
        for (int i = 0; i < this.fields.length; ++i) {
            this.cachedList.add(this.uncheckedGetField(i, nullSequence));
        }
        return this.cachedList;
    }
}

