/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.services.io.LimitObjectInput;
import org.apache.derby.iapi.store.access.conglomerate.LogicalUndo;
import org.apache.derby.iapi.store.raw.Compensation;
import org.apache.derby.iapi.store.raw.ContainerHandle;
import org.apache.derby.iapi.store.raw.LockingPolicy;
import org.apache.derby.iapi.store.raw.LogicalUndoable;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.impl.store.raw.data.BasePage;
import org.apache.derby.impl.store.raw.data.LogicalUndoOperation;
import org.apache.derby.impl.store.raw.data.PageBasicOperation;
import org.apache.derby.impl.store.raw.data.RecordId;

public abstract class LogicalPageOperation
extends PageBasicOperation
implements LogicalUndoable {
    protected LogicalUndo undo;
    protected int recordId;

    public LogicalPageOperation() {
    }

    protected LogicalPageOperation(BasePage basePage, LogicalUndo logicalUndo, int n) {
        super(basePage);
        this.undo = logicalUndo;
        this.recordId = n;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        CompressedNumber.writeInt(objectOutput, this.recordId);
        objectOutput.writeObject(this.undo);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.recordId = CompressedNumber.readInt(objectInput);
        this.undo = (LogicalUndo)objectInput.readObject();
    }

    public Compensation generateUndo(Transaction transaction, LimitObjectInput limitObjectInput) throws StandardException, IOException {
        if (this.undo == null) {
            BasePage basePage = this.findpage(transaction);
            basePage.preDirty();
            return new LogicalUndoOperation(basePage, this.recordId, this);
        }
        BasePage basePage = this.findLogicalPage(transaction, this.undo, limitObjectInput);
        basePage.preDirty();
        return new LogicalUndoOperation(basePage, this.recordId, this);
    }

    public ContainerHandle getContainer() {
        return this.containerHdl;
    }

    public void resetRecordHandle(RecordHandle recordHandle) {
        this.resetPageNumber(recordHandle.getPageNumber());
        this.recordId = recordHandle.getId();
    }

    public RecordHandle getRecordHandle() {
        return new RecordId(this.getPageId(), this.recordId);
    }

    public void reclaimPrepareLocks(Transaction transaction, LockingPolicy lockingPolicy) throws StandardException {
        ContainerHandle containerHandle = transaction.openContainer(this.getPageId().getContainerId(), lockingPolicy, 196);
        if (containerHandle != null) {
            containerHandle.close();
        }
        boolean bl = lockingPolicy.lockRecordForWrite(transaction, this.getRecordHandle(), false, false);
        this.releaseResource(transaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BasePage findLogicalPage(Transaction transaction, LogicalUndo logicalUndo, LimitObjectInput limitObjectInput) throws StandardException, IOException {
        this.releaseResource(transaction);
        boolean bl = false;
        try {
            RawTransaction rawTransaction = (RawTransaction)transaction;
            this.containerHdl = rawTransaction.openDroppedContainer(this.getPageId().getContainerId(), null);
            this.page = (BasePage)logicalUndo.findUndo(transaction, this, limitObjectInput);
            bl = true;
        }
        finally {
            if (!bl && this.containerHdl != null) {
                this.containerHdl.close();
                this.containerHdl = null;
            }
        }
        this.foundHere = true;
        return this.page;
    }

    public abstract void undoMe(Transaction var1, BasePage var2, int var3, LogInstant var4, LimitObjectInput var5) throws StandardException, IOException;
}

