/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import org.apache.hadoop.hbase.ipc.HRegionInterface;
import org.apache.hadoop.hbase.util.Bytes;

public final class HConstants {
    public static final Long ZERO_L = 0L;
    public static final String NINES = "99999999999999";
    public static final String ZEROES = "00000000000000";
    public static final String VERSION_FILE_NAME = "hbase.version";
    public static final String FILE_SYSTEM_VERSION = "7";
    public static final String CLUSTER_DISTRIBUTED = "hbase.cluster.distributed";
    public static final String CLUSTER_IS_LOCAL = "false";
    public static final String CLUSTER_IS_DISTRIBUTED = "true";
    public static final String DEFAULT_HOST = "0.0.0.0";
    public static final String MASTER_PORT = "hbase.master.port";
    public static final int DEFAULT_MASTER_PORT = 60000;
    public static final int DEFAULT_MASTER_INFOPORT = 60010;
    public static final String MASTER_TYPE_BACKUP = "hbase.master.backup";
    public static final boolean DEFAULT_MASTER_TYPE_BACKUP = false;
    public static final String ZOOKEEPER_QUORUM = "hbase.zookeeper.quorum";
    public static final String ZOOKEEPER_CONFIG_NAME = "zoo.cfg";
    public static final String ZOOKEEPER_RETRIES = "zookeeper.retries";
    public static final int DEFAULT_ZOOKEEPER_RETRIES = 5;
    public static final String ZOOKEEPER_PAUSE = "zookeeper.pause";
    public static final int DEFAULT_ZOOKEEPER_PAUSE = 2000;
    public static final int DEFAULT_ZOOKEPER_CLIENT_PORT = 2181;
    public static final String ZOOKEEPER_ZNODE_PARENT = "zookeeper.znode.parent";
    public static final String DEFAULT_ZOOKEEPER_ZNODE_PARENT = "/hbase";
    public static final String REGIONSERVER_PORT = "hbase.regionserver.port";
    public static final int DEFAULT_REGIONSERVER_PORT = 60020;
    public static final int DEFAULT_REGIONSERVER_INFOPORT = 60030;
    public static final String REGION_SERVER_CLASS = "hbase.regionserver.class";
    public static final String REGION_SERVER_IMPL = "hbase.regionserver.impl";
    public static final String DEFAULT_REGION_SERVER_CLASS = HRegionInterface.class.getName();
    public static final String MASTER_IMPL = "hbase.master.impl";
    public static final String THREAD_WAKE_FREQUENCY = "hbase.server.thread.wakefrequency";
    public static final int DEFAULT_THREAD_WAKE_FREQUENCY = 10000;
    public static final String NUM_CLIENT_RETRIES = "hbase.client.retries.number";
    public static final int DEFAULT_NUM_CLIENT_RETRIES = 2;
    public static final String MAJOR_COMPACTION_PERIOD = "hbase.hregion.majorcompaction";
    public static final String HBASE_DIR = "hbase.rootdir";
    public static final String HREGION_LOGDIR_NAME = ".logs";
    public static final String HREGION_OLDLOGDIR_NAME = ".oldlogs";
    public static final String HREGION_COMPACTIONDIR_NAME = "compaction.dir";
    public static final long DEFAULT_MAX_FILE_SIZE = 0x10000000L;
    public static final int DEFAULT_SIZE_RESERVATION_BLOCK = 0x500000;
    public static final int MAXIMUM_VALUE_LENGTH = Integer.MAX_VALUE;
    public static final byte[] ROOT_TABLE_NAME = Bytes.toBytes("-ROOT-");
    public static final byte[] META_TABLE_NAME = Bytes.toBytes(".META.");
    public static final int META_ROW_DELIMITER = 44;
    public static final String CATALOG_FAMILY_STR = "info";
    public static final byte[] CATALOG_FAMILY = Bytes.toBytes("info");
    public static final byte[] REGIONINFO_QUALIFIER = Bytes.toBytes("regioninfo");
    public static final byte[] SERVER_QUALIFIER = Bytes.toBytes("server");
    public static final byte[] STARTCODE_QUALIFIER = Bytes.toBytes("serverstartcode");
    public static final byte[] SPLITA_QUALIFIER = Bytes.toBytes("splitA");
    public static final byte[] SPLITB_QUALIFIER = Bytes.toBytes("splitB");
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final byte[] EMPTY_START_ROW = EMPTY_BYTE_ARRAY;
    public static final byte[] EMPTY_END_ROW = EMPTY_START_ROW;
    public static final byte[] LAST_ROW = EMPTY_BYTE_ARRAY;
    public static final int MAX_ROW_LENGTH = Short.MAX_VALUE;
    public static final String UTF8_ENCODING = "UTF-8";
    public static final long LATEST_TIMESTAMP = Long.MAX_VALUE;
    public static final long OLDEST_TIMESTAMP = Long.MIN_VALUE;
    public static final byte[] LATEST_TIMESTAMP_BYTES = Bytes.toBytes(Long.MAX_VALUE);
    public static final int ALL_VERSIONS = Integer.MAX_VALUE;
    public static final int FOREVER = Integer.MAX_VALUE;
    public static final int WEEK_IN_SECONDS = 604800;
    public static final String HBASE_CLIENT_RETRIES_NUMBER_KEY = "hbase.client.retries.number";
    public static final String NAME = "NAME";
    public static final String VERSIONS = "VERSIONS";
    public static final String IN_MEMORY = "IN_MEMORY";
    public static int[] RETRY_BACKOFF = new int[]{1, 1, 1, 2, 2, 4, 4, 8, 16, 32};
    public static final String REGION_IMPL = "hbase.hregion.impl";
    public static final int REPLICATION_SCOPE_LOCAL = 0;
    public static final int REPLICATION_SCOPE_GLOBAL = 1;
    public static final byte DEFAULT_CLUSTER_ID = 0;
    public static String HBASE_CLIENT_SCANNER_MAX_RESULT_SIZE_KEY = "hbase.client.scanner.max.result.size";
    public static long DEFAULT_HBASE_CLIENT_SCANNER_MAX_RESULT_SIZE = Long.MAX_VALUE;
    public static String HBASE_REGIONSERVER_LEASE_PERIOD_KEY = "hbase.regionserver.lease.period";
    public static long DEFAULT_HBASE_REGIONSERVER_LEASE_PERIOD = 60000L;
    public static String HBASE_RPC_TIMEOUT_KEY = "hbase.rpc.timeout";
    public static int DEFAULT_HBASE_RPC_TIMEOUT = 60000;
    public static final String REPLICATION_ENABLE_KEY = "hbase.replication";

    private HConstants() {
    }

    public static enum Modify {
        CLOSE_REGION,
        TABLE_COMPACT,
        TABLE_FLUSH,
        TABLE_MAJOR_COMPACT,
        TABLE_SET_HTD,
        TABLE_SPLIT;

    }

    public static enum OperationStatusCode {
        NOT_RUN,
        SUCCESS,
        BAD_FAMILY,
        FAILURE;

    }
}

