/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.WritableComparable;

public class HServerAddress
implements WritableComparable<HServerAddress> {
    private InetSocketAddress address;
    String stringValue;

    public HServerAddress() {
        this.address = null;
        this.stringValue = null;
    }

    public HServerAddress(InetSocketAddress address) {
        this.address = address;
        this.stringValue = address.getAddress().getHostName() + ":" + address.getPort();
        this.checkBindAddressCanBeResolved();
    }

    public HServerAddress(String hostAndPort) {
        int colonIndex = hostAndPort.lastIndexOf(58);
        if (colonIndex < 0) {
            throw new IllegalArgumentException("Not a host:port pair: " + hostAndPort);
        }
        String host = hostAndPort.substring(0, colonIndex);
        int port = Integer.parseInt(hostAndPort.substring(colonIndex + 1));
        this.address = new InetSocketAddress(host, port);
        this.stringValue = hostAndPort;
        this.checkBindAddressCanBeResolved();
    }

    public HServerAddress(String bindAddress, int port) {
        this.address = new InetSocketAddress(bindAddress, port);
        this.stringValue = bindAddress + ":" + port;
        this.checkBindAddressCanBeResolved();
    }

    public HServerAddress(HServerAddress other) {
        String bindAddress = other.getBindAddress();
        int port = other.getPort();
        this.address = new InetSocketAddress(bindAddress, port);
        this.stringValue = other.stringValue;
        this.checkBindAddressCanBeResolved();
    }

    public String getBindAddress() {
        InetAddress addr = this.address.getAddress();
        if (addr != null) {
            return addr.getHostAddress();
        }
        LogFactory.getLog(HServerAddress.class).error((Object)("Could not resolve the DNS name of " + this.stringValue));
        return null;
    }

    private void checkBindAddressCanBeResolved() {
        if (this.getBindAddress() == null) {
            throw new IllegalArgumentException("Could not resolve the DNS name of " + this.stringValue);
        }
    }

    public int getPort() {
        return this.address.getPort();
    }

    public String getHostname() {
        return this.address.getHostName();
    }

    public InetSocketAddress getInetSocketAddress() {
        return this.address;
    }

    public String toString() {
        return this.stringValue == null ? "" : this.stringValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        return this.compareTo((HServerAddress)o) == 0;
    }

    public int hashCode() {
        int result = this.address.hashCode();
        return result ^= this.stringValue.hashCode();
    }

    public void readFields(DataInput in) throws IOException {
        String bindAddress = in.readUTF();
        int port = in.readInt();
        if (bindAddress == null || bindAddress.length() == 0) {
            this.address = null;
            this.stringValue = null;
        } else {
            this.address = new InetSocketAddress(bindAddress, port);
            this.stringValue = bindAddress + ":" + port;
            this.checkBindAddressCanBeResolved();
        }
    }

    public void write(DataOutput out) throws IOException {
        if (this.address == null) {
            out.writeUTF("");
            out.writeInt(0);
        } else {
            out.writeUTF(this.address.getAddress().getHostAddress());
            out.writeInt(this.address.getPort());
        }
    }

    public int compareTo(HServerAddress o) {
        if (this.address.equals(o.address)) {
            return 0;
        }
        return this.toString().compareTo(o.toString());
    }
}

