/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import com.google.common.primitives.Longs;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Comparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.Writable;

public class KeyValue
implements Writable,
HeapSize {
    static final Log LOG = LogFactory.getLog(KeyValue.class);
    public static final char COLUMN_FAMILY_DELIMITER = ':';
    public static final byte[] COLUMN_FAMILY_DELIM_ARRAY = new byte[]{58};
    public static KVComparator COMPARATOR = new KVComparator();
    public static KeyComparator KEY_COMPARATOR = new KeyComparator();
    public static KVComparator META_COMPARATOR = new MetaComparator();
    public static KeyComparator META_KEY_COMPARATOR = new MetaKeyComparator();
    public static KVComparator ROOT_COMPARATOR = new RootComparator();
    public static KeyComparator ROOT_KEY_COMPARATOR = new RootKeyComparator();
    public static final int TIMESTAMP_TYPE_SIZE = 9;
    public static final int KEY_INFRASTRUCTURE_SIZE = 12;
    public static final int ROW_OFFSET = 8;
    public static final int KEYVALUE_INFRASTRUCTURE_SIZE = 8;
    public static final KeyValue LOWESTKEY = new KeyValue(HConstants.EMPTY_BYTE_ARRAY, Long.MAX_VALUE);
    private byte[] bytes = null;
    private int offset = 0;
    private int length = 0;
    private byte[] rowCache = null;
    private long memstoreTS = 0L;
    private int keyLength = 0;
    private long timestampCache = -1L;

    public static KeyComparator getRowComparator(byte[] tableName) {
        if (Bytes.equals(HTableDescriptor.ROOT_TABLEDESC.getName(), tableName)) {
            return ROOT_COMPARATOR.getRawComparator();
        }
        if (Bytes.equals(HTableDescriptor.META_TABLEDESC.getName(), tableName)) {
            return META_COMPARATOR.getRawComparator();
        }
        return COMPARATOR.getRawComparator();
    }

    public long getMemstoreTS() {
        return this.memstoreTS;
    }

    public void setMemstoreTS(long memstoreTS) {
        this.memstoreTS = memstoreTS;
    }

    public KeyValue() {
    }

    public KeyValue(byte[] bytes) {
        this(bytes, 0);
    }

    public KeyValue(byte[] bytes, int offset) {
        this(bytes, offset, KeyValue.getLength(bytes, offset));
    }

    public KeyValue(byte[] bytes, int offset, int length) {
        this.bytes = bytes;
        this.offset = offset;
        this.length = length;
    }

    public KeyValue(byte[] row, long timestamp) {
        this(row, timestamp, Type.Maximum);
    }

    public KeyValue(byte[] row, long timestamp, Type type) {
        this(row, null, null, timestamp, type, null);
    }

    public KeyValue(byte[] row, byte[] family, byte[] qualifier) {
        this(row, family, qualifier, Long.MAX_VALUE, Type.Maximum);
    }

    public KeyValue(byte[] row, byte[] family, byte[] qualifier, byte[] value) {
        this(row, family, qualifier, Long.MAX_VALUE, Type.Put, value);
    }

    public KeyValue(byte[] row, byte[] family, byte[] qualifier, long timestamp, Type type) {
        this(row, family, qualifier, timestamp, type, null);
    }

    public KeyValue(byte[] row, byte[] family, byte[] qualifier, long timestamp, byte[] value) {
        this(row, family, qualifier, timestamp, Type.Put, value);
    }

    public KeyValue(byte[] row, byte[] family, byte[] qualifier, long timestamp, Type type, byte[] value) {
        this(row, family, qualifier, 0, qualifier == null ? 0 : qualifier.length, timestamp, type, value, 0, value == null ? 0 : value.length);
    }

    public KeyValue(byte[] row, byte[] family, byte[] qualifier, int qoffset, int qlength, long timestamp, Type type, byte[] value, int voffset, int vlength) {
        this(row, 0, row == null ? 0 : row.length, family, 0, family == null ? 0 : family.length, qualifier, qoffset, qlength, timestamp, type, value, voffset, vlength);
    }

    public KeyValue(byte[] row, int roffset, int rlength, byte[] family, int foffset, int flength, byte[] qualifier, int qoffset, int qlength, long timestamp, Type type, byte[] value, int voffset, int vlength) {
        this.bytes = KeyValue.createByteArray(row, roffset, rlength, family, foffset, flength, qualifier, qoffset, qlength, timestamp, type, value, voffset, vlength);
        this.length = this.bytes.length;
        this.offset = 0;
    }

    static byte[] createByteArray(byte[] row, int roffset, int rlength, byte[] family, int foffset, int flength, byte[] qualifier, int qoffset, int qlength, long timestamp, Type type, byte[] value, int voffset, int vlength) {
        if (rlength > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Row > 32767");
        }
        if (row == null) {
            throw new IllegalArgumentException("Row is null");
        }
        int n = flength = family == null ? 0 : flength;
        if (flength > 127) {
            throw new IllegalArgumentException("Family > 127");
        }
        int n2 = qlength = qualifier == null ? 0 : qlength;
        if (qlength > Integer.MAX_VALUE - rlength - flength) {
            throw new IllegalArgumentException("Qualifier > 2147483647");
        }
        long longkeylength = 12 + rlength + flength + qlength;
        if (longkeylength > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("keylength " + longkeylength + " > " + Integer.MAX_VALUE);
        }
        int keylength = (int)longkeylength;
        int n3 = vlength = value == null ? 0 : vlength;
        if (vlength > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Valuer > 2147483647");
        }
        byte[] bytes = new byte[8 + keylength + vlength];
        int pos = 0;
        pos = Bytes.putInt(bytes, pos, keylength);
        pos = Bytes.putInt(bytes, pos, vlength);
        pos = Bytes.putShort(bytes, pos, (short)(rlength & 0xFFFF));
        pos = Bytes.putBytes(bytes, pos, row, roffset, rlength);
        pos = Bytes.putByte(bytes, pos, (byte)(flength & 0xFF));
        if (flength != 0) {
            pos = Bytes.putBytes(bytes, pos, family, foffset, flength);
        }
        if (qlength != 0) {
            pos = Bytes.putBytes(bytes, pos, qualifier, qoffset, qlength);
        }
        pos = Bytes.putLong(bytes, pos, timestamp);
        pos = Bytes.putByte(bytes, pos, type.getCode());
        if (value != null && value.length > 0) {
            pos = Bytes.putBytes(bytes, pos, value, voffset, vlength);
        }
        return bytes;
    }

    static byte[] createByteArray(byte[] row, int roffset, int rlength, byte[] column, int coffset, int clength, long timestamp, Type type, byte[] value, int voffset, int vlength) {
        int delimiteroffset = 0;
        if (column != null && column.length > 0) {
            delimiteroffset = KeyValue.getFamilyDelimiterIndex(column, coffset, clength);
            if (delimiteroffset > 127) {
                throw new IllegalArgumentException("Family > 127");
            }
        } else {
            return KeyValue.createByteArray(row, roffset, rlength, null, 0, 0, null, 0, 0, timestamp, type, value, voffset, vlength);
        }
        int flength = delimiteroffset - coffset;
        int qlength = clength - flength - 1;
        return KeyValue.createByteArray(row, roffset, rlength, column, coffset, flength, column, delimiteroffset + 1, qlength, timestamp, type, value, voffset, vlength);
    }

    public boolean equals(Object other) {
        if (!(other instanceof KeyValue)) {
            return false;
        }
        KeyValue kv = (KeyValue)other;
        boolean result = Bytes.BYTES_RAWCOMPARATOR.compare(this.getBuffer(), this.getKeyOffset(), this.getKeyLength(), kv.getBuffer(), kv.getKeyOffset(), kv.getKeyLength()) == 0;
        return result;
    }

    public int hashCode() {
        byte[] b = this.getBuffer();
        int start = this.getOffset();
        int end = this.getOffset() + this.getLength();
        int h = b[start++];
        for (int i = start; i < end; ++i) {
            h = h * 13 ^ b[i];
        }
        return h;
    }

    public KeyValue clone() {
        byte[] b = new byte[this.length];
        System.arraycopy(this.bytes, this.offset, b, 0, this.length);
        KeyValue ret = new KeyValue(b, 0, b.length);
        ret.setMemstoreTS(this.memstoreTS);
        return ret;
    }

    public String toString() {
        if (this.bytes == null || this.bytes.length == 0) {
            return "empty";
        }
        return KeyValue.keyToString(this.bytes, this.offset + 8, this.getKeyLength()) + "/vlen=" + this.getValueLength();
    }

    public static String keyToString(byte[] k) {
        return KeyValue.keyToString(k, 0, k.length);
    }

    public static String keyToString(byte[] b, int o, int l) {
        if (b == null) {
            return "";
        }
        short rowlength = Bytes.toShort(b, o);
        String row = Bytes.toStringBinary(b, o + 2, rowlength);
        int columnoffset = o + 2 + 1 + rowlength;
        byte familylength = b[columnoffset - 1];
        int columnlength = l - (columnoffset - o + 9);
        String family = familylength == 0 ? "" : Bytes.toStringBinary(b, columnoffset, familylength);
        String qualifier = columnlength == 0 ? "" : Bytes.toStringBinary(b, columnoffset + familylength, columnlength - familylength);
        long timestamp = Bytes.toLong(b, o + (l - 9));
        byte type = b[o + l - 1];
        return row + "/" + family + (family != null && family.length() > 0 ? ":" : "") + qualifier + "/" + timestamp + "/" + (Object)((Object)Type.codeToType(type));
    }

    public byte[] getBuffer() {
        return this.bytes;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    private static int getLength(byte[] bytes, int offset) {
        return 8 + Bytes.toInt(bytes, offset) + Bytes.toInt(bytes, offset + 4);
    }

    public int getKeyOffset() {
        return this.offset + 8;
    }

    public String getKeyString() {
        return Bytes.toStringBinary(this.getBuffer(), this.getKeyOffset(), this.getKeyLength());
    }

    public int getKeyLength() {
        if (this.keyLength == 0) {
            this.keyLength = Bytes.toInt(this.bytes, this.offset);
        }
        return this.keyLength;
    }

    public int getValueOffset() {
        return this.getKeyOffset() + this.getKeyLength();
    }

    public int getValueLength() {
        return Bytes.toInt(this.bytes, this.offset + 4);
    }

    public int getRowOffset() {
        return this.getKeyOffset() + 2;
    }

    public short getRowLength() {
        return Bytes.toShort(this.bytes, this.getKeyOffset());
    }

    public int getFamilyOffset() {
        return this.getFamilyOffset(this.getRowLength());
    }

    public int getFamilyOffset(int rlength) {
        return this.offset + 8 + 2 + rlength + 1;
    }

    public byte getFamilyLength() {
        return this.getFamilyLength(this.getFamilyOffset());
    }

    public byte getFamilyLength(int foffset) {
        return this.bytes[foffset - 1];
    }

    public int getQualifierOffset() {
        return this.getQualifierOffset(this.getFamilyOffset());
    }

    public int getQualifierOffset(int foffset) {
        return foffset + this.getFamilyLength(foffset);
    }

    public int getQualifierLength() {
        return this.getQualifierLength(this.getRowLength(), this.getFamilyLength());
    }

    public int getQualifierLength(int rlength, int flength) {
        return this.getKeyLength() - (12 + rlength + flength);
    }

    public int getTotalColumnLength() {
        short rlength = this.getRowLength();
        int foffset = this.getFamilyOffset(rlength);
        return this.getTotalColumnLength(rlength, foffset);
    }

    public int getTotalColumnLength(int rlength, int foffset) {
        byte flength = this.getFamilyLength(foffset);
        int qlength = this.getQualifierLength(rlength, flength);
        return flength + qlength;
    }

    public int getTimestampOffset() {
        return this.getTimestampOffset(this.getKeyLength());
    }

    public int getTimestampOffset(int keylength) {
        return this.getKeyOffset() + keylength - 9;
    }

    public boolean isLatestTimestamp() {
        return Bytes.compareTo(this.getBuffer(), this.getTimestampOffset(), 8, HConstants.LATEST_TIMESTAMP_BYTES, 0, 8) == 0;
    }

    public boolean updateLatestStamp(byte[] now) {
        if (this.isLatestTimestamp()) {
            int tsOffset = this.getTimestampOffset();
            System.arraycopy(now, 0, this.bytes, tsOffset, 8);
            return true;
        }
        return false;
    }

    public byte[] getKey() {
        int keylength = this.getKeyLength();
        byte[] key = new byte[keylength];
        System.arraycopy(this.getBuffer(), this.getKeyOffset(), key, 0, keylength);
        return key;
    }

    public byte[] getValue() {
        int o = this.getValueOffset();
        int l = this.getValueLength();
        byte[] result = new byte[l];
        System.arraycopy(this.getBuffer(), o, result, 0, l);
        return result;
    }

    public byte[] getRow() {
        if (this.rowCache == null) {
            int o = this.getRowOffset();
            short l = this.getRowLength();
            this.rowCache = new byte[l];
            System.arraycopy(this.getBuffer(), o, this.rowCache, 0, l);
        }
        return this.rowCache;
    }

    public long getTimestamp() {
        if (this.timestampCache == -1L) {
            this.timestampCache = this.getTimestamp(this.getKeyLength());
        }
        return this.timestampCache;
    }

    long getTimestamp(int keylength) {
        int tsOffset = this.getTimestampOffset(keylength);
        return Bytes.toLong(this.bytes, tsOffset);
    }

    public byte getType() {
        return this.getType(this.getKeyLength());
    }

    byte getType(int keylength) {
        return this.bytes[this.offset + keylength - 1 + 8];
    }

    public boolean isDelete() {
        byte t = this.getType();
        return Type.Delete.getCode() <= t && t <= Type.DeleteFamily.getCode();
    }

    public boolean isDeleteType() {
        return this.getType() == Type.Delete.getCode();
    }

    public boolean isDeleteFamily() {
        return this.getType() == Type.DeleteFamily.getCode();
    }

    public boolean isDeleteColumnOrFamily() {
        byte t = this.getType();
        return t == Type.DeleteColumn.getCode() || t == Type.DeleteFamily.getCode();
    }

    public byte[] getFamily() {
        int o = this.getFamilyOffset();
        byte l = this.getFamilyLength(o);
        byte[] result = new byte[l];
        System.arraycopy(this.bytes, o, result, 0, l);
        return result;
    }

    public byte[] getQualifier() {
        int o = this.getQualifierOffset();
        int l = this.getQualifierLength();
        byte[] result = new byte[l];
        System.arraycopy(this.bytes, o, result, 0, l);
        return result;
    }

    public SplitKeyValue split() {
        SplitKeyValue split = new SplitKeyValue();
        int splitOffset = this.offset;
        int keyLen = Bytes.toInt(this.bytes, splitOffset);
        int valLen = Bytes.toInt(this.bytes, splitOffset += 4);
        short rowLen = Bytes.toShort(this.bytes, splitOffset += 4);
        byte[] row = new byte[rowLen];
        System.arraycopy(this.bytes, splitOffset += 2, row, 0, rowLen);
        split.setRow(row);
        byte famLen = this.bytes[splitOffset += rowLen];
        byte[] family = new byte[famLen];
        System.arraycopy(this.bytes, ++splitOffset, family, 0, famLen);
        split.setFamily(family);
        int colLen = keyLen - (rowLen + famLen + 2 + 1 + 8 + 1);
        byte[] qualifier = new byte[colLen];
        System.arraycopy(this.bytes, splitOffset += famLen, qualifier, 0, colLen);
        split.setQualifier(qualifier);
        byte[] timestamp = new byte[8];
        System.arraycopy(this.bytes, splitOffset += colLen, timestamp, 0, 8);
        split.setTimestamp(timestamp);
        byte[] type = new byte[]{this.bytes[splitOffset += 8]};
        split.setType(type);
        byte[] value = new byte[valLen];
        System.arraycopy(this.bytes, ++splitOffset, value, 0, valLen);
        split.setValue(value);
        return split;
    }

    public boolean matchingFamily(byte[] family) {
        return this.matchingFamily(family, 0, family.length);
    }

    public boolean matchingFamily(byte[] family, int offset, int length) {
        if (this.length == 0 || this.bytes.length == 0) {
            return false;
        }
        return Bytes.compareTo(family, offset, length, this.bytes, this.getFamilyOffset(), this.getFamilyLength()) == 0;
    }

    public boolean matchingFamily(KeyValue other) {
        return this.matchingFamily(other.getBuffer(), other.getFamilyOffset(), other.getFamilyLength());
    }

    public boolean matchingQualifier(byte[] qualifier) {
        return this.matchingQualifier(qualifier, 0, qualifier.length);
    }

    public boolean matchingQualifier(byte[] qualifier, int offset, int length) {
        return Bytes.compareTo(qualifier, offset, length, this.bytes, this.getQualifierOffset(), this.getQualifierLength()) == 0;
    }

    public boolean matchingQualifier(KeyValue other) {
        return this.matchingQualifier(other.getBuffer(), other.getQualifierOffset(), other.getQualifierLength());
    }

    public boolean matchingRow(byte[] row) {
        return this.matchingRow(row, 0, row.length);
    }

    public boolean matchingRow(byte[] row, int offset, int length) {
        return Bytes.compareTo(row, offset, length, this.bytes, this.getRowOffset(), this.getRowLength()) == 0;
    }

    public boolean matchingRow(KeyValue other) {
        return this.matchingRow(other.getBuffer(), other.getRowOffset(), other.getRowLength());
    }

    public boolean matchingColumnNoDelimiter(byte[] column) {
        byte fl;
        int l;
        short rl = this.getRowLength();
        int o = this.getFamilyOffset(rl);
        return Bytes.compareTo(column, 0, column.length, this.bytes, o, l = (fl = this.getFamilyLength(o)) + this.getQualifierLength(rl, fl)) == 0;
    }

    public boolean matchingColumn(byte[] family, byte[] qualifier) {
        short rl = this.getRowLength();
        int o = this.getFamilyOffset(rl);
        byte fl = this.getFamilyLength(o);
        int ql = this.getQualifierLength(rl, fl);
        if (Bytes.compareTo(family, 0, family.length, this.bytes, o, family.length) != 0) {
            return false;
        }
        if (qualifier == null || qualifier.length == 0) {
            return ql == 0;
        }
        return Bytes.compareTo(qualifier, 0, qualifier.length, this.bytes, o + fl, ql) == 0;
    }

    static int compareColumns(byte[] left, int loffset, int llength, int lfamilylength, byte[] right, int roffset, int rlength, int rfamilylength) {
        int diff = Bytes.compareTo(left, loffset, lfamilylength, right, roffset, rfamilylength);
        if (diff != 0) {
            return diff;
        }
        return Bytes.compareTo(left, loffset + lfamilylength, llength - lfamilylength, right, roffset + rfamilylength, rlength - rfamilylength);
    }

    public boolean nonNullRowAndColumn() {
        return this.getRowLength() > 0 && !this.isEmptyColumn();
    }

    public boolean isEmptyColumn() {
        return this.getQualifierLength() == 0;
    }

    public static byte[][] parseColumn(byte[] c) {
        int index = KeyValue.getDelimiter(c, 0, c.length, 58);
        if (index == -1) {
            return new byte[][]{c};
        }
        if (index == c.length - 1) {
            byte[] family = new byte[c.length - 1];
            System.arraycopy(c, 0, family, 0, family.length);
            return new byte[][]{family};
        }
        byte[][] result = new byte[2][];
        result[0] = new byte[index];
        System.arraycopy(c, 0, result[0], 0, index);
        int len = c.length - (index + 1);
        result[1] = new byte[len];
        System.arraycopy(c, index + 1, result[1], 0, len);
        return result;
    }

    public static byte[] makeColumn(byte[] family, byte[] qualifier) {
        return Bytes.add(family, COLUMN_FAMILY_DELIM_ARRAY, qualifier);
    }

    public static int getFamilyDelimiterIndex(byte[] b, int offset, int length) {
        return KeyValue.getRequiredDelimiter(b, offset, length, 58);
    }

    private static int getRequiredDelimiter(byte[] b, int offset, int length, int delimiter) {
        int index = KeyValue.getDelimiter(b, offset, length, delimiter);
        if (index < 0) {
            throw new IllegalArgumentException("No " + (char)delimiter + " in <" + Bytes.toString(b) + ">" + ", length=" + length + ", offset=" + offset);
        }
        return index;
    }

    static int getRequiredDelimiterInReverse(byte[] b, int offset, int length, int delimiter) {
        int index = KeyValue.getDelimiterInReverse(b, offset, length, delimiter);
        if (index < 0) {
            throw new IllegalArgumentException("No " + delimiter + " in <" + Bytes.toString(b) + ">" + ", length=" + length + ", offset=" + offset);
        }
        return index;
    }

    public static int getDelimiter(byte[] b, int offset, int length, int delimiter) {
        if (b == null) {
            throw new NullPointerException();
        }
        int result = -1;
        for (int i = offset; i < length + offset; ++i) {
            if (b[i] != delimiter) continue;
            result = i;
            break;
        }
        return result;
    }

    public static int getDelimiterInReverse(byte[] b, int offset, int length, int delimiter) {
        if (b == null) {
            throw new NullPointerException();
        }
        int result = -1;
        for (int i = offset + length - 1; i >= offset; --i) {
            if (b[i] != delimiter) continue;
            result = i;
            break;
        }
        return result;
    }

    public static KeyValue createLastOnRow(byte[] row) {
        return new KeyValue(row, null, null, Long.MAX_VALUE, Type.Minimum);
    }

    public static KeyValue createFirstOnRow(byte[] row) {
        return KeyValue.createFirstOnRow(row, Long.MAX_VALUE);
    }

    public static KeyValue createFirstOnRow(byte[] row, long ts) {
        return new KeyValue(row, null, null, ts, Type.Maximum);
    }

    public static KeyValue createFirstOnRow(byte[] row, byte[] c, long ts) {
        byte[][] split = KeyValue.parseColumn(c);
        return new KeyValue(row, split[0], split[1], ts, Type.Maximum);
    }

    public static KeyValue createFirstOnRow(byte[] row, byte[] family, byte[] qualifier) {
        return new KeyValue(row, family, qualifier, Long.MAX_VALUE, Type.Maximum);
    }

    public static KeyValue createFirstOnRow(byte[] row, byte[] f, byte[] q, long ts) {
        return new KeyValue(row, f, q, ts, Type.Maximum);
    }

    public static KeyValue createFirstOnRow(byte[] row, int roffset, int rlength, byte[] family, int foffset, int flength, byte[] qualifier, int qoffset, int qlength) {
        return new KeyValue(row, roffset, rlength, family, foffset, flength, qualifier, qoffset, qlength, Long.MAX_VALUE, Type.Maximum, null, 0, 0);
    }

    public static KeyValue createLastOnRow(byte[] row, int roffset, int rlength, byte[] family, int foffset, int flength, byte[] qualifier, int qoffset, int qlength) {
        return new KeyValue(row, roffset, rlength, family, foffset, flength, qualifier, qoffset, qlength, Long.MIN_VALUE, Type.Minimum, null, 0, 0);
    }

    public static KeyValue createKeyValueFromKey(byte[] b) {
        return KeyValue.createKeyValueFromKey(b, 0, b.length);
    }

    public static KeyValue createKeyValueFromKey(ByteBuffer bb) {
        return KeyValue.createKeyValueFromKey(bb.array(), bb.arrayOffset(), bb.limit());
    }

    public static KeyValue createKeyValueFromKey(byte[] b, int o, int l) {
        byte[] newb = new byte[b.length + 8];
        System.arraycopy(b, o, newb, 8, l);
        Bytes.putInt(newb, 0, b.length);
        Bytes.putInt(newb, 4, 0);
        return new KeyValue(newb);
    }

    @Override
    public long heapSize() {
        return ClassSize.align(ClassSize.OBJECT + 2 * ClassSize.REFERENCE + ClassSize.align(ClassSize.ARRAY) + ClassSize.align(this.length) + 12 + ClassSize.align(ClassSize.ARRAY) + 16);
    }

    public void readFields(int length, DataInput in) throws IOException {
        this.length = length;
        this.offset = 0;
        this.bytes = new byte[this.length];
        in.readFully(this.bytes, 0, this.length);
    }

    public void readFields(DataInput in) throws IOException {
        int length = in.readInt();
        this.readFields(length, in);
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.length);
        out.write(this.bytes, this.offset, this.length);
    }

    public static class KeyComparator
    implements RawComparator<byte[]> {
        volatile boolean ignoreTimestamp = false;
        volatile boolean ignoreType = false;

        public int compare(byte[] left, int loffset, int llength, byte[] right, int roffset, int rlength) {
            long rtimestamp;
            long ltimestamp;
            short rrowlength;
            short lrowlength = Bytes.toShort(left, loffset);
            int compare = this.compareRows(left, loffset + 2, lrowlength, right, roffset + 2, rrowlength = Bytes.toShort(right, roffset));
            if (compare != 0) {
                return compare;
            }
            int lcolumnoffset = 2 + lrowlength + 1 + loffset;
            int rcolumnoffset = 2 + rrowlength + 1 + roffset;
            int lcolumnlength = llength - 9 - (lcolumnoffset - loffset);
            int rcolumnlength = rlength - 9 - (rcolumnoffset - roffset);
            byte ltype = left[loffset + (llength - 1)];
            byte rtype = right[roffset + (rlength - 1)];
            if (lcolumnlength == 0 && ltype == Type.Minimum.getCode()) {
                return 1;
            }
            if (rcolumnlength == 0 && rtype == Type.Minimum.getCode()) {
                return -1;
            }
            compare = Bytes.compareTo(left, lcolumnoffset, lcolumnlength, right, rcolumnoffset, rcolumnlength);
            if (compare != 0) {
                return compare;
            }
            if (!this.ignoreTimestamp && (compare = this.compareTimestamps(ltimestamp = Bytes.toLong(left, loffset + (llength - 9)), rtimestamp = Bytes.toLong(right, roffset + (rlength - 9)))) != 0) {
                return compare;
            }
            if (!this.ignoreType) {
                return (0xFF & rtype) - (0xFF & ltype);
            }
            return 0;
        }

        public int compare(byte[] left, byte[] right) {
            return this.compare(left, 0, left.length, right, 0, right.length);
        }

        public int compareRows(byte[] left, int loffset, int llength, byte[] right, int roffset, int rlength) {
            return Bytes.compareTo(left, loffset, llength, right, roffset, rlength);
        }

        protected int compareColumns(byte[] left, int loffset, int llength, int lfamilylength, byte[] right, int roffset, int rlength, int rfamilylength) {
            return KeyValue.compareColumns(left, loffset, llength, lfamilylength, right, roffset, rlength, rfamilylength);
        }

        int compareTimestamps(long ltimestamp, long rtimestamp) {
            if (ltimestamp < rtimestamp) {
                return 1;
            }
            if (ltimestamp > rtimestamp) {
                return -1;
            }
            return 0;
        }
    }

    public static class MetaKeyComparator
    extends KeyComparator {
        @Override
        public int compareRows(byte[] left, int loffset, int llength, byte[] right, int roffset, int rlength) {
            int rightFarDelimiter;
            int leftFarDelimiter;
            int leftDelimiter = KeyValue.getDelimiter(left, loffset, llength, 44);
            int rightDelimiter = KeyValue.getDelimiter(right, roffset, rlength, 44);
            if (leftDelimiter < 0 && rightDelimiter >= 0) {
                return -1;
            }
            if (rightDelimiter < 0 && leftDelimiter >= 0) {
                return 1;
            }
            if (leftDelimiter < 0 && rightDelimiter < 0) {
                return 0;
            }
            int result = Bytes.compareTo(left, loffset, leftDelimiter - loffset, right, roffset, rightDelimiter - roffset);
            if (result != 0) {
                return result;
            }
            if ((result = super.compareRows(left, ++leftDelimiter, (leftFarDelimiter = KeyValue.getRequiredDelimiterInReverse(left, leftDelimiter, llength - (leftDelimiter - loffset), 44)) - leftDelimiter, right, ++rightDelimiter, (rightFarDelimiter = KeyValue.getRequiredDelimiterInReverse(right, rightDelimiter, rlength - (rightDelimiter - roffset), 44)) - rightDelimiter)) != 0) {
                return result;
            }
            result = this.compareRowid(left, ++leftFarDelimiter, llength - (leftFarDelimiter - loffset), right, ++rightFarDelimiter, rlength - (rightFarDelimiter - roffset));
            return result;
        }

        protected int compareRowid(byte[] left, int loffset, int llength, byte[] right, int roffset, int rlength) {
            return Bytes.compareTo(left, loffset, llength, right, roffset, rlength);
        }
    }

    public static class RowComparator
    implements Comparator<KeyValue> {
        final KVComparator comparator;

        public RowComparator(KVComparator c) {
            this.comparator = c;
        }

        @Override
        public int compare(KeyValue left, KeyValue right) {
            return this.comparator.compareRows(left, right);
        }
    }

    public static class RootKeyComparator
    extends MetaKeyComparator {
        @Override
        public int compareRows(byte[] left, int loffset, int llength, byte[] right, int roffset, int rlength) {
            int metalength = 7;
            int lmetaOffsetPlusDelimiter = loffset + 7;
            int leftFarDelimiter = KeyValue.getDelimiterInReverse(left, lmetaOffsetPlusDelimiter, llength - 7, 44);
            int rmetaOffsetPlusDelimiter = roffset + 7;
            int rightFarDelimiter = KeyValue.getDelimiterInReverse(right, rmetaOffsetPlusDelimiter, rlength - 7, 44);
            if (leftFarDelimiter < 0 && rightFarDelimiter >= 0) {
                return -1;
            }
            if (rightFarDelimiter < 0 && leftFarDelimiter >= 0) {
                return 1;
            }
            if (leftFarDelimiter < 0 && rightFarDelimiter < 0) {
                return 0;
            }
            int result = super.compareRows(left, lmetaOffsetPlusDelimiter, leftFarDelimiter - lmetaOffsetPlusDelimiter, right, rmetaOffsetPlusDelimiter, rightFarDelimiter - rmetaOffsetPlusDelimiter);
            if (result != 0) {
                return result;
            }
            result = this.compareRowid(left, ++leftFarDelimiter, llength - (leftFarDelimiter - loffset), right, ++rightFarDelimiter, rlength - (rightFarDelimiter - roffset));
            return result;
        }
    }

    public static class KVComparator
    implements Comparator<KeyValue> {
        private final KeyComparator rawcomparator = new KeyComparator();

        public KeyComparator getRawComparator() {
            return this.rawcomparator;
        }

        @Override
        public int compare(KeyValue left, KeyValue right) {
            int ret = this.getRawComparator().compare(left.getBuffer(), left.getOffset() + 8, left.getKeyLength(), right.getBuffer(), right.getOffset() + 8, right.getKeyLength());
            if (ret != 0) {
                return ret;
            }
            return -Longs.compare((long)left.getMemstoreTS(), (long)right.getMemstoreTS());
        }

        public int compareTimestamps(KeyValue left, KeyValue right) {
            return this.compareTimestamps(left, left.getKeyLength(), right, right.getKeyLength());
        }

        int compareTimestamps(KeyValue left, int lkeylength, KeyValue right, int rkeylength) {
            long ltimestamp = left.getTimestamp(lkeylength);
            long rtimestamp = right.getTimestamp(rkeylength);
            return this.getRawComparator().compareTimestamps(ltimestamp, rtimestamp);
        }

        public int compareRows(KeyValue left, KeyValue right) {
            return this.compareRows(left, left.getRowLength(), right, right.getRowLength());
        }

        public int compareRows(KeyValue left, short lrowlength, KeyValue right, short rrowlength) {
            return this.getRawComparator().compareRows(left.getBuffer(), left.getRowOffset(), lrowlength, right.getBuffer(), right.getRowOffset(), rrowlength);
        }

        public int compareRows(KeyValue left, byte[] row) {
            return this.getRawComparator().compareRows(left.getBuffer(), left.getRowOffset(), left.getRowLength(), row, 0, row.length);
        }

        public int compareRows(byte[] left, int loffset, int llength, byte[] right, int roffset, int rlength) {
            return this.getRawComparator().compareRows(left, loffset, llength, right, roffset, rlength);
        }

        public int compareColumns(KeyValue left, byte[] right, int roffset, int rlength, int rfamilyoffset) {
            int offset = left.getFamilyOffset();
            int length = left.getFamilyLength() + left.getQualifierLength();
            return this.getRawComparator().compareColumns(left.getBuffer(), offset, length, left.getFamilyLength(offset), right, roffset, rlength, rfamilyoffset);
        }

        int compareColumns(KeyValue left, short lrowlength, KeyValue right, short rrowlength) {
            int lfoffset = left.getFamilyOffset(lrowlength);
            int rfoffset = right.getFamilyOffset(rrowlength);
            int lclength = left.getTotalColumnLength(lrowlength, lfoffset);
            int rclength = right.getTotalColumnLength(rrowlength, rfoffset);
            byte lfamilylength = left.getFamilyLength(lfoffset);
            byte rfamilylength = right.getFamilyLength(rfoffset);
            return this.getRawComparator().compareColumns(left.getBuffer(), lfoffset, lclength, lfamilylength, right.getBuffer(), rfoffset, rclength, rfamilylength);
        }

        public boolean matchingRowColumn(KeyValue left, KeyValue right) {
            short lrowlength = left.getRowLength();
            short rrowlength = right.getRowLength();
            return left.getTimestampOffset() == right.getTimestampOffset() && this.matchingRows(left, lrowlength, right, rrowlength) && this.compareColumns(left, lrowlength, right, rrowlength) == 0;
        }

        public boolean matchingRows(KeyValue left, byte[] right) {
            return this.compareRows(left, right) == 0;
        }

        public boolean matchingRows(KeyValue left, KeyValue right) {
            short lrowlength = left.getRowLength();
            short rrowlength = right.getRowLength();
            return this.matchingRows(left, lrowlength, right, rrowlength);
        }

        public boolean matchingRows(KeyValue left, short lrowlength, KeyValue right, short rrowlength) {
            return lrowlength == rrowlength && this.compareRows(left, lrowlength, right, rrowlength) == 0;
        }

        public boolean matchingRows(byte[] left, int loffset, int llength, byte[] right, int roffset, int rlength) {
            int compare = this.compareRows(left, loffset, llength, right, roffset, rlength);
            return compare == 0;
        }

        public boolean matchingRowsGreaterTimestamp(KeyValue left, KeyValue right) {
            short rrowlength;
            short lrowlength = left.getRowLength();
            if (!this.matchingRows(left, lrowlength, right, rrowlength = right.getRowLength())) {
                return false;
            }
            return left.getTimestamp() >= right.getTimestamp();
        }

        protected Object clone() throws CloneNotSupportedException {
            return new KVComparator();
        }

        public KVComparator getComparatorIgnoringTimestamps() {
            KVComparator c = null;
            try {
                c = (KVComparator)this.clone();
                c.getRawComparator().ignoreTimestamp = true;
            }
            catch (CloneNotSupportedException e) {
                LOG.error((Object)"Not supported", (Throwable)e);
            }
            return c;
        }

        public KVComparator getComparatorIgnoringType() {
            KVComparator c = null;
            try {
                c = (KVComparator)this.clone();
                c.getRawComparator().ignoreType = true;
            }
            catch (CloneNotSupportedException e) {
                LOG.error((Object)"Not supported", (Throwable)e);
            }
            return c;
        }
    }

    public static class MetaComparator
    extends KVComparator {
        private final KeyComparator rawcomparator = new MetaKeyComparator();

        @Override
        public KeyComparator getRawComparator() {
            return this.rawcomparator;
        }

        @Override
        protected Object clone() throws CloneNotSupportedException {
            return new MetaComparator();
        }
    }

    public static class RootComparator
    extends MetaComparator {
        private final KeyComparator rawcomparator = new RootKeyComparator();

        @Override
        public KeyComparator getRawComparator() {
            return this.rawcomparator;
        }

        @Override
        protected Object clone() throws CloneNotSupportedException {
            return new RootComparator();
        }
    }

    public static class SplitKeyValue {
        private byte[][] split = new byte[6][];

        SplitKeyValue() {
        }

        public void setRow(byte[] value) {
            this.split[0] = value;
        }

        public void setFamily(byte[] value) {
            this.split[1] = value;
        }

        public void setQualifier(byte[] value) {
            this.split[2] = value;
        }

        public void setTimestamp(byte[] value) {
            this.split[3] = value;
        }

        public void setType(byte[] value) {
            this.split[4] = value;
        }

        public void setValue(byte[] value) {
            this.split[5] = value;
        }

        public byte[] getRow() {
            return this.split[0];
        }

        public byte[] getFamily() {
            return this.split[1];
        }

        public byte[] getQualifier() {
            return this.split[2];
        }

        public byte[] getTimestamp() {
            return this.split[3];
        }

        public byte[] getType() {
            return this.split[4];
        }

        public byte[] getValue() {
            return this.split[5];
        }
    }

    public static enum Type {
        Minimum(0),
        Put(4),
        Delete(8),
        DeleteColumn(12),
        DeleteFamily(14),
        Maximum(-1);

        private final byte code;

        private Type(byte c) {
            this.code = c;
        }

        public byte getCode() {
            return this.code;
        }

        public static Type codeToType(byte b) {
            for (Type t : Type.values()) {
                if (t.getCode() != b) continue;
                return t;
            }
            throw new RuntimeException("Unknown code " + b);
        }
    }
}

