/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.RegionException;
import org.apache.hadoop.hbase.RemoteExceptionHandler;
import org.apache.hadoop.hbase.UnknownRegionException;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.ipc.HMasterInterface;
import org.apache.hadoop.hbase.ipc.HRegionInterface;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.ipc.RemoteException;

public class HBaseAdmin
implements Abortable {
    private final Log LOG = LogFactory.getLog((String)this.getClass().getName());
    final HConnection connection;
    private volatile Configuration conf;
    private final long pause;
    private final int numRetries;

    public HBaseAdmin(Configuration conf) throws MasterNotRunningException, ZooKeeperConnectionException {
        this.connection = HConnectionManager.getConnection(conf);
        this.conf = conf;
        this.pause = conf.getLong("hbase.client.pause", 30000L);
        this.numRetries = conf.getInt("hbase.client.retries.number", 5);
        this.connection.getMaster();
    }

    private synchronized CatalogTracker getCatalogTracker() throws ZooKeeperConnectionException, IOException {
        CatalogTracker ct = null;
        try {
            HConnection connection = HConnectionManager.getConnection(new Configuration(this.conf));
            ct = new CatalogTracker(connection);
            ct.start();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Interrupted", e);
        }
        return ct;
    }

    private void cleanupCatalogTracker(CatalogTracker ct) {
        ct.stop();
        HConnectionManager.deleteConnection(ct.getConnection().getConfiguration(), true);
    }

    @Override
    public void abort(String why, Throwable e) {
        throw new RuntimeException(why, e);
    }

    public HConnection getConnection() {
        return this.connection;
    }

    public HMasterInterface getMaster() throws MasterNotRunningException, ZooKeeperConnectionException {
        return this.connection.getMaster();
    }

    public boolean isMasterRunning() throws MasterNotRunningException, ZooKeeperConnectionException {
        return this.connection.isMasterRunning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tableExists(String tableName) throws IOException {
        boolean b = false;
        CatalogTracker ct = this.getCatalogTracker();
        try {
            b = MetaReader.tableExists(ct, tableName);
        }
        finally {
            this.cleanupCatalogTracker(ct);
        }
        return b;
    }

    public boolean tableExists(byte[] tableName) throws IOException {
        return this.tableExists(Bytes.toString(tableName));
    }

    public HTableDescriptor[] listTables() throws IOException {
        return this.connection.listTables();
    }

    public HTableDescriptor getTableDescriptor(byte[] tableName) throws IOException {
        return this.connection.getHTableDescriptor(tableName);
    }

    private long getPauseTime(int tries) {
        int triesCount = tries;
        if (triesCount >= HConstants.RETRY_BACKOFF.length) {
            triesCount = HConstants.RETRY_BACKOFF.length - 1;
        }
        return this.pause * (long)HConstants.RETRY_BACKOFF[triesCount];
    }

    public void createTable(HTableDescriptor desc) throws IOException {
        this.createTable(desc, null);
    }

    public void createTable(HTableDescriptor desc, byte[] startKey, byte[] endKey, int numRegions) throws IOException {
        HTableDescriptor.isLegalTableName(desc.getName());
        if (numRegions < 3) {
            throw new IllegalArgumentException("Must create at least three regions");
        }
        if (Bytes.compareTo(startKey, endKey) >= 0) {
            throw new IllegalArgumentException("Start key must be smaller than end key");
        }
        byte[][] splitKeys = Bytes.split(startKey, endKey, numRegions - 3);
        if (splitKeys == null || splitKeys.length != numRegions - 1) {
            throw new IllegalArgumentException("Unable to split key range into enough regions");
        }
        this.createTable(desc, splitKeys);
    }

    public void createTable(HTableDescriptor desc, byte[][] splitKeys) throws IOException {
        HTableDescriptor.isLegalTableName(desc.getName());
        if (splitKeys != null && splitKeys.length > 1) {
            Arrays.sort(splitKeys, Bytes.BYTES_COMPARATOR);
            byte[] lastKey = null;
            for (byte[] splitKey : splitKeys) {
                if (lastKey != null && Bytes.equals(splitKey, lastKey)) {
                    throw new IllegalArgumentException("All split keys must be unique, found duplicate: " + Bytes.toStringBinary(splitKey) + ", " + Bytes.toStringBinary(lastKey));
                }
                lastKey = splitKey;
            }
        }
        this.createTableAsync(desc, splitKeys);
        for (int tries = 0; tries < this.numRetries; ++tries) {
            try {
                this.connection.locateRegion(desc.getName(), HConstants.EMPTY_START_ROW);
                break;
            }
            catch (RegionException e) {
                if (tries == this.numRetries - 1) {
                    throw e;
                }
                try {
                    Thread.sleep(this.getPauseTime(tries));
                }
                catch (InterruptedException e2) {
                    // empty catch block
                }
                continue;
            }
        }
    }

    public void createTableAsync(HTableDescriptor desc, byte[][] splitKeys) throws IOException {
        HTableDescriptor.isLegalTableName(desc.getName());
        try {
            this.getMaster().createTable(desc, splitKeys);
        }
        catch (RemoteException e) {
            throw RemoteExceptionHandler.decodeRemoteException(e);
        }
    }

    public void deleteTable(String tableName) throws IOException {
        this.deleteTable(Bytes.toBytes(tableName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTable(byte[] tableName) throws IOException {
        this.isMasterRunning();
        HTableDescriptor.isLegalTableName(tableName);
        HRegionLocation firstMetaServer = this.getFirstMetaServerForTable(tableName);
        try {
            this.getMaster().deleteTable(tableName);
        }
        catch (RemoteException e) {
            throw RemoteExceptionHandler.decodeRemoteException(e);
        }
        int batchCount = this.conf.getInt("hbase.admin.scanner.caching", 10);
        HRegionInterface server = this.connection.getHRegionConnection(firstMetaServer.getServerAddress());
        HRegionInfo info = new HRegionInfo();
        for (int tries = 0; tries < this.numRetries; ++tries) {
            long scannerId = -1L;
            try {
                Scan scan = new Scan().addColumn(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
                scannerId = server.openScanner(firstMetaServer.getRegionInfo().getRegionName(), scan);
                Result[] values = server.next(scannerId, batchCount);
                if (values == null || values.length == 0) break;
                boolean found = false;
                block21: for (Result r : values) {
                    NavigableMap<byte[], byte[]> infoValues = r.getFamilyMap(HConstants.CATALOG_FAMILY);
                    for (Map.Entry e : infoValues.entrySet()) {
                        if (!Bytes.equals((byte[])e.getKey(), HConstants.REGIONINFO_QUALIFIER)) continue;
                        info = (HRegionInfo)Writables.getWritable((byte[])e.getValue(), (Writable)info);
                        if (Bytes.equals(info.getTableDesc().getName(), tableName)) {
                            found = true;
                            continue;
                        }
                        found = false;
                        continue block21;
                    }
                }
                if (!found) {
                    break;
                }
            }
            catch (IOException ex) {
                if (tries == this.numRetries - 1) {
                    if (ex instanceof RemoteException) {
                        ex = RemoteExceptionHandler.decodeRemoteException((RemoteException)((Object)ex));
                    }
                    throw ex;
                }
            }
            finally {
                if (scannerId != -1L) {
                    try {
                        server.close(scannerId);
                    }
                    catch (Exception ex) {
                        this.LOG.warn((Object)ex);
                    }
                }
            }
            try {
                Thread.sleep(this.getPauseTime(tries));
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        this.connection.clearRegionCache(tableName);
        this.LOG.info((Object)("Deleted " + Bytes.toString(tableName)));
    }

    public void enableTable(String tableName) throws IOException {
        this.enableTable(Bytes.toBytes(tableName));
    }

    public void enableTable(byte[] tableName) throws IOException {
        this.isMasterRunning();
        boolean enabled = false;
        for (int tries = 0; tries < this.numRetries; ++tries) {
            try {
                this.getMaster().enableTable(tableName);
            }
            catch (RemoteException e) {
                throw RemoteExceptionHandler.decodeRemoteException(e);
            }
            enabled = this.isTableEnabled(tableName);
            if (enabled) break;
            long sleep = this.getPauseTime(tries);
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug((Object)("Sleeping= " + sleep + "ms, waiting for all regions to be " + "enabled in " + Bytes.toString(tableName)));
            }
            try {
                Thread.sleep(sleep);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (!this.LOG.isDebugEnabled()) continue;
            this.LOG.debug((Object)("Wake. Waiting for all regions to be enabled from " + Bytes.toString(tableName)));
        }
        if (!enabled) {
            throw new IOException("Unable to enable table " + Bytes.toString(tableName));
        }
        this.LOG.info((Object)("Enabled table " + Bytes.toString(tableName)));
    }

    public void disableTable(String tableName) throws IOException {
        this.disableTable(Bytes.toBytes(tableName));
    }

    public void disableTable(byte[] tableName) throws IOException {
        this.isMasterRunning();
        boolean disabled = false;
        for (int tries = 0; tries < this.numRetries; ++tries) {
            try {
                this.getMaster().disableTable(tableName);
            }
            catch (RemoteException e) {
                throw RemoteExceptionHandler.decodeRemoteException(e);
            }
            disabled = this.isTableDisabled(tableName);
            if (disabled) break;
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug((Object)("Sleep. Waiting for all regions to be disabled from " + Bytes.toString(tableName)));
            }
            try {
                Thread.sleep(this.getPauseTime(tries));
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (!this.LOG.isDebugEnabled()) continue;
            this.LOG.debug((Object)("Wake. Waiting for all regions to be disabled from " + Bytes.toString(tableName)));
        }
        if (!disabled) {
            throw new RegionException("Retries exhausted, it took too long to wait for the table " + Bytes.toString(tableName) + " to be disabled.");
        }
        this.LOG.info((Object)("Disabled " + Bytes.toString(tableName)));
    }

    public boolean isTableEnabled(String tableName) throws IOException {
        return this.isTableEnabled(Bytes.toBytes(tableName));
    }

    public boolean isTableEnabled(byte[] tableName) throws IOException {
        return this.connection.isTableEnabled(tableName);
    }

    public boolean isTableDisabled(byte[] tableName) throws IOException {
        return this.connection.isTableDisabled(tableName);
    }

    public boolean isTableAvailable(byte[] tableName) throws IOException {
        return this.connection.isTableAvailable(tableName);
    }

    public boolean isTableAvailable(String tableName) throws IOException {
        return this.connection.isTableAvailable(Bytes.toBytes(tableName));
    }

    public void addColumn(String tableName, HColumnDescriptor column) throws IOException {
        this.addColumn(Bytes.toBytes(tableName), column);
    }

    public void addColumn(byte[] tableName, HColumnDescriptor column) throws IOException {
        HTableDescriptor.isLegalTableName(tableName);
        try {
            this.getMaster().addColumn(tableName, column);
        }
        catch (RemoteException e) {
            throw RemoteExceptionHandler.decodeRemoteException(e);
        }
    }

    public void deleteColumn(String tableName, String columnName) throws IOException {
        this.deleteColumn(Bytes.toBytes(tableName), Bytes.toBytes(columnName));
    }

    public void deleteColumn(byte[] tableName, byte[] columnName) throws IOException {
        try {
            this.getMaster().deleteColumn(tableName, columnName);
        }
        catch (RemoteException e) {
            throw RemoteExceptionHandler.decodeRemoteException(e);
        }
    }

    public void modifyColumn(String tableName, String columnName, HColumnDescriptor descriptor) throws IOException {
        this.modifyColumn(tableName, descriptor);
    }

    public void modifyColumn(String tableName, HColumnDescriptor descriptor) throws IOException {
        this.modifyColumn(Bytes.toBytes(tableName), descriptor);
    }

    public void modifyColumn(byte[] tableName, byte[] columnName, HColumnDescriptor descriptor) throws IOException {
        this.modifyColumn(tableName, descriptor);
    }

    public void modifyColumn(byte[] tableName, HColumnDescriptor descriptor) throws IOException {
        try {
            this.getMaster().modifyColumn(tableName, descriptor);
        }
        catch (RemoteException re) {
            throw RemoteExceptionHandler.decodeRemoteException(re);
        }
    }

    public void closeRegion(String regionname, String hostAndPort) throws IOException {
        this.closeRegion(Bytes.toBytes(regionname), hostAndPort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeRegion(byte[] regionname, String hostAndPort) throws IOException {
        CatalogTracker ct = this.getCatalogTracker();
        try {
            if (hostAndPort != null) {
                HServerAddress hsa = new HServerAddress(hostAndPort);
                Pair<HRegionInfo, HServerAddress> pair = MetaReader.getRegion(ct, regionname);
                this.closeRegion(hsa, pair.getFirst());
            } else {
                Pair<HRegionInfo, HServerAddress> pair = MetaReader.getRegion(ct, regionname);
                this.closeRegion(pair.getSecond(), pair.getFirst());
            }
        }
        finally {
            this.cleanupCatalogTracker(ct);
        }
    }

    private void closeRegion(HServerAddress hsa, HRegionInfo hri) throws IOException {
        HRegionInterface rs = this.connection.getHRegionConnection(hsa);
        rs.closeRegion(hri);
    }

    public void flush(String tableNameOrRegionName) throws IOException, InterruptedException {
        this.flush(Bytes.toBytes(tableNameOrRegionName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(byte[] tableNameOrRegionName) throws IOException, InterruptedException {
        boolean isRegionName = this.isRegionName(tableNameOrRegionName);
        CatalogTracker ct = this.getCatalogTracker();
        try {
            if (isRegionName) {
                Pair<HRegionInfo, HServerAddress> pair = MetaReader.getRegion(this.getCatalogTracker(), tableNameOrRegionName);
                this.flush(pair.getSecond(), pair.getFirst());
            } else {
                List<Pair<HRegionInfo, HServerAddress>> pairs = MetaReader.getTableRegionsAndLocations(this.getCatalogTracker(), Bytes.toString(tableNameOrRegionName));
                for (Pair<HRegionInfo, HServerAddress> pair : pairs) {
                    this.flush(pair.getSecond(), pair.getFirst());
                }
            }
        }
        finally {
            this.cleanupCatalogTracker(ct);
        }
    }

    private void flush(HServerAddress hsa, HRegionInfo hri) throws IOException {
        HRegionInterface rs = this.connection.getHRegionConnection(hsa);
        rs.flushRegion(hri);
    }

    public void compact(String tableNameOrRegionName) throws IOException, InterruptedException {
        this.compact(Bytes.toBytes(tableNameOrRegionName));
    }

    public void compact(byte[] tableNameOrRegionName) throws IOException, InterruptedException {
        this.compact(tableNameOrRegionName, false);
    }

    public void majorCompact(String tableNameOrRegionName) throws IOException, InterruptedException {
        this.majorCompact(Bytes.toBytes(tableNameOrRegionName));
    }

    public void majorCompact(byte[] tableNameOrRegionName) throws IOException, InterruptedException {
        this.compact(tableNameOrRegionName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compact(byte[] tableNameOrRegionName, boolean major) throws IOException, InterruptedException {
        CatalogTracker ct = this.getCatalogTracker();
        try {
            if (this.isRegionName(tableNameOrRegionName)) {
                Pair<HRegionInfo, HServerAddress> pair = MetaReader.getRegion(ct, tableNameOrRegionName);
                this.compact(pair.getSecond(), pair.getFirst(), major);
            } else {
                List<Pair<HRegionInfo, HServerAddress>> pairs = MetaReader.getTableRegionsAndLocations(ct, Bytes.toString(tableNameOrRegionName));
                for (Pair<HRegionInfo, HServerAddress> pair : pairs) {
                    this.compact(pair.getSecond(), pair.getFirst(), major);
                }
            }
        }
        finally {
            this.cleanupCatalogTracker(ct);
        }
    }

    private void compact(HServerAddress hsa, HRegionInfo hri, boolean major) throws IOException {
        HRegionInterface rs = this.connection.getHRegionConnection(hsa);
        rs.compactRegion(hri, major);
    }

    public void move(byte[] encodedRegionName, byte[] destServerName) throws UnknownRegionException, MasterNotRunningException, ZooKeeperConnectionException {
        this.getMaster().move(encodedRegionName, destServerName);
    }

    public boolean balanceSwitch(boolean b) throws MasterNotRunningException, ZooKeeperConnectionException {
        return this.getMaster().balanceSwitch(b);
    }

    public boolean balancer() throws MasterNotRunningException, ZooKeeperConnectionException {
        return this.getMaster().balance();
    }

    public void split(String tableNameOrRegionName) throws IOException, InterruptedException {
        this.split(Bytes.toBytes(tableNameOrRegionName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void split(byte[] tableNameOrRegionName) throws IOException, InterruptedException {
        CatalogTracker ct = this.getCatalogTracker();
        try {
            if (this.isRegionName(tableNameOrRegionName)) {
                Pair<HRegionInfo, HServerAddress> pair = MetaReader.getRegion(this.getCatalogTracker(), tableNameOrRegionName);
                this.split(pair.getSecond(), pair.getFirst());
            } else {
                List<Pair<HRegionInfo, HServerAddress>> pairs = MetaReader.getTableRegionsAndLocations(this.getCatalogTracker(), Bytes.toString(tableNameOrRegionName));
                for (Pair<HRegionInfo, HServerAddress> pair : pairs) {
                    this.split(pair.getSecond(), pair.getFirst());
                }
            }
        }
        finally {
            this.cleanupCatalogTracker(ct);
        }
    }

    private void split(HServerAddress hsa, HRegionInfo hri) throws IOException {
        HRegionInterface rs = this.connection.getHRegionConnection(hsa);
        rs.splitRegion(hri);
    }

    public void modifyTable(byte[] tableName, HTableDescriptor htd) throws IOException {
        try {
            this.getMaster().modifyTable(tableName, htd);
        }
        catch (RemoteException re) {
            throw RemoteExceptionHandler.decodeRemoteException(re);
        }
    }

    private boolean isRegionName(byte[] tableNameOrRegionName) throws IOException {
        if (tableNameOrRegionName == null) {
            throw new IllegalArgumentException("Pass a table name or region name");
        }
        return !this.tableExists(tableNameOrRegionName);
    }

    public synchronized void shutdown() throws IOException {
        this.isMasterRunning();
        try {
            this.getMaster().shutdown();
        }
        catch (RemoteException e) {
            throw RemoteExceptionHandler.decodeRemoteException(e);
        }
    }

    public synchronized void stopMaster() throws IOException {
        this.isMasterRunning();
        try {
            this.getMaster().stopMaster();
        }
        catch (RemoteException e) {
            throw RemoteExceptionHandler.decodeRemoteException(e);
        }
    }

    public synchronized void stopRegionServer(HServerAddress hsa) throws IOException {
        HRegionInterface rs = this.connection.getHRegionConnection(hsa);
        rs.stop("Called by admin client " + this.connection.toString());
    }

    public ClusterStatus getClusterStatus() throws IOException {
        return this.getMaster().getClusterStatus();
    }

    private HRegionLocation getFirstMetaServerForTable(byte[] tableName) throws IOException {
        return this.connection.locateRegion(HConstants.META_TABLE_NAME, HRegionInfo.createRegionName(tableName, null, "99999999999999", false));
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    public static void checkHBaseAvailable(Configuration conf) throws MasterNotRunningException, ZooKeeperConnectionException {
        Configuration copyOfConf = HBaseConfiguration.create(conf);
        copyOfConf.setInt("hbase.client.retries.number", 1);
        new HBaseAdmin(copyOfConf);
    }
}

