/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.NavigableSet;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.HServerInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.MetaScanner;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.ipc.HMasterInterface;
import org.apache.hadoop.hbase.ipc.HRegionInterface;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Writables;

public class HBaseFsck
extends HBaseAdmin {
    public static final long DEFAULT_TIME_LAG = 60000L;
    private static final Log LOG = LogFactory.getLog((String)HBaseFsck.class.getName());
    private Configuration conf;
    private FileSystem fs;
    private Path rootDir;
    private ClusterStatus status;
    private HMasterInterface master;
    private HConnection connection;
    private TreeMap<HRegionInfo, MetaEntry> metaEntries;
    private boolean details = false;
    private long timelag = 60000L;

    public HBaseFsck(Configuration conf) throws MasterNotRunningException, ZooKeeperConnectionException, IOException {
        super(conf);
        this.conf = conf;
        this.rootDir = new Path(conf.get("hbase.rootdir"));
        this.fs = this.rootDir.getFileSystem(conf);
        this.master = this.getMaster();
        this.status = this.master.getClusterStatus();
        this.connection = this.getConnection();
        this.metaEntries = new TreeMap();
    }

    int doWork() throws IOException {
        System.out.println("Version: " + this.status.getHBaseVersion());
        this.getMetaEntries(this.metaEntries);
        AtomicInteger numSkipped = new AtomicInteger(0);
        HTableDescriptor[] allTables = this.getTables(this.metaEntries, numSkipped);
        System.out.println("Number of Tables: " + allTables.length);
        if (this.details) {
            if (numSkipped.get() > 0) {
                System.out.println("\n Number of Tables in flux: " + numSkipped.get());
            }
            for (HTableDescriptor td : allTables) {
                String tableName = td.getNameAsString();
                System.out.println("\t Table: " + tableName + "\t" + (td.isReadOnly() ? "ro" : "rw") + "\t" + (td.isRootRegion() ? "ROOT" : (td.isMetaRegion() ? "META" : "    ")) + "\t" + " families:" + td.getFamilies().size());
            }
        }
        Collection<HServerInfo> regionServers = this.status.getServerInfo();
        System.out.println("Number of live region servers:" + regionServers.size());
        if (this.details) {
            for (HServerInfo rsinfo : regionServers) {
                System.out.println("\t RegionServer:" + rsinfo.getServerName());
            }
        }
        Collection<String> deadRegionServers = this.status.getDeadServerNames();
        System.out.println("Number of dead region servers:" + deadRegionServers.size());
        if (this.details) {
            for (String name : deadRegionServers) {
                System.out.println("\t RegionServer(dead):" + name);
            }
        }
        boolean status1 = this.processRegionServers(regionServers);
        boolean status2 = this.checkHdfs();
        if (status1 && status2) {
            System.out.println("\nRest easy, buddy! HBase is clean. ");
            return 0;
        }
        System.out.println("\nInconsistencies detected.");
        return -1;
    }

    boolean checkHdfs() throws IOException {
        Path vfile;
        Path mdir;
        boolean status = true;
        TreeMap<String, MetaEntry> regions = new TreeMap<String, MetaEntry>();
        for (MetaEntry meta : this.metaEntries.values()) {
            regions.put(meta.getTableDesc().getNameAsString(), meta);
        }
        TreeMap<Path, FileStatus> allTableDirs = new TreeMap<Path, FileStatus>();
        FileStatus[] files = this.fs.listStatus(this.rootDir);
        for (int i = 0; files != null && i < files.length; ++i) {
            allTableDirs.put(files[i].getPath(), files[i]);
        }
        Path rdir = new Path(this.rootDir, Bytes.toString(HConstants.ROOT_TABLE_NAME));
        FileStatus ignore = (FileStatus)allTableDirs.remove(rdir);
        if (ignore == null) {
            status = false;
            System.out.print("\nERROR: Path " + rdir + " for ROOT table does not exist.");
        }
        if ((ignore = (FileStatus)allTableDirs.remove(mdir = new Path(this.rootDir, Bytes.toString(HConstants.META_TABLE_NAME)))) == null) {
            status = false;
            System.out.print("\nERROR: Path " + mdir + " for META table does not exist.");
        }
        if ((ignore = (FileStatus)allTableDirs.remove(vfile = new Path(this.rootDir, "hbase.version"))) == null) {
            status = false;
            System.out.print("\nERROR: Version file " + vfile + " does not exist.");
        }
        for (MetaEntry rinfo : this.metaEntries.values()) {
            Path tableDir = HTableDescriptor.getTableDir(this.rootDir, rinfo.getTableDesc().getName());
            FileStatus found = (FileStatus)allTableDirs.remove(tableDir);
            if (found == null) continue;
            regions.remove(tableDir.getName());
        }
        long now = System.currentTimeMillis();
        for (FileStatus region : allTableDirs.values()) {
            String finalComponent;
            if (region.getModificationTime() + this.timelag >= now || (finalComponent = region.getPath().getName()).startsWith(".")) continue;
            System.out.print("\nERROR: Path " + region.getPath() + " does not have a corresponding entry in META.");
            status = false;
        }
        for (MetaEntry rinfo : regions.values()) {
            System.out.println("\nERROR: Region " + rinfo.getRegionNameAsString() + " does not have a corresponding entry in HDFS.");
            status = false;
        }
        return status;
    }

    boolean processRegionServers(Collection<HServerInfo> regionServerList) throws IOException {
        TreeMap<HRegionInfo, MetaEntry> tmp = new TreeMap<HRegionInfo, MetaEntry>((SortedMap<HRegionInfo, MetaEntry>)this.metaEntries);
        long errorCount = 0L;
        int showProgress = 0;
        for (HServerInfo rsinfo : regionServerList) {
            block10: {
                ++showProgress;
                try {
                    HRegionInterface server = this.connection.getHRegionConnection(rsinfo.getServerAddress());
                    NavigableSet<HRegionInfo> regions = server.getOnlineRegions();
                    if (this.details) {
                        System.out.print("\nRegionServer:" + rsinfo.getServerName() + " number of regions:" + regions.size());
                        for (HRegionInfo rinfo : regions) {
                            System.out.print("\n\t name:" + rinfo.getRegionNameAsString() + " id:" + rinfo.getRegionId() + " encoded name:" + rinfo.getEncodedName() + " start :" + Bytes.toStringBinary(rinfo.getStartKey()) + " end :" + Bytes.toStringBinary(rinfo.getEndKey()));
                        }
                        showProgress = 0;
                    }
                    for (HRegionInfo r : regions) {
                        MetaEntry metaEntry = this.metaEntries.get((Object)r);
                        if (metaEntry == null) {
                            if (r.isMetaRegion()) continue;
                            System.out.print("\nERROR: Region " + r.getRegionNameAsString() + " found on server " + rsinfo.getServerAddress() + " but is not listed in META.");
                            ++errorCount;
                            showProgress = 0;
                            continue;
                        }
                        if (!metaEntry.regionServer.equals(rsinfo.getServerAddress())) {
                            System.out.print("\nERROR: Region " + r.getRegionNameAsString() + " found on server " + rsinfo.getServerAddress() + " but is listed in META to be on server " + metaEntry.regionServer);
                            ++errorCount;
                            showProgress = 0;
                        }
                        tmp.remove((Object)r);
                    }
                }
                catch (IOException e) {
                    if (!this.details) break block10;
                    System.out.print("\nRegionServer:" + rsinfo.getServerName() + " Unable to fetch region information. " + e);
                }
            }
            if (showProgress % 10 != 0) continue;
            System.out.print(".");
            showProgress = 0;
        }
        for (MetaEntry metaEntry : tmp.values()) {
            if (metaEntry.isOffline()) continue;
            System.out.print("\nERROR: Region " + metaEntry.getRegionNameAsString() + " is not served by any region server " + " but is listed in META to be on server " + metaEntry.regionServer);
            ++errorCount;
        }
        if (errorCount > 0L) {
            System.out.println("\nDetected " + errorCount + " inconsistencies. " + "This might not indicate a real problem because these regions " + "could be in the midst of a split. Consider re-running with a " + "larger value of -timelag.");
            return false;
        }
        return true;
    }

    HTableDescriptor[] getTables(TreeMap<HRegionInfo, MetaEntry> regionList, AtomicInteger numSkipped) {
        TreeSet<HTableDescriptor> uniqueTables = new TreeSet<HTableDescriptor>();
        long now = System.currentTimeMillis();
        for (MetaEntry m : regionList.values()) {
            MetaEntry info = m;
            if (info == null || info.getStartKey().length != 0) continue;
            if (m.modTime + this.timelag < now) {
                uniqueTables.add(info.getTableDesc());
                continue;
            }
            numSkipped.incrementAndGet();
        }
        return uniqueTables.toArray(new HTableDescriptor[uniqueTables.size()]);
    }

    void getMetaEntries(final TreeMap<HRegionInfo, MetaEntry> regionList) throws IOException {
        MetaScanner.MetaScannerVisitor visitor = new MetaScanner.MetaScannerVisitor(){
            int countRecord = 1;
            final Comparator<KeyValue> comp = new Comparator<KeyValue>(){

                @Override
                public int compare(KeyValue k1, KeyValue k2) {
                    return (int)(k1.getTimestamp() - k2.getTimestamp());
                }
            };

            @Override
            public boolean processRow(Result result) throws IOException {
                try {
                    long ts = Collections.max(result.list(), this.comp).getTimestamp();
                    byte[] value = result.getValue(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
                    HRegionInfo info = null;
                    HServerAddress server = null;
                    byte[] startCode = null;
                    if (value != null) {
                        info = Writables.getHRegionInfo(value);
                    }
                    if ((value = result.getValue(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER)) != null && value.length > 0) {
                        String address = Bytes.toString(value);
                        server = new HServerAddress(address);
                    }
                    if ((value = result.getValue(HConstants.CATALOG_FAMILY, HConstants.STARTCODE_QUALIFIER)) != null) {
                        startCode = value;
                    }
                    MetaEntry m = new MetaEntry(info, server, startCode, ts);
                    if ((m = regionList.put(m, m)) != null) {
                        throw new IOException("Two entries in META are same " + (Object)((Object)m));
                    }
                    if (this.countRecord % 100 == 0) {
                        System.out.print(".");
                    }
                    ++this.countRecord;
                    return true;
                }
                catch (RuntimeException e) {
                    LOG.error((Object)("Result=" + result));
                    throw e;
                }
            }
        };
        MetaScanner.metaScan(this.conf, visitor);
        System.out.println("");
    }

    void displayFullReport() {
        this.details = true;
    }

    void setTimeLag(long seconds) {
        this.timelag = seconds * 1000L;
    }

    protected static void printUsageAndExit() {
        System.err.println("Usage: fsck [opts] ");
        System.err.println(" where [opts] are:");
        System.err.println("   -details Display full report of all regions.");
        System.err.println("   -timelag {timeInSeconds}  Process only regions that  have not experienced any metadata updates in the last  {{timeInSeconds} seconds.");
        Runtime.getRuntime().exit(-2);
    }

    public static void main(String[] args) throws IOException, MasterNotRunningException {
        Configuration conf = HBaseConfiguration.create();
        conf.set("fs.defaultFS", conf.get("hbase.rootdir"));
        HBaseFsck fsck = new HBaseFsck(conf);
        for (int i = 0; i < args.length; ++i) {
            String cmd = args[i];
            if (cmd.equals("-details")) {
                fsck.displayFullReport();
                continue;
            }
            if (cmd.equals("-timelag")) {
                if (i == args.length - 1) {
                    System.err.println("HBaseFsck: -timelag needs a value.");
                    HBaseFsck.printUsageAndExit();
                }
                try {
                    long timelag = Long.parseLong(args[i + 1]);
                    fsck.setTimeLag(timelag);
                }
                catch (NumberFormatException e) {
                    System.err.println("-timelag needs a numeric value.");
                    HBaseFsck.printUsageAndExit();
                }
                ++i;
                continue;
            }
            String str = "Unknown command line option : " + cmd;
            LOG.info((Object)str);
            System.out.println(str);
            HBaseFsck.printUsageAndExit();
        }
        int code = fsck.doWork();
        Runtime.getRuntime().exit(code);
    }

    private static class MetaEntry
    extends HRegionInfo {
        HServerAddress regionServer;
        byte[] startCode;
        long modTime;

        public MetaEntry(HRegionInfo rinfo, HServerAddress regionServer, byte[] startCode, long modTime) {
            super(rinfo);
            this.regionServer = regionServer;
            this.startCode = startCode;
            this.modTime = modTime;
        }
    }
}

