/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.ServerCallable;
import org.apache.hadoop.hbase.ipc.HMasterInterface;
import org.apache.hadoop.hbase.ipc.HRegionInterface;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;

public interface HConnection
extends Abortable {
    public Configuration getConfiguration();

    public ZooKeeperWatcher getZooKeeperWatcher() throws IOException;

    public HMasterInterface getMaster() throws MasterNotRunningException, ZooKeeperConnectionException;

    public boolean isMasterRunning() throws MasterNotRunningException, ZooKeeperConnectionException;

    public boolean isTableEnabled(byte[] var1) throws IOException;

    public boolean isTableDisabled(byte[] var1) throws IOException;

    public boolean isTableAvailable(byte[] var1) throws IOException;

    public HTableDescriptor[] listTables() throws IOException;

    public HTableDescriptor getHTableDescriptor(byte[] var1) throws IOException;

    public HRegionLocation locateRegion(byte[] var1, byte[] var2) throws IOException;

    public void clearRegionCache();

    public void clearRegionCache(byte[] var1);

    public HRegionLocation relocateRegion(byte[] var1, byte[] var2) throws IOException;

    public HRegionLocation locateRegion(byte[] var1) throws IOException;

    public List<HRegionLocation> locateRegions(byte[] var1) throws IOException;

    public HRegionInterface getHRegionConnection(HServerAddress var1) throws IOException;

    public HRegionInterface getHRegionConnection(HServerAddress var1, boolean var2) throws IOException;

    public HRegionLocation getRegionLocation(byte[] var1, byte[] var2, boolean var3) throws IOException;

    public <T> T getRegionServerWithRetries(ServerCallable<T> var1) throws IOException, RuntimeException;

    public <T> T getRegionServerWithoutRetries(ServerCallable<T> var1) throws IOException, RuntimeException;

    public void processBatch(List<Row> var1, byte[] var2, ExecutorService var3, Result[] var4) throws IOException;

    public int processBatchOfRows(ArrayList<Put> var1, byte[] var2, ExecutorService var3) throws IOException;

    public int processBatchOfDeletes(List<Delete> var1, byte[] var2, ExecutorService var3) throws IOException;

    public void processBatchOfPuts(List<Put> var1, byte[] var2, ExecutorService var3) throws IOException;

    public void setRegionCachePrefetch(byte[] var1, boolean var2);

    public boolean getRegionCachePrefetch(byte[] var1);

    public void prewarmRegionCache(byte[] var1, Map<HRegionInfo, HServerAddress> var2);
}

