/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.HTableFactory;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.HTableInterfaceFactory;
import org.apache.hadoop.hbase.util.Bytes;

public class HTablePool {
    private final ConcurrentMap<String, LinkedList<HTableInterface>> tables = new ConcurrentHashMap<String, LinkedList<HTableInterface>>();
    private final Configuration config;
    private final int maxSize;
    private final HTableInterfaceFactory tableFactory;

    public HTablePool() {
        this(HBaseConfiguration.create(), Integer.MAX_VALUE);
    }

    public HTablePool(Configuration config, int maxSize) {
        this(config, maxSize, null);
    }

    public HTablePool(Configuration config, int maxSize, HTableInterfaceFactory tableFactory) {
        this.config = config == null ? new Configuration() : new Configuration(config);
        this.maxSize = maxSize;
        this.tableFactory = tableFactory == null ? new HTableFactory() : tableFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTableInterface getTable(String tableName) {
        HTableInterface table;
        LinkedList queue = (LinkedList)this.tables.get(tableName);
        if (queue == null) {
            queue = new LinkedList();
            this.tables.putIfAbsent(tableName, queue);
            return this.createHTable(tableName);
        }
        LinkedList linkedList = queue;
        synchronized (linkedList) {
            table = (HTableInterface)queue.poll();
        }
        if (table == null) {
            return this.createHTable(tableName);
        }
        return table;
    }

    public HTableInterface getTable(byte[] tableName) {
        return this.getTable(Bytes.toString(tableName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putTable(HTableInterface table) {
        LinkedList queue;
        LinkedList linkedList = queue = (LinkedList)this.tables.get(Bytes.toString(table.getTableName()));
        synchronized (linkedList) {
            if (queue.size() >= this.maxSize) {
                return;
            }
            queue.add(table);
        }
    }

    protected HTableInterface createHTable(String tableName) {
        return this.tableFactory.createHTableInterface(this.config, Bytes.toBytes(tableName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeTablePool(String tableName) {
        Queue queue;
        Queue queue2 = queue = (Queue)this.tables.get(tableName);
        synchronized (queue2) {
            HTableInterface table = (HTableInterface)queue.poll();
            while (table != null) {
                this.tableFactory.releaseHTableInterface(table);
                table = (HTableInterface)queue.poll();
            }
        }
        HConnectionManager.deleteConnection(this.config, true);
    }

    public void closeTablePool(byte[] tableName) {
        this.closeTablePool(Bytes.toString(tableName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getCurrentPoolSize(String tableName) {
        Queue queue;
        Queue queue2 = queue = (Queue)this.tables.get(tableName);
        synchronized (queue2) {
            return queue.size();
        }
    }
}

