/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.ScannerCallable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Writables;

public class MetaScanner {
    private static final Log LOG = LogFactory.getLog(MetaScanner.class);

    public static void metaScan(Configuration configuration, MetaScannerVisitor visitor) throws IOException {
        MetaScanner.metaScan(configuration, visitor, null);
    }

    public static void metaScan(Configuration configuration, MetaScannerVisitor visitor, byte[] tableName) throws IOException {
        MetaScanner.metaScan(configuration, visitor, tableName, null, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void metaScan(Configuration configuration, MetaScannerVisitor visitor, byte[] tableName, byte[] row, int rowLimit) throws IOException {
        byte[] startRow;
        int rowUpperLimit = rowLimit > 0 ? rowLimit : Integer.MAX_VALUE;
        HConnection connection = HConnectionManager.getConnection(configuration);
        if (row != null) {
            assert (tableName != null);
            HTable metaTable = new HTable(configuration, HConstants.META_TABLE_NAME);
            byte[] searchRow = HRegionInfo.createRegionName(tableName, row, "99999999999999", false);
            Result startRowResult = metaTable.getRowOrBefore(searchRow, HConstants.CATALOG_FAMILY);
            if (startRowResult == null) {
                throw new TableNotFoundException("Cannot find row in .META. for table: " + Bytes.toString(tableName) + ", row=" + Bytes.toString(searchRow));
            }
            byte[] value = startRowResult.getValue(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
            if (value == null || value.length == 0) {
                throw new IOException("HRegionInfo was null or empty in Meta for " + Bytes.toString(tableName) + ", row=" + Bytes.toString(searchRow));
            }
            HRegionInfo regionInfo = Writables.getHRegionInfo(value);
            byte[] rowBefore = regionInfo.getStartKey();
            startRow = HRegionInfo.createRegionName(tableName, rowBefore, "00000000000000", false);
        } else {
            startRow = tableName == null || tableName.length == 0 ? HConstants.EMPTY_START_ROW : HRegionInfo.createRegionName(tableName, HConstants.EMPTY_START_ROW, "00000000000000", false);
        }
        int rows = Math.min(rowLimit, configuration.getInt("hbase.meta.scanner.caching", 100));
        do {
            Scan scan = new Scan(startRow).addFamily(HConstants.CATALOG_FAMILY);
            byte[] metaTableName = Bytes.equals(tableName, HConstants.ROOT_TABLE_NAME) ? HConstants.ROOT_TABLE_NAME : HConstants.META_TABLE_NAME;
            LOG.debug((Object)("Scanning " + Bytes.toString(metaTableName) + " starting at row=" + Bytes.toString(startRow) + " for max=" + rowUpperLimit + " rows"));
            ScannerCallable callable = new ScannerCallable(connection, metaTableName, scan);
            connection.getRegionServerWithRetries(callable);
            int processedRows = 0;
            try {
                Result[] rrs;
                callable.setCaching(rows);
                block4: while (processedRows < rowUpperLimit && (rrs = connection.getRegionServerWithRetries(callable)) != null && rrs.length != 0 && rrs[0].size() != 0) {
                    for (Result rr : rrs) {
                        if (processedRows >= rowUpperLimit || !visitor.processRow(rr)) break block4;
                        ++processedRows;
                    }
                }
                startRow = callable.getHRegionInfo().getEndKey();
            }
            finally {
                callable.setClose();
                connection.getRegionServerWithRetries(callable);
            }
        } while (Bytes.compareTo(startRow, HConstants.LAST_ROW) != 0);
    }

    public static List<HRegionInfo> listAllRegions(Configuration conf) throws IOException {
        return MetaScanner.listAllRegions(conf, true);
    }

    public static List<HRegionInfo> listAllRegions(Configuration conf, final boolean offlined) throws IOException {
        final ArrayList<HRegionInfo> regions = new ArrayList<HRegionInfo>();
        MetaScannerVisitor visitor = new MetaScannerVisitor(){

            @Override
            public boolean processRow(Result result) throws IOException {
                if (result == null || result.isEmpty()) {
                    return true;
                }
                byte[] bytes = result.getValue(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
                if (bytes == null) {
                    LOG.warn((Object)("Null REGIONINFO_QUALIFIER: " + result));
                    return true;
                }
                HRegionInfo regionInfo = Writables.getHRegionInfo(bytes);
                if (regionInfo.isOffline() && !offlined) {
                    return true;
                }
                regions.add(regionInfo);
                return true;
            }
        };
        MetaScanner.metaScan(conf, visitor);
        return regions;
    }

    public static interface MetaScannerVisitor {
        public boolean processRow(Result var1) throws IOException;
    }
}

