/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Writable;

public class MultiPut
implements Writable {
    public HServerAddress address;
    public Map<byte[], List<Put>> puts = new TreeMap<byte[], List<Put>>(Bytes.BYTES_COMPARATOR);

    public MultiPut() {
    }

    public MultiPut(HServerAddress a) {
        this.address = a;
    }

    public int size() {
        int size = 0;
        for (List<Put> l : this.puts.values()) {
            size += l.size();
        }
        return size;
    }

    public void add(byte[] regionName, Put aPut) {
        List<Put> rsput = this.puts.get(regionName);
        if (rsput == null) {
            rsput = new ArrayList<Put>();
            this.puts.put(regionName, rsput);
        }
        rsput.add(aPut);
    }

    public Collection<Put> allPuts() {
        ArrayList<Put> res = new ArrayList<Put>();
        for (List<Put> pp : this.puts.values()) {
            res.addAll(pp);
        }
        return res;
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.puts.size());
        for (Map.Entry<byte[], List<Put>> e : this.puts.entrySet()) {
            Bytes.writeByteArray(out, e.getKey());
            List<Put> ps = e.getValue();
            out.writeInt(ps.size());
            for (Put p : ps) {
                p.write(out);
            }
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.puts.clear();
        int mapSize = in.readInt();
        for (int i = 0; i < mapSize; ++i) {
            byte[] key = Bytes.readByteArray(in);
            int listSize = in.readInt();
            ArrayList<Put> ps = new ArrayList<Put>(listSize);
            for (int j = 0; j < listSize; ++j) {
                Put put = new Put();
                put.readFields(in);
                ps.add(put);
            }
            this.puts.put(key, ps);
        }
    }
}

