/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.HbaseObjectWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.io.Writable;

public class MultiResponse
implements Writable {
    private Map<byte[], List<Pair<Integer, Result>>> results = new TreeMap<byte[], List<Pair<Integer, Result>>>(Bytes.BYTES_COMPARATOR);

    public int size() {
        int size = 0;
        for (List<Pair<Integer, Result>> c : this.results.values()) {
            size += c.size();
        }
        return size;
    }

    public void add(byte[] regionName, Pair<Integer, Result> r) {
        List<Pair<Integer, Result>> rs = this.results.get(regionName);
        if (rs == null) {
            rs = new ArrayList<Pair<Integer, Result>>();
            this.results.put(regionName, rs);
        }
        rs.add(r);
    }

    public Map<byte[], List<Pair<Integer, Result>>> getResults() {
        return this.results;
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.results.size());
        for (Map.Entry<byte[], List<Pair<Integer, Result>>> e : this.results.entrySet()) {
            Bytes.writeByteArray(out, e.getKey());
            List<Pair<Integer, Result>> lst = e.getValue();
            out.writeInt(lst.size());
            for (Pair<Integer, Result> r : lst) {
                if (r == null) {
                    out.writeInt(-1);
                    continue;
                }
                out.writeInt(r.getFirst());
                HbaseObjectWritable.writeObject(out, r.getSecond(), Result.class, null);
            }
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.results.clear();
        int mapSize = in.readInt();
        for (int i = 0; i < mapSize; ++i) {
            byte[] key = Bytes.readByteArray(in);
            int listSize = in.readInt();
            ArrayList<Pair<Integer, Result>> lst = new ArrayList<Pair<Integer, Result>>(listSize);
            for (int j = 0; j < listSize; ++j) {
                Integer idx = in.readInt();
                if (idx == -1) {
                    lst.add(null);
                    continue;
                }
                Result r = (Result)HbaseObjectWritable.readObject(in, null);
                lst.add(new Pair<Integer, Result>(idx, r));
            }
            this.results.put(key, lst);
        }
    }
}

