/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.replication;

import java.io.IOException;
import org.apache.commons.lang.NotImplementedException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.replication.ReplicationZookeeper;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

public class ReplicationAdmin {
    private final ReplicationZookeeper replicationZk;

    public ReplicationAdmin(Configuration conf) throws IOException {
        if (!conf.getBoolean("hbase.replication", false)) {
            throw new RuntimeException("hbase.replication isn't true, please enable it in order to use replication");
        }
        ZooKeeperWatcher zkw = HConnectionManager.getConnection(conf).getZooKeeperWatcher();
        try {
            this.replicationZk = new ReplicationZookeeper(conf, zkw);
        }
        catch (KeeperException e) {
            throw new IOException("Unable setup the ZooKeeper connection", e);
        }
    }

    public void addPeer(String id, String clusterKey) throws IOException {
        this.replicationZk.addPeer(id, clusterKey);
    }

    public void removePeer(String id) throws IOException {
        this.replicationZk.removePeer(id);
    }

    public void enablePeer(String id) {
        throw new NotImplementedException("Not implemented");
    }

    public void disablePeer(String id) {
        throw new NotImplementedException("Not implemented");
    }

    public int getPeersCount() {
        return this.replicationZk.listPeersIdsAndWatch().size();
    }

    public boolean getReplicating() throws IOException {
        try {
            return this.replicationZk.getReplication();
        }
        catch (KeeperException e) {
            throw new IOException("Couldn't get the replication status");
        }
    }

    public boolean setReplicating(boolean newState) throws IOException {
        boolean prev = this.getReplicating();
        this.replicationZk.setReplicating(newState);
        return prev;
    }

    ReplicationZookeeper getReplicationZk() {
        return this.replicationZk;
    }
}

