/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.SocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ipc.HBaseServer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.ObjectWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.ReflectionUtils;

public class HBaseClient {
    private static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.ipc.HBaseClient");
    protected final Hashtable<ConnectionId, Connection> connections = new Hashtable();
    protected final Class<? extends Writable> valueClass;
    protected int counter;
    protected final AtomicBoolean running = new AtomicBoolean(true);
    protected final Configuration conf;
    protected final int maxIdleTime;
    protected final int maxRetries;
    protected final long failureSleep;
    protected final boolean tcpNoDelay;
    protected final boolean tcpKeepAlive;
    protected int pingInterval;
    protected final SocketFactory socketFactory;
    private int refCount = 1;
    private static final String PING_INTERVAL_NAME = "ipc.ping.interval";
    static final int DEFAULT_PING_INTERVAL = 60000;
    static final int PING_CALL_ID = -1;

    public static void setPingInterval(Configuration conf, int pingInterval) {
        conf.setInt(PING_INTERVAL_NAME, pingInterval);
    }

    static int getPingInterval(Configuration conf) {
        return conf.getInt(PING_INTERVAL_NAME, 60000);
    }

    synchronized void incCount() {
        ++this.refCount;
    }

    synchronized void decCount() {
        --this.refCount;
    }

    synchronized boolean isZeroReference() {
        return this.refCount == 0;
    }

    public HBaseClient(Class<? extends Writable> valueClass, Configuration conf, SocketFactory factory) {
        this.valueClass = valueClass;
        this.maxIdleTime = conf.getInt("hbase.ipc.client.connection.maxidletime", 10000);
        this.maxRetries = conf.getInt("hbase.ipc.client.connect.max.retries", 0);
        this.failureSleep = conf.getInt("hbase.client.pause", 2000);
        this.tcpNoDelay = conf.getBoolean("hbase.ipc.client.tcpnodelay", false);
        this.tcpKeepAlive = conf.getBoolean("hbase.ipc.client.tcpkeepalive", true);
        this.pingInterval = HBaseClient.getPingInterval(conf);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("The ping interval is" + this.pingInterval + "ms."));
        }
        this.conf = conf;
        this.socketFactory = factory;
    }

    public HBaseClient(Class<? extends Writable> valueClass, Configuration conf) {
        this(valueClass, conf, NetUtils.getDefaultSocketFactory((Configuration)conf));
    }

    SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Stopping client");
        }
        if (!this.running.compareAndSet(true, false)) {
            return;
        }
        Hashtable<ConnectionId, Connection> hashtable = this.connections;
        synchronized (hashtable) {
            for (Connection conn : this.connections.values()) {
                conn.interrupt();
            }
        }
        while (!this.connections.isEmpty()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public Writable call(Writable param, InetSocketAddress address) throws IOException {
        return this.call(param, address, null, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Writable call(Writable param, InetSocketAddress addr, UserGroupInformation ticket, int rpcTimeout) throws IOException {
        Call call = new Call(param);
        Connection connection = this.getConnection(addr, ticket, rpcTimeout, call);
        connection.sendParam(call);
        boolean interrupted = false;
        Call call2 = call;
        synchronized (call2) {
            while (!call.done) {
                try {
                    call.wait();
                }
                catch (InterruptedException ignored) {
                    interrupted = true;
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            if (call.error != null) {
                if (call.error instanceof RemoteException) {
                    call.error.fillInStackTrace();
                    throw call.error;
                }
                throw this.wrapException(addr, call.error);
            }
            return call.value;
        }
    }

    private IOException wrapException(InetSocketAddress addr, IOException exception) {
        if (exception instanceof ConnectException) {
            return (ConnectException)new ConnectException("Call to " + addr + " failed on connection exception: " + exception).initCause(exception);
        }
        if (exception instanceof SocketTimeoutException) {
            return (SocketTimeoutException)new SocketTimeoutException("Call to " + addr + " failed on socket timeout exception: " + exception).initCause(exception);
        }
        return (IOException)new IOException("Call to " + addr + " failed on local exception: " + exception).initCause(exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Writable[] call(Writable[] params, InetSocketAddress[] addresses) throws IOException {
        ParallelResults results;
        if (addresses.length == 0) {
            return new Writable[0];
        }
        ParallelResults parallelResults = results = new ParallelResults(params.length);
        synchronized (parallelResults) {
            for (int i = 0; i < params.length; ++i) {
                ParallelCall call = new ParallelCall(params[i], results, i);
                try {
                    Connection connection = this.getConnection(addresses[i], null, 0, call);
                    connection.sendParam(call);
                    continue;
                }
                catch (IOException e) {
                    LOG.info((Object)("Calling " + addresses[i] + " caught: " + e.getMessage()), (Throwable)e);
                    --results.size;
                }
            }
            while (results.count != results.size) {
                try {
                    results.wait();
                }
                catch (InterruptedException ignored) {}
            }
            return results.values;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getConnection(InetSocketAddress addr, UserGroupInformation ticket, int rpcTimeout, Call call) throws IOException {
        Connection connection;
        if (!this.running.get()) {
            throw new IOException("The client is stopped");
        }
        ConnectionId remoteId = new ConnectionId(addr, ticket, rpcTimeout);
        do {
            Hashtable<ConnectionId, Connection> hashtable = this.connections;
            synchronized (hashtable) {
                connection = this.connections.get(remoteId);
                if (connection == null) {
                    connection = new Connection(remoteId);
                    this.connections.put(remoteId, connection);
                }
            }
        } while (!connection.addCall(call));
        connection.setupIOstreams();
        return connection;
    }

    private static class ConnectionId {
        final InetSocketAddress address;
        final UserGroupInformation ticket;
        private final int rpcTimeout;

        ConnectionId(InetSocketAddress address, UserGroupInformation ticket, int rpcTimeout) {
            this.address = address;
            this.ticket = ticket;
            this.rpcTimeout = rpcTimeout;
        }

        InetSocketAddress getAddress() {
            return this.address;
        }

        UserGroupInformation getTicket() {
            return this.ticket;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ConnectionId) {
                ConnectionId id = (ConnectionId)obj;
                return this.address.equals(id.address) && this.ticket == id.ticket && this.rpcTimeout == id.rpcTimeout;
            }
            return false;
        }

        public int hashCode() {
            return this.address.hashCode() ^ System.identityHashCode(this.ticket) ^ this.rpcTimeout;
        }
    }

    private static class ParallelResults {
        protected final Writable[] values;
        protected int size;
        protected int count;

        public ParallelResults(int size) {
            this.values = new Writable[size];
            this.size = size;
        }

        synchronized void callComplete(ParallelCall call) {
            this.values[call.index] = call.value;
            ++this.count;
            if (this.count == this.size) {
                this.notify();
            }
        }
    }

    private class ParallelCall
    extends Call {
        private final ParallelResults results;
        protected final int index;

        public ParallelCall(Writable param, ParallelResults results, int index) {
            super(param);
            this.results = results;
            this.index = index;
        }

        @Override
        protected void callComplete() {
            this.results.callComplete(this);
        }
    }

    private class Connection
    extends Thread {
        private ConnectionId remoteId;
        private Socket socket = null;
        private DataInputStream in;
        private DataOutputStream out;
        private final Hashtable<Integer, Call> calls = new Hashtable();
        private final AtomicLong lastActivity = new AtomicLong();
        protected final AtomicBoolean shouldCloseConnection = new AtomicBoolean();
        private IOException closeException;

        public Connection(InetSocketAddress address) throws IOException {
            this(new ConnectionId(address, null, 0));
        }

        public Connection(ConnectionId remoteId) throws IOException {
            if (remoteId.getAddress().isUnresolved()) {
                throw new UnknownHostException("unknown host: " + remoteId.getAddress().getHostName());
            }
            this.remoteId = remoteId;
            UserGroupInformation ticket = remoteId.getTicket();
            this.setName("IPC Client (" + HBaseClient.this.socketFactory.hashCode() + ") connection to " + remoteId.getAddress().toString() + (ticket == null ? " from an unknown user" : " from " + ticket.getUserName()));
            this.setDaemon(true);
        }

        private void touch() {
            this.lastActivity.set(System.currentTimeMillis());
        }

        protected synchronized boolean addCall(Call call) {
            if (this.shouldCloseConnection.get()) {
                return false;
            }
            this.calls.put(call.id, call);
            this.notify();
            return true;
        }

        protected synchronized void setupIOstreams() throws IOException {
            if (this.socket != null || this.shouldCloseConnection.get()) {
                return;
            }
            int ioFailures = 0;
            int timeoutFailures = 0;
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Connecting to " + this.remoteId.getAddress()));
                }
                while (true) {
                    try {
                        this.socket = HBaseClient.this.socketFactory.createSocket();
                        this.socket.setTcpNoDelay(HBaseClient.this.tcpNoDelay);
                        this.socket.setKeepAlive(HBaseClient.this.tcpKeepAlive);
                        NetUtils.connect((Socket)this.socket, (SocketAddress)this.remoteId.getAddress(), (int)20000);
                        if (this.remoteId.rpcTimeout > 0) {
                            HBaseClient.this.pingInterval = this.remoteId.rpcTimeout;
                        }
                        this.socket.setSoTimeout(HBaseClient.this.pingInterval);
                    }
                    catch (SocketTimeoutException toe) {
                        int n = timeoutFailures;
                        timeoutFailures = (short)(timeoutFailures + 1);
                        this.handleConnectionFailure(n, HBaseClient.this.maxRetries, toe);
                        continue;
                    }
                    catch (IOException ie) {
                        int n = ioFailures;
                        ioFailures = (short)(ioFailures + 1);
                        this.handleConnectionFailure(n, HBaseClient.this.maxRetries, ie);
                        continue;
                    }
                    break;
                }
                this.in = new DataInputStream(new BufferedInputStream(new PingInputStream(NetUtils.getInputStream((Socket)this.socket))));
                this.out = new DataOutputStream(new BufferedOutputStream(NetUtils.getOutputStream((Socket)this.socket)));
                this.writeHeader();
                this.touch();
                this.start();
            }
            catch (IOException e) {
                this.markClosed(e);
                this.close();
                throw e;
            }
        }

        private void handleConnectionFailure(int curRetries, int maxRetries, IOException ioe) throws IOException {
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (IOException e) {
                    LOG.warn((Object)"Not able to close a socket", (Throwable)e);
                }
            }
            this.socket = null;
            if (curRetries >= maxRetries) {
                throw ioe;
            }
            try {
                Thread.sleep(HBaseClient.this.failureSleep);
            }
            catch (InterruptedException ignored) {
                // empty catch block
            }
            LOG.info((Object)("Retrying connect to server: " + this.remoteId.getAddress() + " after sleeping " + HBaseClient.this.failureSleep + "ms. Already tried " + curRetries + " time(s)."));
        }

        private void writeHeader() throws IOException {
            this.out.write(HBaseServer.HEADER.array());
            this.out.write(3);
            DataOutputBuffer buf = new DataOutputBuffer();
            ObjectWritable.writeObject((DataOutput)buf, (Object)this.remoteId.getTicket(), UserGroupInformation.class, (Configuration)HBaseClient.this.conf);
            int bufLen = buf.getLength();
            this.out.writeInt(bufLen);
            this.out.write(buf.getData(), 0, bufLen);
        }

        private synchronized boolean waitForWork() {
            long timeout;
            if (this.calls.isEmpty() && !this.shouldCloseConnection.get() && HBaseClient.this.running.get() && (timeout = (long)HBaseClient.this.maxIdleTime - (System.currentTimeMillis() - this.lastActivity.get())) > 0L) {
                try {
                    this.wait(timeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (!this.calls.isEmpty() && !this.shouldCloseConnection.get() && HBaseClient.this.running.get()) {
                return true;
            }
            if (this.shouldCloseConnection.get()) {
                return false;
            }
            if (this.calls.isEmpty()) {
                this.markClosed(null);
                return false;
            }
            this.markClosed((IOException)new IOException().initCause(new InterruptedException()));
            return false;
        }

        public InetSocketAddress getRemoteAddress() {
            return this.remoteId.getAddress();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected synchronized void sendPing() throws IOException {
            long curTime = System.currentTimeMillis();
            if (curTime - this.lastActivity.get() >= (long)HBaseClient.this.pingInterval) {
                this.lastActivity.set(curTime);
                DataOutputStream dataOutputStream = this.out;
                synchronized (dataOutputStream) {
                    this.out.writeInt(-1);
                    this.out.flush();
                }
            }
        }

        @Override
        public void run() {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.getName() + ": starting, having connections " + HBaseClient.this.connections.size()));
            }
            try {
                while (this.waitForWork()) {
                    this.receiveResponse();
                }
            }
            catch (Throwable t) {
                LOG.warn((Object)"Unexpected exception receiving call responses", t);
                this.markClosed(new IOException("Unexpected exception receiving call responses", t));
            }
            this.close();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.getName() + ": stopped, remaining connections " + HBaseClient.this.connections.size()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void sendParam(Call call) {
            if (this.shouldCloseConnection.get()) {
                return;
            }
            DataOutputBuffer d = null;
            try {
                DataOutputStream dataOutputStream = this.out;
                synchronized (dataOutputStream) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(this.getName() + " sending #" + call.id));
                    }
                    d = new DataOutputBuffer();
                    d.writeInt(-559038737);
                    d.writeInt(call.id);
                    call.param.write((DataOutput)d);
                    byte[] data = d.getData();
                    int dataLength = d.getLength();
                    Bytes.putInt(data, 0, dataLength - 4);
                    this.out.write(data, 0, dataLength);
                    this.out.flush();
                }
                IOUtils.closeStream((Closeable)d);
            }
            catch (IOException e) {
                this.markClosed(e);
            }
            finally {
                IOUtils.closeStream(d);
            }
        }

        private void receiveResponse() {
            if (this.shouldCloseConnection.get()) {
                return;
            }
            this.touch();
            try {
                int id = this.in.readInt();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(this.getName() + " got value #" + id));
                }
                Call call = this.calls.get(id);
                boolean isError = this.in.readBoolean();
                if (isError) {
                    call.setException((IOException)((Object)new RemoteException(WritableUtils.readString((DataInput)this.in), WritableUtils.readString((DataInput)this.in))));
                    this.calls.remove(id);
                } else {
                    Writable value = (Writable)ReflectionUtils.newInstance(HBaseClient.this.valueClass, (Configuration)HBaseClient.this.conf);
                    value.readFields((DataInput)this.in);
                    call.setValue(value);
                    this.calls.remove(id);
                }
            }
            catch (IOException e) {
                this.markClosed(e);
            }
        }

        private synchronized void markClosed(IOException e) {
            if (this.shouldCloseConnection.compareAndSet(false, true)) {
                this.closeException = e;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void close() {
            if (!this.shouldCloseConnection.get()) {
                LOG.error((Object)"The connection is not in the closed state");
                return;
            }
            Hashtable<ConnectionId, Connection> hashtable = HBaseClient.this.connections;
            synchronized (hashtable) {
                if (HBaseClient.this.connections.get(this.remoteId) == this) {
                    HBaseClient.this.connections.remove(this.remoteId);
                }
            }
            IOUtils.closeStream((Closeable)this.out);
            IOUtils.closeStream((Closeable)this.in);
            if (this.closeException == null) {
                if (!this.calls.isEmpty()) {
                    LOG.warn((Object)"A connection is closed for no cause and calls are not empty");
                    this.closeException = new IOException("Unexpected closed connection");
                    this.cleanupCalls();
                }
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("closing ipc connection to " + this.remoteId.address + ": " + this.closeException.getMessage()), (Throwable)this.closeException);
                }
                this.cleanupCalls();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.getName() + ": closed"));
            }
        }

        private void cleanupCalls() {
            Iterator<Map.Entry<Integer, Call>> itor = this.calls.entrySet().iterator();
            while (itor.hasNext()) {
                Call c = itor.next().getValue();
                c.setException(this.closeException);
                itor.remove();
            }
        }

        private class PingInputStream
        extends FilterInputStream {
            protected PingInputStream(InputStream in) {
                super(in);
            }

            private void handleTimeout(SocketTimeoutException e) throws IOException {
                if (Connection.this.shouldCloseConnection.get() || !HBaseClient.this.running.get() || Connection.this.remoteId.rpcTimeout > 0) {
                    throw e;
                }
                Connection.this.sendPing();
            }

            @Override
            public int read() throws IOException {
                while (true) {
                    try {
                        return super.read();
                    }
                    catch (SocketTimeoutException e) {
                        this.handleTimeout(e);
                        continue;
                    }
                    break;
                }
            }

            @Override
            public int read(byte[] buf, int off, int len) throws IOException {
                while (true) {
                    try {
                        return super.read(buf, off, len);
                    }
                    catch (SocketTimeoutException e) {
                        this.handleTimeout(e);
                        continue;
                    }
                    break;
                }
            }
        }
    }

    private class Call {
        final int id;
        final Writable param;
        Writable value;
        IOException error;
        boolean done;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Call(Writable param) {
            this.param = param;
            HBaseClient hBaseClient2 = HBaseClient.this;
            synchronized (hBaseClient2) {
                this.id = HBaseClient.this.counter++;
            }
        }

        protected synchronized void callComplete() {
            this.done = true;
            this.notify();
        }

        public synchronized void setException(IOException error) {
            this.error = error;
            this.callComplete();
        }

        public synchronized void setValue(Writable value) {
            this.value = value;
            this.callComplete();
        }
    }
}

