/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.Map;
import javax.net.SocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.io.HbaseObjectWritable;
import org.apache.hadoop.hbase.ipc.HBaseClient;
import org.apache.hadoop.hbase.ipc.HBaseServer;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.ipc.VersionedProtocol;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;

public class HBaseRPC {
    protected static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.ipc.HbaseRPC");
    protected static final ClientCache CLIENTS = new ClientCache();

    private HBaseRPC() {
    }

    public static VersionedProtocol waitForProxy(Class protocol, long clientVersion, InetSocketAddress addr, Configuration conf, int maxAttempts, int rpcTimeout, long timeout) throws IOException {
        long startTime = System.currentTimeMillis();
        int reconnectAttempts = 0;
        while (true) {
            IOException ioe;
            try {
                return HBaseRPC.getProxy(protocol, clientVersion, addr, conf, rpcTimeout);
            }
            catch (ConnectException se) {
                ioe = se;
                if (maxAttempts >= 0 && ++reconnectAttempts >= maxAttempts) {
                    LOG.info((Object)("Server at " + addr + " could not be reached after " + reconnectAttempts + " tries, giving up."));
                    throw new RetriesExhaustedException("Failed setting up proxy " + protocol + " to " + addr.toString() + " after attempts=" + reconnectAttempts, se);
                }
            }
            catch (SocketTimeoutException te) {
                LOG.info((Object)("Problem connecting to server: " + addr));
                ioe = te;
            }
            if (System.currentTimeMillis() - timeout >= startTime) {
                throw ioe;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ie) {
            }
        }
    }

    public static VersionedProtocol getProxy(Class<?> protocol, long clientVersion, InetSocketAddress addr, Configuration conf, SocketFactory factory, int rpcTimeout) throws IOException {
        return HBaseRPC.getProxy(protocol, clientVersion, addr, null, conf, factory, rpcTimeout);
    }

    public static VersionedProtocol getProxy(Class<?> protocol, long clientVersion, InetSocketAddress addr, UserGroupInformation ticket, Configuration conf, SocketFactory factory, int rpcTimeout) throws IOException {
        VersionedProtocol proxy = (VersionedProtocol)Proxy.newProxyInstance(protocol.getClassLoader(), new Class[]{protocol}, (InvocationHandler)new Invoker(addr, ticket, conf, factory, rpcTimeout));
        long serverVersion = proxy.getProtocolVersion(protocol.getName(), clientVersion);
        if (serverVersion == clientVersion) {
            return proxy;
        }
        throw new VersionMismatch(protocol.getName(), clientVersion, serverVersion);
    }

    public static VersionedProtocol getProxy(Class<?> protocol, long clientVersion, InetSocketAddress addr, Configuration conf, int rpcTimeout) throws IOException {
        return HBaseRPC.getProxy(protocol, clientVersion, addr, conf, NetUtils.getDefaultSocketFactory((Configuration)conf), rpcTimeout);
    }

    public static void stopProxy(VersionedProtocol proxy) {
        if (proxy != null) {
            ((Invoker)Proxy.getInvocationHandler(proxy)).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object[] call(Method method, Object[][] params, InetSocketAddress[] addrs, Configuration conf) throws IOException {
        Writable[] invocations = new Invocation[params.length];
        for (int i = 0; i < params.length; ++i) {
            invocations[i] = new Invocation(method, params[i]);
        }
        HBaseClient client = CLIENTS.getClient(conf);
        try {
            Writable[] wrappedValues = client.call(invocations, addrs);
            if (method.getReturnType() == Void.TYPE) {
                Object[] objectArray = null;
                return objectArray;
            }
            Object[] values = (Object[])Array.newInstance(method.getReturnType(), wrappedValues.length);
            for (int i = 0; i < values.length; ++i) {
                if (wrappedValues[i] == null) continue;
                values[i] = ((HbaseObjectWritable)wrappedValues[i]).get();
            }
            Object[] objectArray = values;
            return objectArray;
        }
        finally {
            CLIENTS.stopClient(client);
        }
    }

    public static Server getServer(Object instance, Class<?>[] ifaces, String bindAddress, int port, int numHandlers, int metaHandlerCount, boolean verbose, Configuration conf, int highPriorityLevel) throws IOException {
        return new Server(instance, ifaces, conf, bindAddress, port, numHandlers, metaHandlerCount, verbose, highPriorityLevel);
    }

    protected static void log(String value) {
        String v = value;
        if (v != null && v.length() > 55) {
            v = v.substring(0, 55) + "...";
        }
        LOG.info((Object)v);
    }

    public static class Server
    extends HBaseServer {
        private Object instance;
        private Class<?> implementation;
        private Class<?>[] ifaces;
        private boolean verbose;

        private static String classNameBase(String className) {
            String[] names = className.split("\\.", -1);
            if (names == null || names.length == 0) {
                return className;
            }
            return names[names.length - 1];
        }

        public Server(Object instance, Class<?>[] ifaces, Configuration conf, String bindAddress, int port, int numHandlers, int metaHandlerCount, boolean verbose, int highPriorityLevel) throws IOException {
            super(bindAddress, port, Invocation.class, numHandlers, metaHandlerCount, conf, Server.classNameBase(instance.getClass().getName()), highPriorityLevel);
            this.instance = instance;
            this.implementation = instance.getClass();
            this.verbose = verbose;
            this.ifaces = ifaces;
            this.rpcMetrics.createMetrics(this.ifaces);
        }

        @Override
        public Writable call(Writable param, long receivedTime) throws IOException {
            try {
                Invocation call = (Invocation)param;
                if (call.getMethodName() == null) {
                    throw new IOException("Could not find requested method, the usual cause is a version mismatch between client and server.");
                }
                if (this.verbose) {
                    HBaseRPC.log("Call: " + call);
                }
                Method method = this.implementation.getMethod(call.getMethodName(), call.getParameterClasses());
                long startTime = System.currentTimeMillis();
                Object value = method.invoke(this.instance, call.getParameters());
                int processingTime = (int)(System.currentTimeMillis() - startTime);
                int qTime = (int)(startTime - receivedTime);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Served: " + call.getMethodName() + " queueTime= " + qTime + " procesingTime= " + processingTime));
                }
                this.rpcMetrics.rpcQueueTime.inc((long)qTime);
                this.rpcMetrics.rpcProcessingTime.inc((long)processingTime);
                this.rpcMetrics.inc(call.getMethodName(), processingTime);
                if (this.verbose) {
                    HBaseRPC.log("Return: " + value);
                }
                return new HbaseObjectWritable(method.getReturnType(), value);
            }
            catch (InvocationTargetException e) {
                Throwable target = e.getTargetException();
                if (target instanceof IOException) {
                    throw (IOException)target;
                }
                IOException ioe = new IOException(target.toString());
                ioe.setStackTrace(target.getStackTrace());
                throw ioe;
            }
            catch (Throwable e) {
                IOException ioe = new IOException(e.toString());
                ioe.setStackTrace(e.getStackTrace());
                throw ioe;
            }
        }
    }

    public static class VersionMismatch
    extends IOException {
        private String interfaceName;
        private long clientVersion;
        private long serverVersion;

        public VersionMismatch(String interfaceName, long clientVersion, long serverVersion) {
            super("Protocol " + interfaceName + " version mismatch. (client = " + clientVersion + ", server = " + serverVersion + ")");
            this.interfaceName = interfaceName;
            this.clientVersion = clientVersion;
            this.serverVersion = serverVersion;
        }

        public String getInterfaceName() {
            return this.interfaceName;
        }

        public long getClientVersion() {
            return this.clientVersion;
        }

        public long getServerVersion() {
            return this.serverVersion;
        }
    }

    private static class Invoker
    implements InvocationHandler {
        private InetSocketAddress address;
        private UserGroupInformation ticket;
        private HBaseClient client;
        private boolean isClosed = false;
        private final int rpcTimeout;

        public Invoker(InetSocketAddress address, UserGroupInformation ticket, Configuration conf, SocketFactory factory, int rpcTimeout) {
            this.address = address;
            this.ticket = ticket;
            this.client = CLIENTS.getClient(conf, factory);
            this.rpcTimeout = rpcTimeout;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            boolean logDebug = LOG.isDebugEnabled();
            long startTime = 0L;
            if (logDebug) {
                startTime = System.currentTimeMillis();
            }
            HbaseObjectWritable value = (HbaseObjectWritable)this.client.call(new Invocation(method, args), this.address, this.ticket, this.rpcTimeout);
            if (logDebug) {
                long callTime = System.currentTimeMillis() - startTime;
                LOG.debug((Object)("Call: " + method.getName() + " " + callTime));
            }
            return value.get();
        }

        protected synchronized void close() {
            if (!this.isClosed) {
                this.isClosed = true;
                CLIENTS.stopClient(this.client);
            }
        }
    }

    private static class ClientCache {
        private Map<SocketFactory, HBaseClient> clients = new HashMap<SocketFactory, HBaseClient>();

        protected ClientCache() {
        }

        protected synchronized HBaseClient getClient(Configuration conf, SocketFactory factory) {
            HBaseClient client = this.clients.get(factory);
            if (client == null) {
                client = new HBaseClient(HbaseObjectWritable.class, conf, factory);
                this.clients.put(factory, client);
            } else {
                client.incCount();
            }
            return client;
        }

        protected synchronized HBaseClient getClient(Configuration conf) {
            return this.getClient(conf, SocketFactory.getDefault());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void stopClient(HBaseClient client) {
            ClientCache clientCache = this;
            synchronized (clientCache) {
                client.decCount();
                if (client.isZeroReference()) {
                    this.clients.remove(client.getSocketFactory());
                }
            }
            if (client.isZeroReference()) {
                client.stop();
            }
        }
    }

    public static class Invocation
    implements Writable,
    Configurable {
        private String methodName;
        private Class[] parameterClasses;
        private Object[] parameters;
        private Configuration conf;

        public Invocation() {
        }

        public Invocation(Method method, Object[] parameters) {
            this.methodName = method.getName();
            this.parameterClasses = method.getParameterTypes();
            this.parameters = parameters;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public Class[] getParameterClasses() {
            return this.parameterClasses;
        }

        public Object[] getParameters() {
            return this.parameters;
        }

        public void readFields(DataInput in) throws IOException {
            this.methodName = in.readUTF();
            this.parameters = new Object[in.readInt()];
            this.parameterClasses = new Class[this.parameters.length];
            HbaseObjectWritable objectWritable = new HbaseObjectWritable();
            for (int i = 0; i < this.parameters.length; ++i) {
                this.parameters[i] = HbaseObjectWritable.readObject(in, objectWritable, this.conf);
                this.parameterClasses[i] = objectWritable.getDeclaredClass();
            }
        }

        public void write(DataOutput out) throws IOException {
            out.writeUTF(this.methodName);
            out.writeInt(this.parameterClasses.length);
            for (int i = 0; i < this.parameterClasses.length; ++i) {
                HbaseObjectWritable.writeObject(out, this.parameters[i], this.parameterClasses[i], this.conf);
            }
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder(256);
            buffer.append(this.methodName);
            buffer.append("(");
            for (int i = 0; i < this.parameters.length; ++i) {
                if (i != 0) {
                    buffer.append(", ");
                }
                buffer.append(this.parameters[i]);
            }
            buffer.append(")");
            return buffer.toString();
        }

        public void setConf(Configuration conf) {
            this.conf = conf;
        }

        public Configuration getConf() {
            return this.conf;
        }
    }
}

