/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.ipc.HBaseRPCProtocolVersion;
import org.apache.hadoop.hbase.ipc.HBaseRPCStatistics;
import org.apache.hadoop.hbase.ipc.HMasterInterface;
import org.apache.hadoop.hbase.ipc.HMasterRegionInterface;
import org.apache.hadoop.hbase.ipc.HRegionInterface;
import org.apache.hadoop.metrics.MetricsContext;
import org.apache.hadoop.metrics.MetricsRecord;
import org.apache.hadoop.metrics.MetricsUtil;
import org.apache.hadoop.metrics.Updater;
import org.apache.hadoop.metrics.util.MetricsRegistry;
import org.apache.hadoop.metrics.util.MetricsTimeVaryingRate;

public class HBaseRpcMetrics
implements Updater {
    private MetricsRecord metricsRecord;
    private static Log LOG = LogFactory.getLog(HBaseRpcMetrics.class);
    private final HBaseRPCStatistics rpcStatistics;
    public final MetricsRegistry registry = new MetricsRegistry();
    public MetricsTimeVaryingRate rpcQueueTime = new MetricsTimeVaryingRate("RpcQueueTime", this.registry);
    public MetricsTimeVaryingRate rpcProcessingTime = new MetricsTimeVaryingRate("RpcProcessingTime", this.registry);

    public HBaseRpcMetrics(String hostName, String port) {
        MetricsContext context = MetricsUtil.getContext((String)"rpc");
        this.metricsRecord = MetricsUtil.createRecord((MetricsContext)context, (String)"metrics");
        this.metricsRecord.setTag("port", port);
        LOG.info((Object)("Initializing RPC Metrics with hostName=" + hostName + ", port=" + port));
        context.registerUpdater((Updater)this);
        this.initMethods(HMasterInterface.class);
        this.initMethods(HMasterRegionInterface.class);
        this.initMethods(HRegionInterface.class);
        this.rpcStatistics = new HBaseRPCStatistics(this.registry, hostName, port);
    }

    private void initMethods(Class<? extends HBaseRPCProtocolVersion> protocol) {
        for (Method m : protocol.getDeclaredMethods()) {
            if (this.get(m.getName()) != null) continue;
            this.create(m.getName());
        }
    }

    private MetricsTimeVaryingRate get(String key) {
        return (MetricsTimeVaryingRate)this.registry.get(key);
    }

    private MetricsTimeVaryingRate create(String key) {
        return new MetricsTimeVaryingRate(key, this.registry);
    }

    public void inc(String name, int amt) {
        MetricsTimeVaryingRate m = this.get(name);
        if (m == null) {
            LOG.warn((Object)("Got inc() request for method that doesnt exist: " + name));
            return;
        }
        m.inc((long)amt);
    }

    public void createMetrics(Class<?>[] ifaces) {
        for (Class<?> iface : ifaces) {
            Method[] methods;
            for (Method method : methods = iface.getMethods()) {
                if (this.get(method.getName()) != null) continue;
                this.create(method.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUpdates(MetricsContext context) {
        this.rpcQueueTime.pushMetric(this.metricsRecord);
        this.rpcProcessingTime.pushMetric(this.metricsRecord);
        MetricsRegistry metricsRegistry = this.registry;
        synchronized (metricsRegistry) {
            for (String metricName : this.registry.getKeyList()) {
                MetricsTimeVaryingRate value = (MetricsTimeVaryingRate)this.registry.get(metricName);
                value.pushMetric(this.metricsRecord);
            }
        }
        this.metricsRecord.update();
    }

    public void shutdown() {
        if (this.rpcStatistics != null) {
            this.rpcStatistics.shutdown();
        }
    }
}

