/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.util.List;
import java.util.TreeSet;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.mapreduce.Reducer;

public class PutSortReducer
extends Reducer<ImmutableBytesWritable, Put, ImmutableBytesWritable, KeyValue> {
    protected void reduce(ImmutableBytesWritable row, Iterable<Put> puts, Reducer.Context context) throws IOException, InterruptedException {
        TreeSet<KeyValue> map = new TreeSet<KeyValue>(KeyValue.COMPARATOR);
        for (Put p : puts) {
            for (List<KeyValue> kvs : p.getFamilyMap().values()) {
                for (KeyValue kv : kvs) {
                    map.add(kv.clone());
                }
            }
        }
        context.setStatus("Read " + map.getClass());
        int index = 0;
        for (KeyValue kv : map) {
            context.write((Object)row, (Object)kv);
            if (index <= 0 || index % 100 != 0) continue;
            context.setStatus("Wrote " + index);
        }
    }
}

