/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Chore;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HServerInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.catalog.RootLocationEditor;
import org.apache.hadoop.hbase.client.MetaScanner;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.executor.RegionTransitionData;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.master.handler.ClosedRegionHandler;
import org.apache.hadoop.hbase.master.handler.OpenedRegionHandler;
import org.apache.hadoop.hbase.master.handler.ServerShutdownHandler;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZKTableDisable;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperListener;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;

public class AssignmentManager
extends ZooKeeperListener {
    private static final Log LOG = LogFactory.getLog(AssignmentManager.class);
    protected Server master;
    private ServerManager serverManager;
    private CatalogTracker catalogTracker;
    private TimeoutMonitor timeoutMonitor;
    final ConcurrentSkipListMap<String, RegionState> regionsInTransition = new ConcurrentSkipListMap();
    final ConcurrentNavigableMap<String, LoadBalancer.RegionPlan> regionPlans = new ConcurrentSkipListMap<String, LoadBalancer.RegionPlan>();
    private final Set<String> disabledTables = Collections.synchronizedSet(new HashSet());
    private final NavigableMap<HServerInfo, List<HRegionInfo>> servers = new TreeMap<HServerInfo, List<HRegionInfo>>();
    private final SortedMap<HRegionInfo, HServerInfo> regions = new TreeMap<HRegionInfo, HServerInfo>();
    private final org.apache.hadoop.hbase.executor.ExecutorService executorService;

    public AssignmentManager(Server master, ServerManager serverManager, CatalogTracker catalogTracker, org.apache.hadoop.hbase.executor.ExecutorService service) {
        super(master.getZooKeeper());
        this.master = master;
        this.serverManager = serverManager;
        this.catalogTracker = catalogTracker;
        this.executorService = service;
        Configuration conf = master.getConfiguration();
        this.timeoutMonitor = new TimeoutMonitor(conf.getInt("hbase.master.assignment.timeoutmonitor.period", 10000), master, conf.getInt("hbase.master.assignment.timeoutmonitor.timeout", 30000));
        Threads.setDaemonThreadRunning(this.timeoutMonitor, master.getServerName() + ".timeoutMonitor");
    }

    void cleanoutUnassigned() throws IOException, KeeperException {
        ZKAssign.deleteAllNodes(this.watcher);
        ZKUtil.listChildrenAndWatchForNewChildren(this.watcher, this.watcher.assignmentZNode);
    }

    void processFailover() throws KeeperException, IOException {
        Map<HServerInfo, List<Pair<HRegionInfo, Result>>> deadServers = this.rebuildUserRegions();
        this.rebuildDisabledTables();
        this.processDeadServers(deadServers);
        List<String> nodes = ZKUtil.listChildrenAndWatchForNewChildren(this.watcher, this.watcher.assignmentZNode);
        if (nodes.isEmpty()) {
            LOG.info((Object)"No regions in transition in ZK to process on failover");
            return;
        }
        LOG.info((Object)("Failed-over master needs to process " + nodes.size() + " regions in transition"));
        for (String encodedRegionName : nodes) {
            this.processRegionInTransition(encodedRegionName, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean processRegionInTransitionAndBlockUntilAssigned(HRegionInfo hri) throws InterruptedException, KeeperException, IOException {
        boolean intransistion = this.processRegionInTransition(hri.getEncodedName(), hri);
        if (!intransistion) {
            return intransistion;
        }
        ConcurrentSkipListMap<String, RegionState> concurrentSkipListMap = this.regionsInTransition;
        synchronized (concurrentSkipListMap) {
            while (!this.master.isStopped() && this.regionsInTransition.containsKey(hri.getEncodedName())) {
                this.regionsInTransition.wait();
            }
        }
        return intransistion;
    }

    boolean processRegionInTransition(String encodedRegionName, HRegionInfo regionInfo) throws KeeperException, IOException {
        RegionTransitionData data = ZKAssign.getData(this.watcher, encodedRegionName);
        if (data == null) {
            return false;
        }
        HRegionInfo hri = regionInfo != null ? regionInfo : MetaReader.getRegion(this.catalogTracker, data.getRegionName()).getFirst();
        this.processRegionsInTransition(data, hri);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processRegionsInTransition(RegionTransitionData data, HRegionInfo regionInfo) throws KeeperException {
        String encodedRegionName = regionInfo.getEncodedName();
        LOG.info((Object)("Processing region " + regionInfo.getRegionNameAsString() + " in state " + (Object)((Object)data.getEventType())));
        ConcurrentSkipListMap<String, RegionState> concurrentSkipListMap = this.regionsInTransition;
        synchronized (concurrentSkipListMap) {
            switch (data.getEventType()) {
                case RS_ZK_REGION_CLOSING: {
                    this.regionsInTransition.put(encodedRegionName, new RegionState(regionInfo, RegionState.State.CLOSING, data.getStamp()));
                    break;
                }
                case RS_ZK_REGION_CLOSED: {
                    this.regionsInTransition.put(encodedRegionName, new RegionState(regionInfo, RegionState.State.CLOSED, data.getStamp()));
                    new ClosedRegionHandler(this.master, this, regionInfo).process();
                    break;
                }
                case M_ZK_REGION_OFFLINE: {
                    this.regionsInTransition.put(encodedRegionName, new RegionState(regionInfo, RegionState.State.OFFLINE, data.getStamp()));
                    new ClosedRegionHandler(this.master, this, regionInfo).process();
                    break;
                }
                case RS_ZK_REGION_OPENING: {
                    this.regionsInTransition.put(encodedRegionName, new RegionState(regionInfo, RegionState.State.OPENING, data.getStamp()));
                    break;
                }
                case RS_ZK_REGION_OPENED: {
                    this.regionsInTransition.put(encodedRegionName, new RegionState(regionInfo, RegionState.State.OPENING, data.getStamp()));
                    HServerInfo hsi = this.serverManager.getServerInfo(data.getServerName());
                    if (hsi == null) {
                        LOG.warn((Object)("Region in transition " + regionInfo.getEncodedName() + " references a server no longer up " + data.getServerName() + "; letting RIT timeout so will be assigned elsewhere"));
                        break;
                    }
                    new OpenedRegionHandler(this.master, this, regionInfo, hsi).process();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRegion(RegionTransitionData data) {
        ConcurrentSkipListMap<String, RegionState> concurrentSkipListMap = this.regionsInTransition;
        synchronized (concurrentSkipListMap) {
            if (!this.serverManager.isServerOnline(data.getServerName()) && !this.master.getServerName().equals(data.getServerName())) {
                LOG.warn((Object)("Attempted to handle region transition for server but server is not online: " + data.getRegionName()));
                return;
            }
            String encodedName = HRegionInfo.encodeRegionName(data.getRegionName());
            String prettyPrintedRegionName = HRegionInfo.prettyPrint(encodedName);
            LOG.debug((Object)("Handling transition=" + (Object)((Object)data.getEventType()) + ", server=" + data.getServerName() + ", region=" + prettyPrintedRegionName));
            RegionState regionState = this.regionsInTransition.get(encodedName);
            switch (data.getEventType()) {
                case M_ZK_REGION_OFFLINE: {
                    break;
                }
                case RS_ZK_REGION_CLOSING: {
                    if (regionState == null || !regionState.isPendingClose() && !regionState.isClosing()) {
                        LOG.warn((Object)("Received CLOSING for region " + prettyPrintedRegionName + " from server " + data.getServerName() + " but region was in " + " the state " + regionState + " and not " + "in expected PENDING_CLOSE or CLOSING states"));
                        return;
                    }
                    regionState.update(RegionState.State.CLOSING, data.getStamp());
                    break;
                }
                case RS_ZK_REGION_CLOSED: {
                    if (regionState == null || !regionState.isPendingClose() && !regionState.isClosing()) {
                        LOG.warn((Object)("Received CLOSED for region " + prettyPrintedRegionName + " from server " + data.getServerName() + " but region was in " + " the state " + regionState + " and not " + "in expected PENDING_CLOSE or CLOSING states"));
                        return;
                    }
                    regionState.update(RegionState.State.CLOSED, data.getStamp());
                    this.executorService.submit(new ClosedRegionHandler(this.master, this, regionState.getRegion()));
                    break;
                }
                case RS_ZK_REGION_OPENING: {
                    if (regionState == null || !regionState.isPendingOpen() && !regionState.isOpening()) {
                        LOG.warn((Object)("Received OPENING for region " + prettyPrintedRegionName + " from server " + data.getServerName() + " but region was in " + " the state " + regionState + " and not " + "in expected PENDING_OPEN or OPENING states"));
                        return;
                    }
                    regionState.update(RegionState.State.OPENING, data.getStamp());
                    break;
                }
                case RS_ZK_REGION_OPENED: {
                    if (regionState == null || !regionState.isPendingOpen() && !regionState.isOpening()) {
                        LOG.warn((Object)("Received OPENED for region " + prettyPrintedRegionName + " from server " + data.getServerName() + " but region was in " + " the state " + regionState + " and not " + "in expected PENDING_OPEN or OPENING states"));
                        return;
                    }
                    regionState.update(RegionState.State.OPEN, data.getStamp());
                    this.executorService.submit(new OpenedRegionHandler(this.master, this, regionState.getRegion(), this.serverManager.getServerInfo(data.getServerName())));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nodeCreated(String path) {
        if (path.startsWith(this.watcher.assignmentZNode)) {
            ConcurrentSkipListMap<String, RegionState> concurrentSkipListMap = this.regionsInTransition;
            synchronized (concurrentSkipListMap) {
                try {
                    RegionTransitionData data = ZKAssign.getData(this.watcher, path);
                    if (data == null) {
                        return;
                    }
                    this.handleRegion(data);
                }
                catch (KeeperException e) {
                    this.master.abort("Unexpected ZK exception reading unassigned node data", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nodeDataChanged(String path) {
        if (path.startsWith(this.watcher.assignmentZNode)) {
            ConcurrentSkipListMap<String, RegionState> concurrentSkipListMap = this.regionsInTransition;
            synchronized (concurrentSkipListMap) {
                try {
                    RegionTransitionData data = ZKAssign.getData(this.watcher, path);
                    if (data == null) {
                        return;
                    }
                    this.handleRegion(data);
                }
                catch (KeeperException e) {
                    this.master.abort("Unexpected ZK exception reading unassigned node data", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nodeChildrenChanged(String path) {
        if (path.equals(this.watcher.assignmentZNode)) {
            ConcurrentSkipListMap<String, RegionState> concurrentSkipListMap = this.regionsInTransition;
            synchronized (concurrentSkipListMap) {
                try {
                    List<ZKUtil.NodeAndData> newNodes = ZKUtil.watchAndGetNewChildren(this.watcher, this.watcher.assignmentZNode);
                    for (ZKUtil.NodeAndData newNode : newNodes) {
                        LOG.debug((Object)("Handling new unassigned node: " + newNode));
                        this.handleRegion(RegionTransitionData.fromBytes(newNode.getData()));
                    }
                }
                catch (KeeperException e) {
                    this.master.abort("Unexpected ZK exception reading unassigned children", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void regionOnline(HRegionInfo regionInfo, HServerInfo serverInfo) {
        SortedMap<Object, Object> sortedMap = this.regionsInTransition;
        synchronized (sortedMap) {
            RegionState rs = this.regionsInTransition.remove(regionInfo.getEncodedName());
            if (rs != null) {
                this.regionsInTransition.notifyAll();
            }
        }
        sortedMap = this.regions;
        synchronized (sortedMap) {
            HServerInfo hsi = (HServerInfo)this.regions.get((Object)regionInfo);
            if (hsi != null) {
                LOG.warn((Object)("Overwriting " + regionInfo.getEncodedName() + " on " + hsi));
            }
            this.regions.put(regionInfo, serverInfo);
            this.addToServers(serverInfo, regionInfo);
        }
        this.regionPlans.remove(regionInfo.getEncodedName());
        this.updateTimers(serverInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTimers(HServerInfo hsi) {
        for (Map.Entry e : this.regionPlans.entrySet()) {
            if (!((LoadBalancer.RegionPlan)e.getValue()).getDestination().equals(hsi)) continue;
            RegionState rs = null;
            Object object = this.regionsInTransition;
            synchronized (object) {
                rs = this.regionsInTransition.get(e.getKey());
            }
            if (rs == null) continue;
            object = rs;
            synchronized (object) {
                rs.update(rs.getState());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void regionOffline(HRegionInfo regionInfo) {
        ConcurrentSkipListMap<String, RegionState> concurrentSkipListMap = this.regionsInTransition;
        synchronized (concurrentSkipListMap) {
            if (this.regionsInTransition.remove(regionInfo.getEncodedName()) != null) {
                this.regionsInTransition.notifyAll();
            }
        }
        this.setOffline(regionInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOffline(HRegionInfo regionInfo) {
        SortedMap<HRegionInfo, HServerInfo> sortedMap = this.regions;
        synchronized (sortedMap) {
            HServerInfo serverInfo = (HServerInfo)this.regions.remove((Object)regionInfo);
            if (serverInfo != null) {
                List serverRegions = (List)this.servers.get(serverInfo);
                if (!serverRegions.remove((Object)regionInfo)) {
                    LOG.warn((Object)("Asked offline a region that was not on expected server: " + (Object)((Object)regionInfo) + ", " + serverInfo.getServerName()));
                }
            } else {
                LOG.warn((Object)("Asked offline a region that was not online: " + (Object)((Object)regionInfo)));
            }
        }
    }

    public void offlineDisabledRegion(HRegionInfo regionInfo) {
        LOG.debug((Object)("Table being disabled so deleting ZK node and removing from regions in transition, skipping assignment of region " + regionInfo.getRegionNameAsString()));
        try {
            if (!ZKAssign.deleteClosedNode(this.watcher, regionInfo.getEncodedName())) {
                ZKAssign.deleteOfflineNode(this.watcher, regionInfo.getEncodedName());
            }
        }
        catch (KeeperException.NoNodeException nne) {
            LOG.debug((Object)("Tried to delete closed node for " + (Object)((Object)regionInfo) + " but it " + "does not exist so just offlining"));
        }
        catch (KeeperException e) {
            this.master.abort("Error deleting CLOSED node in ZK", e);
        }
        this.regionOffline(regionInfo);
    }

    public void assign(HRegionInfo region, boolean setOfflineInZK) {
        this.assign(region, setOfflineInZK, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assign(HRegionInfo region, boolean setOfflineInZK, boolean forceNewPlan) {
        RegionState state;
        String tableName = region.getTableDesc().getNameAsString();
        if (this.isTableDisabled(tableName)) {
            LOG.info((Object)("Table " + tableName + " disabled; skipping assign of " + region.getRegionNameAsString()));
            this.offlineDisabledRegion(region);
            return;
        }
        if (this.serverManager.isClusterShutdown()) {
            LOG.info((Object)("Cluster shutdown is set; skipping assign of " + region.getRegionNameAsString()));
            return;
        }
        RegionState regionState = state = this.addToRegionsInTransition(region);
        synchronized (regionState) {
            this.assign(state, setOfflineInZK, forceNewPlan);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assign(HServerInfo destination, List<HRegionInfo> regions) {
        LOG.debug((Object)("Bulk assigning " + regions.size() + " region(s) to " + destination.getServerName()));
        ArrayList<RegionState> states = new ArrayList<RegionState>(regions.size());
        ConcurrentSkipListMap<String, RegionState> concurrentSkipListMap = this.regionsInTransition;
        synchronized (concurrentSkipListMap) {
            for (HRegionInfo region : regions) {
                states.add(this.forceRegionStateToOffline(region));
            }
        }
        AtomicInteger counter = new AtomicInteger(0);
        CreateUnassignedAsyncCallback cb = new CreateUnassignedAsyncCallback(this.watcher, destination, counter);
        for (RegionState state : states) {
            if (this.asyncSetOfflineInZooKeeper(state, cb, state)) continue;
            return;
        }
        int total = regions.size();
        int oldCounter = 0;
        while (true) {
            int count;
            if (oldCounter != (count = counter.get())) {
                LOG.info((Object)(destination.getServerName() + " unassigned znodes=" + count + " of total=" + total));
                oldCounter = count;
            }
            if (count == total) break;
            Threads.sleep(1);
        }
        try {
            this.serverManager.sendRegionOpen(destination, regions);
        }
        catch (Throwable t) {
            this.master.abort("Failed assignment of regions to " + destination, t);
            return;
        }
        LOG.debug((Object)("Bulk assigning done for " + destination.getServerName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RegionState addToRegionsInTransition(HRegionInfo region) {
        ConcurrentSkipListMap<String, RegionState> concurrentSkipListMap = this.regionsInTransition;
        synchronized (concurrentSkipListMap) {
            return this.forceRegionStateToOffline(region);
        }
    }

    private RegionState forceRegionStateToOffline(HRegionInfo region) {
        String encodedName = region.getEncodedName();
        RegionState state = this.regionsInTransition.get(encodedName);
        if (state == null) {
            state = new RegionState(region, RegionState.State.OFFLINE);
            this.regionsInTransition.put(encodedName, state);
        } else {
            LOG.debug((Object)("Forcing OFFLINE; was=" + state));
            state.update(RegionState.State.OFFLINE);
        }
        return state;
    }

    private void assign(RegionState state, boolean setOfflineInZK, boolean forceNewPlan) {
        if (setOfflineInZK && !this.setOfflineInZooKeeper(state)) {
            return;
        }
        if (this.master.isStopped()) {
            LOG.debug((Object)("Server stopped; skipping assign of " + state));
            return;
        }
        LoadBalancer.RegionPlan plan = this.getRegionPlan(state, forceNewPlan);
        if (plan == null) {
            return;
        }
        try {
            LOG.debug((Object)("Assigning region " + state.getRegion().getRegionNameAsString() + " to " + plan.getDestination().getServerName()));
            state.update(RegionState.State.PENDING_OPEN);
            this.serverManager.sendRegionOpen(plan.getDestination(), state.getRegion());
        }
        catch (Throwable t) {
            LOG.warn((Object)("Failed assignment of " + state.getRegion().getRegionNameAsString() + " to " + plan.getDestination() + ", trying to assign elsewhere instead"), t);
            state.update(RegionState.State.OFFLINE);
            if (this.getRegionPlan(state, plan.getDestination(), true) == null) {
                LOG.warn((Object)("Unable to find a viable location to assign region " + state.getRegion().getRegionNameAsString()));
                return;
            }
            this.assign(state, false, false);
        }
    }

    boolean setOfflineInZooKeeper(RegionState state) {
        if (!state.isClosed() && !state.isOffline()) {
            new RuntimeException("Unexpected state trying to OFFLINE; " + state);
            this.master.abort("Unexpected state trying to OFFLINE; " + state, new IllegalStateException());
            return false;
        }
        state.update(RegionState.State.OFFLINE);
        try {
            if (!ZKAssign.createOrForceNodeOffline(this.master.getZooKeeper(), state.getRegion(), this.master.getServerName())) {
                LOG.warn((Object)("Attempted to create/force node into OFFLINE state before completing assignment but failed to do so for " + state));
                return false;
            }
        }
        catch (KeeperException e) {
            this.master.abort("Unexpected ZK exception creating/setting node OFFLINE", e);
            return false;
        }
        return true;
    }

    boolean asyncSetOfflineInZooKeeper(RegionState state, AsyncCallback.StringCallback cb, Object ctx) {
        if (!state.isClosed() && !state.isOffline()) {
            new RuntimeException("Unexpected state trying to OFFLINE; " + state);
            this.master.abort("Unexpected state trying to OFFLINE; " + state, new IllegalStateException());
            return false;
        }
        state.update(RegionState.State.OFFLINE);
        try {
            ZKAssign.asyncCreateNodeOffline(this.master.getZooKeeper(), state.getRegion(), this.master.getServerName(), cb, ctx);
        }
        catch (KeeperException e) {
            this.master.abort("Unexpected ZK exception creating/setting node OFFLINE", e);
            return false;
        }
        return true;
    }

    LoadBalancer.RegionPlan getRegionPlan(RegionState state, boolean forceNewPlan) {
        return this.getRegionPlan(state, null, forceNewPlan);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LoadBalancer.RegionPlan getRegionPlan(RegionState state, HServerInfo serverToExclude, boolean forceNewPlan) {
        String encodedName = state.getRegion().getEncodedName();
        List<HServerInfo> servers = this.serverManager.getOnlineServersList();
        if (serverToExclude != null) {
            servers.remove(serverToExclude);
        }
        if (servers.size() <= 0) {
            return null;
        }
        LoadBalancer.RegionPlan randomPlan = new LoadBalancer.RegionPlan(state.getRegion(), null, LoadBalancer.randomAssignment(servers));
        ConcurrentNavigableMap<String, LoadBalancer.RegionPlan> concurrentNavigableMap = this.regionPlans;
        synchronized (concurrentNavigableMap) {
            LoadBalancer.RegionPlan existingPlan = (LoadBalancer.RegionPlan)this.regionPlans.get(encodedName);
            if (existingPlan == null || forceNewPlan || existingPlan.getDestination().equals(serverToExclude)) {
                LOG.debug((Object)("No previous transition plan was found (or we are ignoring an existing plan) for " + state.getRegion().getRegionNameAsString() + " so generated a random one; " + randomPlan + "; " + this.serverManager.countOfRegionServers() + " (online=" + this.serverManager.getOnlineServers().size() + ", exclude=" + serverToExclude + ") available servers"));
                this.regionPlans.put(encodedName, randomPlan);
                return randomPlan;
            }
            LOG.debug((Object)("Using pre-exisitng plan for region " + state.getRegion().getRegionNameAsString() + "; plan=" + existingPlan));
            return existingPlan;
        }
    }

    public void unassign(HRegionInfo region) {
        this.unassign(region, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unassign(HRegionInfo region, boolean force) {
        RegionState state;
        LOG.debug((Object)("Starting unassignment of region " + region.getRegionNameAsString() + " (offlining)"));
        if (!this.regions.containsKey((Object)region)) {
            LOG.debug((Object)("Attempted to unassign region " + region.getRegionNameAsString() + " but it is not " + "currently assigned anywhere"));
            return;
        }
        String encodedName = region.getEncodedName();
        ConcurrentSkipListMap<String, RegionState> concurrentSkipListMap = this.regionsInTransition;
        synchronized (concurrentSkipListMap) {
            state = this.regionsInTransition.get(encodedName);
            if (state == null) {
                state = new RegionState(region, RegionState.State.PENDING_CLOSE);
                this.regionsInTransition.put(encodedName, state);
            } else if (force && state.isPendingClose()) {
                LOG.debug((Object)("Attempting to unassign region " + region.getRegionNameAsString() + " which is already pending close " + "but forcing an additional close"));
                state.update(RegionState.State.PENDING_CLOSE);
            } else {
                LOG.debug((Object)("Attempting to unassign region " + region.getRegionNameAsString() + " but it is " + "already in transition (" + (Object)((Object)state.getState()) + ")"));
                return;
            }
        }
        HServerInfo server = null;
        SortedMap<HRegionInfo, HServerInfo> sortedMap = this.regions;
        synchronized (sortedMap) {
            server = (HServerInfo)this.regions.get((Object)region);
        }
        try {
            if (this.serverManager.sendRegionClose(server, state.getRegion())) {
                LOG.debug((Object)("Sent CLOSE to " + server + " for region " + region.getRegionNameAsString()));
                return;
            }
            LOG.debug((Object)("Server " + server + " region CLOSE RPC returned false"));
        }
        catch (NotServingRegionException nsre) {
            LOG.debug((Object)("Server " + server + " returned NotServingRegionException"));
        }
        catch (RemoteException re) {
            if (re.unwrapRemoteException() instanceof NotServingRegionException) {
                LOG.debug((Object)("Server " + server + " returned NotServingRegionException"));
            } else {
                this.master.abort("Remote unexpected exception", re.unwrapRemoteException());
            }
        }
        catch (Throwable t) {
            this.master.abort("Remote unexpected exception", t);
        }
        LOG.debug((Object)("Attempted to send CLOSE to " + server + " for region " + region.getRegionNameAsString() + " but failed, " + "setting region as OFFLINE and reassigning"));
        sortedMap = this.regionsInTransition;
        synchronized (sortedMap) {
            this.forceRegionStateToOffline(region);
        }
        this.assign(region, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForAssignment(HRegionInfo regionInfo) throws InterruptedException {
        SortedMap<HRegionInfo, HServerInfo> sortedMap = this.regions;
        synchronized (sortedMap) {
            while (!this.regions.containsKey((Object)regionInfo)) {
                this.regions.wait();
            }
        }
    }

    public void assignRoot() throws KeeperException {
        RootLocationEditor.deleteRootLocation(this.master.getZooKeeper());
        this.assign(HRegionInfo.ROOT_REGIONINFO, true);
    }

    public void assignMeta() {
        this.assign(HRegionInfo.FIRST_META_REGIONINFO, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assignAllUserRegions() throws IOException {
        List<HRegionInfo> allRegions = MetaScanner.listAllRegions(this.master.getConfiguration(), false);
        if (allRegions == null || allRegions.isEmpty()) {
            return;
        }
        List<HServerInfo> servers = this.serverManager.getOnlineServersList();
        LOG.info((Object)("Bulk assigning " + allRegions.size() + " region(s) across " + servers.size() + " server(s)"));
        Map<HServerInfo, List<HRegionInfo>> bulkPlan = LoadBalancer.bulkAssignment(allRegions, servers);
        ThreadFactoryBuilder builder = new ThreadFactoryBuilder();
        builder.setDaemon(true);
        builder.setNameFormat(this.master.getServerName() + "-BulkAssigner-%1$d");
        builder.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                AssignmentManager.this.master.abort("Uncaught exception bulk assigning in " + t.getName(), e);
            }
        });
        int threadCount = this.master.getConfiguration().getInt("hbase.bulk.assignment.threadpool.size", 20);
        ExecutorService pool = Executors.newFixedThreadPool(threadCount, builder.build());
        this.timeoutMonitor.bulkAssign(true);
        try {
            for (Map.Entry<HServerInfo, List<HRegionInfo>> e : bulkPlan.entrySet()) {
                pool.execute(new SingleServerBulkAssigner(e.getKey(), e.getValue()));
            }
            try {
                long timeout = this.master.getConfiguration().getInt("hbase.bulk.assignment.waiton.empty.rit", 600000);
                this.waitUntilNoRegionsInTransition(timeout);
            }
            catch (InterruptedException e) {
                LOG.error((Object)"Interrupted waiting for regions to be assigned", (Throwable)e);
                throw new IOException(e);
            }
        }
        finally {
            pool.shutdown();
            this.timeoutMonitor.bulkAssign(false);
        }
        LOG.info((Object)"Bulk assigning done");
    }

    private Map<HServerInfo, List<Pair<HRegionInfo, Result>>> rebuildUserRegions() throws IOException {
        List<Result> results = MetaReader.fullScanOfResults(this.catalogTracker);
        TreeMap<HServerInfo, List<Pair<HRegionInfo, Result>>> offlineServers = new TreeMap<HServerInfo, List<Pair<HRegionInfo, Result>>>();
        for (Result result : results) {
            Pair<HRegionInfo, HServerInfo> region = MetaReader.metaRowToRegionPairWithInfo(result);
            HServerInfo regionLocation = region.getSecond();
            HRegionInfo regionInfo = region.getFirst();
            if (regionLocation == null) {
                this.regions.put(regionInfo, null);
                continue;
            }
            if (!this.serverManager.isServerOnline(regionLocation.getServerName())) {
                ArrayList<Pair<HRegionInfo, Result>> offlineRegions = (ArrayList<Pair<HRegionInfo, Result>>)offlineServers.get(regionLocation);
                if (offlineRegions == null) {
                    offlineRegions = new ArrayList<Pair<HRegionInfo, Result>>(1);
                    offlineServers.put(regionLocation, offlineRegions);
                }
                offlineRegions.add(new Pair<HRegionInfo, Result>(regionInfo, result));
                continue;
            }
            this.regions.put(regionInfo, regionLocation);
            this.addToServers(regionLocation, regionInfo);
        }
        return offlineServers;
    }

    private void processDeadServers(Map<HServerInfo, List<Pair<HRegionInfo, Result>>> deadServers) throws IOException, KeeperException {
        for (Map.Entry<HServerInfo, List<Pair<HRegionInfo, Result>>> deadServer : deadServers.entrySet()) {
            List<Pair<HRegionInfo, Result>> regions = deadServer.getValue();
            for (Pair<HRegionInfo, Result> region : regions) {
                HRegionInfo regionInfo = region.getFirst();
                Result result = region.getSecond();
                try {
                    ZKAssign.createOrForceNodeOffline(this.watcher, regionInfo, this.master.getServerName());
                }
                catch (KeeperException.NoNodeException nne) {
                    // empty catch block
                }
                ServerShutdownHandler.processDeadRegion(regionInfo, result, this, this.catalogTracker);
            }
        }
    }

    private void addToServers(HServerInfo hsi, HRegionInfo hri) {
        ArrayList<HRegionInfo> hris = (ArrayList<HRegionInfo>)this.servers.get(hsi);
        if (hris == null) {
            hris = new ArrayList<HRegionInfo>();
            this.servers.put(hsi, hris);
        }
        hris.add(hri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilNoRegionsInTransition(long timeout) throws InterruptedException {
        long startTime = System.currentTimeMillis();
        long remaining = timeout;
        ConcurrentSkipListMap<String, RegionState> concurrentSkipListMap = this.regionsInTransition;
        synchronized (concurrentSkipListMap) {
            while (this.regionsInTransition.size() > 0 && !this.master.isStopped() && remaining > 0L) {
                this.regionsInTransition.wait(remaining);
                remaining = timeout - (System.currentTimeMillis() - startTime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NavigableMap<String, RegionState> getRegionsInTransition() {
        ConcurrentSkipListMap<String, RegionState> concurrentSkipListMap = this.regionsInTransition;
        synchronized (concurrentSkipListMap) {
            return new TreeMap<String, RegionState>((SortedMap<String, RegionState>)this.regionsInTransition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRegionsInTransition() {
        ConcurrentSkipListMap<String, RegionState> concurrentSkipListMap = this.regionsInTransition;
        synchronized (concurrentSkipListMap) {
            return !this.regionsInTransition.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegionState isRegionInTransition(HRegionInfo hri) {
        ConcurrentSkipListMap<String, RegionState> concurrentSkipListMap = this.regionsInTransition;
        synchronized (concurrentSkipListMap) {
            return this.regionsInTransition.get(hri.getEncodedName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTableDisabled(String tableName) {
        Set<String> set = this.disabledTables;
        synchronized (set) {
            return this.disabledTables.contains(tableName);
        }
    }

    public void waitOnRegionToClearRegionsInTransition(HRegionInfo hri) throws IOException {
        if (this.isRegionInTransition(hri) == null) {
            return;
        }
        RegionState rs = null;
        while (!this.master.isStopped() && (rs = this.isRegionInTransition(hri)) != null) {
            Threads.sleep(1000);
            LOG.info((Object)("Waiting on " + rs + " to clear regions-in-transition"));
        }
        if (this.master.isStopped()) {
            LOG.info((Object)"Giving up wait on regions in transition because stoppable.isStopped is set");
        }
    }

    public boolean isTableOfRegionDisabled(byte[] regionName) {
        return this.isTableDisabled(Bytes.toString(HRegionInfo.getTableName(regionName)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableTable(String tableName) {
        Set<String> set = this.disabledTables;
        synchronized (set) {
            if (!this.isTableDisabled(tableName)) {
                this.disabledTables.add(tableName);
                try {
                    ZKTableDisable.disableTable(this.master.getZooKeeper(), tableName);
                }
                catch (KeeperException e) {
                    LOG.warn((Object)"ZK error setting table as disabled", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undisableTable(String tableName) {
        Set<String> set = this.disabledTables;
        synchronized (set) {
            if (this.isTableDisabled(tableName)) {
                this.disabledTables.remove(tableName);
                try {
                    ZKTableDisable.undisableTable(this.master.getZooKeeper(), tableName);
                }
                catch (KeeperException e) {
                    LOG.warn((Object)"ZK error setting table as disabled", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildDisabledTables() {
        Set<String> set = this.disabledTables;
        synchronized (set) {
            List<String> disabledTables;
            try {
                disabledTables = ZKTableDisable.getDisabledTables(this.master.getZooKeeper());
            }
            catch (KeeperException e) {
                LOG.warn((Object)"ZK error getting list of disabled tables", (Throwable)e);
                return;
            }
            if (!disabledTables.isEmpty()) {
                LOG.info((Object)("Rebuilt list of " + disabledTables.size() + " disabled " + "tables from zookeeper"));
                this.disabledTables.addAll(disabledTables);
            }
        }
    }

    public List<HRegionInfo> getRegionsOfTable(byte[] tableName) {
        ArrayList<HRegionInfo> tableRegions = new ArrayList<HRegionInfo>();
        for (HRegionInfo regionInfo : this.regions.tailMap(new HRegionInfo(new HTableDescriptor(tableName), null, null)).keySet()) {
            if (!Bytes.equals(regionInfo.getTableDesc().getName(), tableName)) break;
            tableRegions.add(regionInfo);
        }
        return tableRegions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<HRegionInfo> processServerShutdown(HServerInfo hsi) {
        Object i;
        ConcurrentNavigableMap<String, LoadBalancer.RegionPlan> concurrentNavigableMap = this.regionPlans;
        synchronized (concurrentNavigableMap) {
            i = this.regionPlans.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry e = i.next();
                if (!((LoadBalancer.RegionPlan)e.getValue()).getDestination().equals(hsi)) continue;
                i.remove();
            }
        }
        TreeSet deadRegions = null;
        i = this.regions;
        synchronized (i) {
            deadRegions = new TreeSet((Collection)this.servers.remove(hsi));
            for (HRegionInfo region : deadRegions) {
                this.regions.remove((Object)region);
            }
        }
        ArrayList<HRegionInfo> rits = new ArrayList<HRegionInfo>();
        ConcurrentSkipListMap<String, RegionState> concurrentSkipListMap = this.regionsInTransition;
        synchronized (concurrentSkipListMap) {
            for (RegionState region : this.regionsInTransition.values()) {
                if (!deadRegions.remove((Object)region.getRegion())) continue;
                rits.add(region.getRegion());
            }
        }
        return rits;
    }

    public void handleSplitReport(HServerInfo hsi, HRegionInfo parent, HRegionInfo a, HRegionInfo b) {
        this.regionOffline(parent);
        this.regionOnline(a, hsi);
        this.regionOnline(b, hsi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<HServerInfo, List<HRegionInfo>> getAssignments() {
        HashMap<HServerInfo, List<HRegionInfo>> result = null;
        SortedMap<HRegionInfo, HServerInfo> sortedMap = this.regions;
        synchronized (sortedMap) {
            result = new HashMap<HServerInfo, List<HRegionInfo>>(this.servers.size());
            for (Map.Entry e : this.servers.entrySet()) {
                ArrayList shallowCopy = new ArrayList((Collection)e.getValue());
                HServerInfo clone = new HServerInfo((HServerInfo)e.getKey());
                clone.getLoad().setNumberOfRegions(((List)e.getValue()).size());
                result.put(clone, shallowCopy);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Pair<HRegionInfo, HServerInfo> getAssignment(byte[] encodedRegionName) {
        String name = Bytes.toString(encodedRegionName);
        SortedMap<HRegionInfo, HServerInfo> sortedMap = this.regions;
        synchronized (sortedMap) {
            for (Map.Entry<HRegionInfo, HServerInfo> e : this.regions.entrySet()) {
                if (!e.getKey().getEncodedName().equals(name)) continue;
                return new Pair<HRegionInfo, HServerInfo>(e.getKey(), e.getValue());
            }
        }
        return null;
    }

    void balance(LoadBalancer.RegionPlan plan) {
        this.regionPlans.put(plan.getRegionName(), plan);
        this.unassign(plan.getRegionInfo());
    }

    public void stop() {
        this.timeoutMonitor.interrupt();
    }

    public static class RegionState
    implements Writable {
        private HRegionInfo region;
        private State state;
        private long stamp;

        public RegionState() {
        }

        RegionState(HRegionInfo region, State state) {
            this(region, state, System.currentTimeMillis());
        }

        RegionState(HRegionInfo region, State state, long stamp) {
            this.region = region;
            this.state = state;
            this.stamp = stamp;
        }

        public void update(State state, long stamp) {
            this.state = state;
            this.stamp = stamp;
        }

        public void update(State state) {
            this.state = state;
            this.stamp = System.currentTimeMillis();
        }

        public State getState() {
            return this.state;
        }

        public long getStamp() {
            return this.stamp;
        }

        public HRegionInfo getRegion() {
            return this.region;
        }

        public boolean isClosing() {
            return this.state == State.CLOSING;
        }

        public boolean isClosed() {
            return this.state == State.CLOSED;
        }

        public boolean isPendingClose() {
            return this.state == State.PENDING_CLOSE;
        }

        public boolean isOpening() {
            return this.state == State.OPENING;
        }

        public boolean isOpened() {
            return this.state == State.OPEN;
        }

        public boolean isPendingOpen() {
            return this.state == State.PENDING_OPEN;
        }

        public boolean isOffline() {
            return this.state == State.OFFLINE;
        }

        public String toString() {
            return this.region.getRegionNameAsString() + " state=" + (Object)((Object)this.state) + ", ts=" + this.stamp;
        }

        public void readFields(DataInput in) throws IOException {
            this.region = new HRegionInfo();
            this.region.readFields(in);
            this.state = State.valueOf(in.readUTF());
            this.stamp = in.readLong();
        }

        public void write(DataOutput out) throws IOException {
            this.region.write(out);
            out.writeUTF(this.state.name());
            out.writeLong(this.stamp);
        }

        public static enum State {
            OFFLINE,
            PENDING_OPEN,
            OPENING,
            OPEN,
            PENDING_CLOSE,
            CLOSING,
            CLOSED;

        }
    }

    public class TimeoutMonitor
    extends Chore {
        private final int timeout;
        private boolean bulkAssign;

        public TimeoutMonitor(int period, Stoppable stopper, int timeout) {
            super("AssignmentTimeoutMonitor", period, stopper);
            this.bulkAssign = false;
            this.timeout = timeout;
        }

        public boolean bulkAssign(boolean bulkAssign) {
            boolean result = this.bulkAssign;
            this.bulkAssign = bulkAssign;
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void chore() {
            if (this.bulkAssign) {
                return;
            }
            ConcurrentSkipListMap<String, RegionState> concurrentSkipListMap = AssignmentManager.this.regionsInTransition;
            synchronized (concurrentSkipListMap) {
                long now = System.currentTimeMillis();
                block19: for (RegionState regionState : AssignmentManager.this.regionsInTransition.values()) {
                    if (regionState.getStamp() + (long)this.timeout > now) continue;
                    HRegionInfo regionInfo = regionState.getRegion();
                    LOG.info((Object)("Regions in transition timed out:  " + regionState));
                    switch (regionState.getState()) {
                        case CLOSED: {
                            LOG.info((Object)"Region has been CLOSED for too long, retriggering ClosedRegionHandler");
                            AssignmentManager.this.executorService.submit(new ClosedRegionHandler(AssignmentManager.this.master, AssignmentManager.this, regionState.getRegion()));
                            break;
                        }
                        case OFFLINE: {
                            LOG.info((Object)("Region has been OFFLINE for too long, reassigning " + regionInfo.getRegionNameAsString() + " to a random server"));
                            AssignmentManager.this.assign(regionState.getRegion(), false);
                            break;
                        }
                        case PENDING_OPEN: {
                            LOG.info((Object)("Region has been PENDING_OPEN for too long, reassigning region=" + regionInfo.getRegionNameAsString()));
                            AssignmentManager.this.assign(regionState.getRegion(), false, true);
                            break;
                        }
                        case OPENING: {
                            LOG.info((Object)("Region has been OPENING for too long, reassigning region=" + regionInfo.getRegionNameAsString()));
                            try {
                                String node = ZKAssign.getNodeName(AssignmentManager.this.watcher, regionInfo.getEncodedName());
                                Stat stat = new Stat();
                                RegionTransitionData data = ZKAssign.getDataNoWatch(AssignmentManager.this.watcher, node, stat);
                                if (data.getEventType() == EventHandler.EventType.RS_ZK_REGION_OPENED) {
                                    LOG.debug((Object)"Region has transitioned to OPENED, allowing watched event handlers to process");
                                    break;
                                }
                                if (data.getEventType() != EventHandler.EventType.RS_ZK_REGION_OPENING) {
                                    LOG.warn((Object)("While timing out a region in state OPENING, found ZK node in unexpected state: " + (Object)((Object)data.getEventType())));
                                    break;
                                }
                                try {
                                    data = new RegionTransitionData(EventHandler.EventType.M_ZK_REGION_OFFLINE, regionInfo.getRegionName());
                                    if (!ZKUtil.setData(AssignmentManager.this.watcher, node, data.getBytes(), stat.getVersion())) continue block19;
                                    ZKUtil.getDataAndWatch(AssignmentManager.this.watcher, node);
                                    LOG.info((Object)("Successfully transitioned region=" + regionInfo.getRegionNameAsString() + " into OFFLINE" + " and forcing a new assignment"));
                                    AssignmentManager.this.assign(regionState, false, true);
                                }
                                catch (KeeperException.NoNodeException nne) {
                                }
                            }
                            catch (KeeperException ke) {
                                LOG.error((Object)"Unexpected ZK exception timing out CLOSING region", (Throwable)ke);
                            }
                            break;
                        }
                        case OPEN: {
                            LOG.error((Object)"Region has been OPEN for too long, we don't know where region was opened so can't do anything");
                            break;
                        }
                        case PENDING_CLOSE: {
                            LOG.info((Object)("Region has been PENDING_CLOSE for too long, running forced unassign again on region=" + regionInfo.getRegionNameAsString()));
                            try {
                                if (ZKUtil.watchAndCheckExists(AssignmentManager.this.watcher, ZKAssign.getNodeName(AssignmentManager.this.watcher, regionInfo.getEncodedName()))) continue block19;
                                AssignmentManager.this.unassign(regionInfo, true);
                            }
                            catch (KeeperException.NoNodeException e) {
                                LOG.debug((Object)"Node no longer existed so not forcing another unassignment");
                            }
                            catch (KeeperException e) {
                                LOG.warn((Object)"Unexpected ZK exception timing out a region close", (Throwable)e);
                            }
                            break;
                        }
                        case CLOSING: {
                            LOG.info((Object)"Region has been CLOSING for too long, this should eventually complete or the server will expire, doing nothing");
                        }
                    }
                }
            }
        }
    }

    class SingleServerBulkAssigner
    implements Runnable {
        private final HServerInfo regionserver;
        private final List<HRegionInfo> regions;

        SingleServerBulkAssigner(HServerInfo regionserver, List<HRegionInfo> regions) {
            this.regionserver = regionserver;
            this.regions = regions;
        }

        @Override
        public void run() {
            AssignmentManager.this.assign(this.regionserver, this.regions);
        }
    }

    static class ExistsUnassignedAsyncCallback
    implements AsyncCallback.StatCallback {
        private final Log LOG = LogFactory.getLog(ExistsUnassignedAsyncCallback.class);
        private final AtomicInteger counter;

        ExistsUnassignedAsyncCallback(AtomicInteger counter) {
            this.counter = counter;
        }

        public void processResult(int rc, String path, Object ctx, Stat stat) {
            if (rc != 0) {
                this.LOG.warn((Object)("rc != 0 for " + path + " -- retryable connectionloss -- " + "FIX see http://wiki.apache.org/hadoop/ZooKeeper/FAQ#A2"));
                return;
            }
            RegionState state = (RegionState)ctx;
            this.LOG.debug((Object)("rs=" + state));
            state.update(RegionState.State.PENDING_OPEN);
            this.counter.addAndGet(1);
        }
    }

    static class CreateUnassignedAsyncCallback
    implements AsyncCallback.StringCallback {
        private final Log LOG = LogFactory.getLog(CreateUnassignedAsyncCallback.class);
        private final ZooKeeperWatcher zkw;
        private final HServerInfo destination;
        private final AtomicInteger counter;

        CreateUnassignedAsyncCallback(ZooKeeperWatcher zkw, HServerInfo destination, AtomicInteger counter) {
            this.zkw = zkw;
            this.destination = destination;
            this.counter = counter;
        }

        public void processResult(int rc, String path, Object ctx, String name) {
            if (rc != 0) {
                this.LOG.warn((Object)("rc != 0 for " + path + " -- retryable connectionloss -- " + "FIX see http://wiki.apache.org/hadoop/ZooKeeper/FAQ#A2"));
                this.zkw.abort("Connectionloss writing unassigned at " + path + ", rc=" + rc, null);
                return;
            }
            this.LOG.debug((Object)("rs=" + (RegionState)ctx + ", server=" + this.destination.getServerName()));
            this.zkw.getZooKeeper().exists(path, (Watcher)this.zkw, (AsyncCallback.StatCallback)new ExistsUnassignedAsyncCallback(this.counter), ctx);
        }
    }
}

