/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Chore;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HMsg;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.HServerInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.NotAllMetaRegionsOnlineException;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableNotDisabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.UnknownRegionException;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.catalog.MetaEditor;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.MetaScanner;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.executor.ExecutorService;
import org.apache.hadoop.hbase.ipc.HBaseRPC;
import org.apache.hadoop.hbase.ipc.HBaseServer;
import org.apache.hadoop.hbase.ipc.HMasterInterface;
import org.apache.hadoop.hbase.ipc.HMasterRegionInterface;
import org.apache.hadoop.hbase.master.ActiveMasterManager;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.CatalogJanitor;
import org.apache.hadoop.hbase.master.HMasterCommandLine;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.master.handler.DeleteTableHandler;
import org.apache.hadoop.hbase.master.handler.DisableTableHandler;
import org.apache.hadoop.hbase.master.handler.EnableTableHandler;
import org.apache.hadoop.hbase.master.handler.ModifyTableHandler;
import org.apache.hadoop.hbase.master.handler.TableAddFamilyHandler;
import org.apache.hadoop.hbase.master.handler.TableDeleteFamilyHandler;
import org.apache.hadoop.hbase.master.handler.TableModifyFamilyHandler;
import org.apache.hadoop.hbase.master.metrics.MasterMetrics;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.InfoServer;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.Sleeper;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.util.VersionInfo;
import org.apache.hadoop.hbase.zookeeper.ClusterStatusTracker;
import org.apache.hadoop.hbase.zookeeper.RegionServerTracker;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.net.DNS;
import org.apache.zookeeper.KeeperException;

public class HMaster
extends Thread
implements HMasterInterface,
HMasterRegionInterface,
MasterServices,
Server {
    private static final Log LOG = LogFactory.getLog((String)HMaster.class.getName());
    public static final String MASTER = "master";
    private final Configuration conf;
    private InfoServer infoServer;
    private ZooKeeperWatcher zooKeeper;
    private ActiveMasterManager activeMasterManager;
    private RegionServerTracker regionServerTracker;
    private final HBaseServer rpcServer;
    private final HServerAddress address;
    private final MasterMetrics metrics;
    private MasterFileSystem fileSystemManager;
    private HConnection connection;
    private ServerManager serverManager;
    AssignmentManager assignmentManager;
    private CatalogTracker catalogTracker;
    private ClusterStatusTracker clusterStatusTracker;
    private volatile boolean stopped = false;
    private volatile boolean abort = false;
    private volatile boolean isActiveMaster = false;
    private volatile boolean isInitialized = false;
    ExecutorService executorService;
    private LoadBalancer balancer = new LoadBalancer();
    private Thread balancerChore;
    private volatile boolean balanceSwitch = true;
    private Thread catalogJanitorChore;

    public HMaster(Configuration conf) throws IOException, KeeperException, InterruptedException {
        this.conf = conf;
        HServerAddress a = new HServerAddress(HMaster.getMyAddress(this.conf));
        int numHandlers = conf.getInt("hbase.regionserver.handler.count", 10);
        this.rpcServer = HBaseRPC.getServer(this, new Class[]{HMasterInterface.class, HMasterRegionInterface.class}, a.getBindAddress(), a.getPort(), numHandlers, 0, false, conf, 0);
        this.address = new HServerAddress(this.rpcServer.getListenerAddress());
        this.setName("master-" + this.address);
        if (this.conf.get("mapred.task.id") == null) {
            this.conf.set("mapred.task.id", "hb_m_" + this.address.toString() + "_" + System.currentTimeMillis());
        }
        this.zooKeeper = new ZooKeeperWatcher(conf, "master:" + this.address.getPort(), this);
        this.metrics = new MasterMetrics(this.getServerName());
    }

    private static void stallIfBackupMaster(Configuration c, ActiveMasterManager amm) throws InterruptedException {
        if (!c.getBoolean("hbase.master.backup", false)) {
            return;
        }
        LOG.debug((Object)"HMaster started in backup mode.  Stalling until master znode is written.");
        while (!amm.isActiveMaster()) {
            LOG.debug((Object)"Waiting for master address ZNode to be written (Also watching cluster state node)");
            Thread.sleep(c.getInt("zookeeper.session.timeout", 60000));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.activeMasterManager = new ActiveMasterManager(this.zooKeeper, this.address, this);
            this.zooKeeper.registerListener(this.activeMasterManager);
            HMaster.stallIfBackupMaster(this.conf, this.activeMasterManager);
            this.activeMasterManager.blockUntilBecomingActiveMaster();
            if (!this.stopped) {
                this.finishInitialization();
                this.loop();
            }
        }
        catch (Throwable t) {
            this.abort("Unhandled exception. Starting shutdown.", t);
        }
        finally {
            this.stopChores();
            if (!this.abort && this.serverManager.isClusterShutdown()) {
                this.serverManager.letRegionServersShutdown();
            }
            this.stopServiceThreads();
            if (this.activeMasterManager != null) {
                this.activeMasterManager.stop();
            }
            if (this.catalogTracker != null) {
                this.catalogTracker.stop();
            }
            if (this.serverManager != null) {
                this.serverManager.stop();
            }
            if (this.assignmentManager != null) {
                this.assignmentManager.stop();
            }
            HConnectionManager.deleteConnection(this.conf, true);
            this.zooKeeper.close();
        }
        LOG.info((Object)"HMaster main thread exiting");
    }

    private void loop() {
        Sleeper sleeper = new Sleeper(1000, this);
        while (!this.stopped) {
            sleeper.sleep();
        }
    }

    private void finishInitialization() throws IOException, InterruptedException, KeeperException {
        this.isActiveMaster = true;
        this.fileSystemManager = new MasterFileSystem(this, this.metrics);
        this.connection = HConnectionManager.getConnection(this.conf);
        this.executorService = new ExecutorService(this.getServerName());
        this.serverManager = new ServerManager(this, this, this.metrics);
        this.catalogTracker = new CatalogTracker(this.zooKeeper, this.connection, this, this.conf.getInt("hbase.master.catalog.timeout", Integer.MAX_VALUE));
        this.catalogTracker.start();
        this.assignmentManager = new AssignmentManager(this, this.serverManager, this.catalogTracker, this.executorService);
        this.zooKeeper.registerListenerFirst(this.assignmentManager);
        this.regionServerTracker = new RegionServerTracker(this.zooKeeper, this, this.serverManager);
        this.regionServerTracker.start();
        this.clusterStatusTracker = new ClusterStatusTracker(this.getZooKeeper(), this);
        this.clusterStatusTracker.start();
        boolean wasUp = this.clusterStatusTracker.isClusterUp();
        if (!wasUp) {
            this.clusterStatusTracker.setClusterUp();
        }
        LOG.info((Object)("Server active/primary master; " + this.address + ", sessionid=0x" + Long.toHexString(this.zooKeeper.getZooKeeper().getSessionId()) + ", cluster-up flag was=" + wasUp));
        this.startServiceThreads();
        int regionCount = this.serverManager.waitForRegionServers();
        this.fileSystemManager.splitLogAfterStartup(this.serverManager.getOnlineServers());
        this.assignRootAndMeta();
        if (regionCount == 0) {
            LOG.info((Object)"Master startup proceeding: cluster startup");
            this.assignmentManager.cleanoutUnassigned();
            this.assignmentManager.assignAllUserRegions();
        } else {
            LOG.info((Object)"Master startup proceeding: master failover");
            this.assignmentManager.processFailover();
        }
        this.balancerChore = HMaster.getAndStartBalancerChore(this);
        this.catalogJanitorChore = Threads.setDaemonThreadRunning(new CatalogJanitor(this, this));
        LOG.info((Object)"Master has completed initialization");
        this.isInitialized = true;
    }

    int assignRootAndMeta() throws InterruptedException, IOException, KeeperException {
        int assigned = 0;
        long timeout = this.conf.getLong("hbase.catalog.verification.timeout", 1000L);
        boolean rit = this.assignmentManager.processRegionInTransitionAndBlockUntilAssigned(HRegionInfo.ROOT_REGIONINFO);
        if (!this.catalogTracker.verifyRootRegionLocation(timeout)) {
            this.assignmentManager.assignRoot();
            this.catalogTracker.waitForRoot();
            ++assigned;
        }
        LOG.info((Object)("-ROOT- assigned=" + assigned + ", rit=" + rit + ", location=" + this.catalogTracker.getRootLocation()));
        rit = this.assignmentManager.processRegionInTransitionAndBlockUntilAssigned(HRegionInfo.FIRST_META_REGIONINFO);
        if (!this.catalogTracker.verifyMetaRegionLocation(timeout)) {
            this.assignmentManager.assignMeta();
            this.catalogTracker.waitForMeta();
            this.assignmentManager.waitForAssignment(HRegionInfo.FIRST_META_REGIONINFO);
            ++assigned;
        }
        LOG.info((Object)(".META. assigned=" + assigned + ", rit=" + rit + ", location=" + this.catalogTracker.getMetaLocation()));
        return assigned;
    }

    private static String getMyAddress(Configuration c) throws UnknownHostException {
        String s = DNS.getDefaultHost((String)c.get("hbase.master.dns.interface", "default"), (String)c.get("hbase.master.dns.nameserver", "default"));
        s = s + ":" + c.get("hbase.master.port", Integer.toString(60000));
        return s;
    }

    public HServerAddress getMasterAddress() {
        return this.address;
    }

    public long getProtocolVersion(String protocol, long clientVersion) {
        return 25L;
    }

    public InfoServer getInfoServer() {
        return this.infoServer;
    }

    @Override
    public Configuration getConfiguration() {
        return this.conf;
    }

    @Override
    public ServerManager getServerManager() {
        return this.serverManager;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public MasterFileSystem getMasterFileSystem() {
        return this.fileSystemManager;
    }

    public ZooKeeperWatcher getZooKeeperWatcher() {
        return this.zooKeeper;
    }

    private void startServiceThreads() {
        try {
            this.executorService.startExecutorService(ExecutorService.ExecutorType.MASTER_OPEN_REGION, this.conf.getInt("hbase.master.executor.openregion.threads", 5));
            this.executorService.startExecutorService(ExecutorService.ExecutorType.MASTER_CLOSE_REGION, this.conf.getInt("hbase.master.executor.closeregion.threads", 5));
            this.executorService.startExecutorService(ExecutorService.ExecutorType.MASTER_SERVER_OPERATIONS, this.conf.getInt("hbase.master.executor.serverops.threads", 3));
            this.executorService.startExecutorService(ExecutorService.ExecutorType.MASTER_META_SERVER_OPERATIONS, this.conf.getInt("hbase.master.executor.serverops.threads", 2));
            this.executorService.startExecutorService(ExecutorService.ExecutorType.MASTER_TABLE_OPERATIONS, this.conf.getInt("hbase.master.executor.tableops.threads", 3));
            int port = this.conf.getInt("hbase.master.info.port", 60010);
            if (port >= 0) {
                String a = this.conf.get("hbase.master.info.bindAddress", "0.0.0.0");
                this.infoServer = new InfoServer(MASTER, a, port, false);
                this.infoServer.setAttribute(MASTER, this);
                this.infoServer.start();
            }
            this.rpcServer.start();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Started service threads");
            }
        }
        catch (IOException e) {
            if (e instanceof RemoteException) {
                e = ((RemoteException)((Object)e)).unwrapRemoteException();
            }
            this.abort("Failed startup", e);
        }
    }

    private void stopServiceThreads() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Stopping service threads");
        }
        if (this.rpcServer != null) {
            this.rpcServer.stop();
        }
        if (this.infoServer != null) {
            LOG.info((Object)"Stopping infoServer");
            try {
                this.infoServer.stop();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
    }

    private static Thread getAndStartBalancerChore(final HMaster master) {
        String name = master.getServerName() + "-BalancerChore";
        int period = master.getConfiguration().getInt("hbase.balancer.period", 300000);
        Chore chore = new Chore(name, period, master){

            @Override
            protected void chore() {
                master.balance();
            }
        };
        return Threads.setDaemonThreadRunning(chore);
    }

    private void stopChores() {
        if (this.balancerChore != null) {
            this.balancerChore.interrupt();
        }
        if (this.catalogJanitorChore != null) {
            this.catalogJanitorChore.interrupt();
        }
    }

    @Override
    public MapWritable regionServerStartup(HServerInfo serverInfo) throws IOException {
        String rsAddress = HBaseServer.getRemoteAddress();
        serverInfo.setServerAddress(new HServerAddress(rsAddress, serverInfo.getServerAddress().getPort()));
        this.serverManager.regionServerStartup(serverInfo);
        MapWritable mw = this.createConfigurationSubset();
        mw.put((Writable)new Text("hbase.regionserver.address"), (Writable)new Text(rsAddress));
        return mw;
    }

    protected MapWritable createConfigurationSubset() {
        MapWritable mw = this.addConfig(new MapWritable(), "hbase.rootdir");
        return this.addConfig(mw, "fs.default.name");
    }

    private MapWritable addConfig(MapWritable mw, String key) {
        mw.put((Writable)new Text(key), (Writable)new Text(this.conf.get(key)));
        return mw;
    }

    @Override
    public HMsg[] regionServerReport(HServerInfo serverInfo, HMsg[] msgs, HRegionInfo[] mostLoadedRegions) throws IOException {
        return this.adornRegionServerAnswer(serverInfo, this.serverManager.regionServerReport(serverInfo, msgs, mostLoadedRegions));
    }

    protected HMsg[] adornRegionServerAnswer(HServerInfo hsi, HMsg[] msgs) throws IOException {
        return msgs;
    }

    @Override
    public boolean isMasterRunning() {
        return !this.isStopped();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean balance() {
        if (!this.balanceSwitch) {
            return false;
        }
        LoadBalancer loadBalancer = this.balancer;
        synchronized (loadBalancer) {
            if (this.assignmentManager.isRegionsInTransition()) {
                LOG.debug((Object)("Not running balancer because " + this.assignmentManager.getRegionsInTransition().size() + " region(s) in transition: " + StringUtils.abbreviate((String)this.assignmentManager.getRegionsInTransition().toString(), (int)256)));
                return false;
            }
            if (!this.serverManager.getDeadServers().isEmpty()) {
                LOG.debug((Object)"Not running balancer because dead regionserver processing");
            }
            Map<HServerInfo, List<HRegionInfo>> assignments = this.assignmentManager.getAssignments();
            for (Map.Entry<String, HServerInfo> e : this.serverManager.getOnlineServers().entrySet()) {
                HServerInfo hsi = e.getValue();
                if (assignments.containsKey(hsi)) continue;
                assignments.put(hsi, new ArrayList());
            }
            List<LoadBalancer.RegionPlan> plans = this.balancer.balanceCluster(assignments);
            if (plans != null && !plans.isEmpty()) {
                for (LoadBalancer.RegionPlan plan : plans) {
                    LOG.info((Object)("balance " + plan));
                    this.assignmentManager.balance(plan);
                }
            }
        }
        return true;
    }

    @Override
    public boolean balanceSwitch(boolean b) {
        boolean oldValue = this.balanceSwitch;
        this.balanceSwitch = b;
        LOG.info((Object)("Balance=" + b));
        return oldValue;
    }

    @Override
    public void move(byte[] encodedRegionName, byte[] destServerName) throws UnknownRegionException {
        Pair<HRegionInfo, HServerInfo> p = this.assignmentManager.getAssignment(encodedRegionName);
        if (p == null) {
            throw new UnknownRegionException(Bytes.toString(encodedRegionName));
        }
        HServerInfo dest = this.serverManager.getServerInfo(new String(destServerName));
        LoadBalancer.RegionPlan rp = new LoadBalancer.RegionPlan(p.getFirst(), p.getSecond(), dest);
        this.assignmentManager.balance(rp);
    }

    @Override
    public void createTable(HTableDescriptor desc, byte[][] splitKeys) throws IOException {
        this.createTable(desc, splitKeys, false);
    }

    public void createTable(HTableDescriptor desc, byte[][] splitKeys, boolean sync) throws IOException {
        if (!this.isMasterRunning()) {
            throw new MasterNotRunningException();
        }
        HRegionInfo[] newRegions = null;
        if (splitKeys == null || splitKeys.length == 0) {
            newRegions = new HRegionInfo[]{new HRegionInfo(desc, null, null)};
        } else {
            int numRegions = splitKeys.length + 1;
            newRegions = new HRegionInfo[numRegions];
            byte[] startKey = null;
            byte[] endKey = null;
            for (int i = 0; i < numRegions; ++i) {
                endKey = i == splitKeys.length ? null : splitKeys[i];
                newRegions[i] = new HRegionInfo(desc, startKey, endKey);
                startKey = endKey;
            }
        }
        int timeout = this.conf.getInt("hbase.client.catalog.timeout", 10000);
        try {
            if (this.catalogTracker.waitForMeta(timeout) == null) {
                throw new NotAllMetaRegionsOnlineException();
            }
        }
        catch (InterruptedException e) {
            LOG.warn((Object)"Interrupted waiting for meta availability", (Throwable)e);
            throw new IOException(e);
        }
        this.createTable(newRegions, sync);
    }

    private synchronized void createTable(HRegionInfo[] newRegions, boolean sync) throws IOException {
        String tableName = newRegions[0].getTableDesc().getNameAsString();
        if (MetaReader.tableExists(this.catalogTracker, tableName)) {
            throw new TableExistsException(tableName);
        }
        for (HRegionInfo newRegion : newRegions) {
            HRegion region = HRegion.createHRegion(newRegion, this.fileSystemManager.getRootDir(), this.conf);
            MetaEditor.addRegionToMeta(this.catalogTracker, region.getRegionInfo());
            region.close();
            region.getLog().closeAndDelete();
            this.assignmentManager.assign(region.getRegionInfo(), true);
        }
        if (sync) {
            LOG.debug((Object)("Waiting for " + newRegions.length + " region(s) to be " + "assigned before returning"));
            for (HRegionInfo regionInfo : newRegions) {
                try {
                    this.assignmentManager.waitForAssignment(regionInfo);
                }
                catch (InterruptedException e) {
                    LOG.info((Object)"Interrupted waiting for region to be assigned during create table call");
                    return;
                }
            }
        }
    }

    private static boolean isCatalogTable(byte[] tableName) {
        return Bytes.equals(tableName, HConstants.ROOT_TABLE_NAME) || Bytes.equals(tableName, HConstants.META_TABLE_NAME);
    }

    @Override
    public void deleteTable(byte[] tableName) throws IOException {
        new DeleteTableHandler(tableName, this, this).process();
    }

    @Override
    public void addColumn(byte[] tableName, HColumnDescriptor column) throws IOException {
        new TableAddFamilyHandler(tableName, column, (Server)this, (MasterServices)this).process();
    }

    @Override
    public void modifyColumn(byte[] tableName, HColumnDescriptor descriptor) throws IOException {
        new TableModifyFamilyHandler(tableName, descriptor, (Server)this, (MasterServices)this).process();
    }

    @Override
    public void deleteColumn(byte[] tableName, byte[] c) throws IOException {
        new TableDeleteFamilyHandler(tableName, c, (Server)this, (MasterServices)this).process();
    }

    @Override
    public void enableTable(byte[] tableName) throws IOException {
        new EnableTableHandler(this, tableName, this.catalogTracker, this.assignmentManager).process();
    }

    @Override
    public void disableTable(byte[] tableName) throws IOException {
        new DisableTableHandler(this, tableName, this.catalogTracker, this.assignmentManager).process();
    }

    Pair<HRegionInfo, HServerAddress> getTableRegionForRow(final byte[] tableName, byte[] rowKey) throws IOException {
        final AtomicReference<Object> result = new AtomicReference<Object>(null);
        MetaScanner.MetaScannerVisitor visitor = new MetaScanner.MetaScannerVisitor(){

            @Override
            public boolean processRow(Result data) throws IOException {
                if (data == null || data.size() <= 0) {
                    return true;
                }
                Pair<HRegionInfo, HServerAddress> pair = MetaReader.metaRowToRegionPair(data);
                if (pair == null) {
                    return false;
                }
                if (!Bytes.equals(pair.getFirst().getTableDesc().getName(), tableName)) {
                    return false;
                }
                result.set(pair);
                return true;
            }
        };
        MetaScanner.metaScan(this.conf, visitor, tableName, rowKey, 1);
        return result.get();
    }

    @Override
    public void modifyTable(byte[] tableName, HTableDescriptor htd) throws IOException {
        this.executorService.submit(new ModifyTableHandler(tableName, htd, (Server)this, (MasterServices)this));
    }

    @Override
    public void checkTableModifiable(byte[] tableName) throws IOException {
        String tableNameStr = Bytes.toString(tableName);
        if (HMaster.isCatalogTable(tableName)) {
            throw new IOException("Can't modify catalog tables");
        }
        if (!MetaReader.tableExists(this.getCatalogTracker(), tableNameStr)) {
            throw new TableNotFoundException(tableNameStr);
        }
        if (!this.getAssignmentManager().isTableDisabled(Bytes.toString(tableName))) {
            throw new TableNotDisabledException(tableName);
        }
    }

    @Override
    public ClusterStatus getClusterStatus() {
        ClusterStatus status = new ClusterStatus();
        status.setHBaseVersion(VersionInfo.getVersion());
        status.setServerInfo(this.serverManager.getOnlineServers().values());
        status.setDeadServers(this.serverManager.getDeadServers());
        status.setRegionsInTransition(this.assignmentManager.getRegionsInTransition());
        return status;
    }

    @Override
    public void abort(String msg, Throwable t) {
        if (t != null) {
            LOG.fatal((Object)msg, t);
        } else {
            LOG.fatal((Object)msg);
        }
        this.abort = true;
        this.stop("Aborting");
    }

    @Override
    public ZooKeeperWatcher getZooKeeper() {
        return this.zooKeeper;
    }

    @Override
    public String getServerName() {
        return this.address.toString();
    }

    @Override
    public CatalogTracker getCatalogTracker() {
        return this.catalogTracker;
    }

    @Override
    public AssignmentManager getAssignmentManager() {
        return this.assignmentManager;
    }

    @Override
    public void shutdown() {
        this.serverManager.shutdownCluster();
        try {
            this.clusterStatusTracker.setClusterDown();
        }
        catch (KeeperException e) {
            LOG.error((Object)"ZooKeeper exception trying to set cluster as down in ZK", (Throwable)e);
        }
    }

    @Override
    public void stopMaster() {
        this.stop("Stopped by " + Thread.currentThread().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(String why) {
        LOG.info((Object)why);
        this.stopped = true;
        AtomicBoolean atomicBoolean = this.activeMasterManager.clusterHasActiveMaster;
        synchronized (atomicBoolean) {
            this.activeMasterManager.clusterHasActiveMaster.notifyAll();
        }
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    public boolean isActiveMaster() {
        return this.isActiveMaster;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public void assignRegion(HRegionInfo hri) {
        this.assignmentManager.assign(hri, true);
    }

    public static HMaster constructMaster(Class<? extends HMaster> masterClass, Configuration conf) {
        try {
            Constructor<? extends HMaster> c = masterClass.getConstructor(Configuration.class);
            return c.newInstance(conf);
        }
        catch (InvocationTargetException ite) {
            Throwable target;
            Throwable throwable = target = ite.getTargetException() != null ? ite.getTargetException() : ite;
            if (target.getCause() != null) {
                target = target.getCause();
            }
            throw new RuntimeException("Failed construction of Master: " + masterClass.toString(), target);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed construction of Master: " + masterClass.toString() + (e.getCause() != null ? e.getCause().getMessage() : ""), e);
        }
    }

    public static void main(String[] args) throws Exception {
        new HMasterCommandLine(HMaster.class).doMain(args);
    }
}

