/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.handler;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.handler.TotesHRegionInfo;

public class ClosedRegionHandler
extends EventHandler
implements TotesHRegionInfo {
    private static final Log LOG = LogFactory.getLog(ClosedRegionHandler.class);
    private final AssignmentManager assignmentManager;
    private final HRegionInfo regionInfo;
    private final ClosedPriority priority;

    public ClosedRegionHandler(Server server, AssignmentManager assignmentManager, HRegionInfo regionInfo) {
        super(server, EventHandler.EventType.RS_ZK_REGION_CLOSED);
        this.assignmentManager = assignmentManager;
        this.regionInfo = regionInfo;
        this.priority = regionInfo.isRootRegion() ? ClosedPriority.ROOT : (regionInfo.isMetaRegion() ? ClosedPriority.META : ClosedPriority.USER);
    }

    @Override
    public int getPriority() {
        return this.priority.getValue();
    }

    @Override
    public HRegionInfo getHRegionInfo() {
        return this.regionInfo;
    }

    @Override
    public void process() {
        LOG.debug((Object)("Handling CLOSED event for " + this.regionInfo.getEncodedName()));
        if (this.assignmentManager.isTableOfRegionDisabled(this.regionInfo.getRegionName())) {
            this.assignmentManager.offlineDisabledRegion(this.regionInfo);
            return;
        }
        this.assignmentManager.setOffline(this.regionInfo);
        this.assignmentManager.assign(this.regionInfo, true);
    }

    private static enum ClosedPriority {
        ROOT(1),
        META(2),
        USER(3);

        private final int value;

        private ClosedPriority(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

