/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.handler;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.catalog.MetaEditor;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.handler.TableEventHandler;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;

public class DeleteTableHandler
extends TableEventHandler {
    private static final Log LOG = LogFactory.getLog(DeleteTableHandler.class);

    public DeleteTableHandler(byte[] tableName, Server server, MasterServices masterServices) throws IOException {
        super(EventHandler.EventType.C_M_DELETE_TABLE, tableName, server, masterServices);
    }

    @Override
    protected void handleTableOperation(List<HRegionInfo> regions) throws IOException {
        AssignmentManager am = this.masterServices.getAssignmentManager();
        long waitTime = this.server.getConfiguration().getLong("hbase.master.wait.on.region", 300000L);
        for (HRegionInfo region : regions) {
            AssignmentManager.RegionState rs;
            long done = System.currentTimeMillis() + waitTime;
            while (System.currentTimeMillis() < done && (rs = am.isRegionInTransition(region)) != null) {
                Threads.sleep(1000);
                LOG.debug((Object)("Waiting on  region to clear regions in transition; " + rs));
            }
            if (am.isRegionInTransition(region) != null) {
                throw new IOException("Waited hbase.master.wait.on.region (" + waitTime + "ms) for region to leave region " + region.getRegionNameAsString() + " in transitions");
            }
            LOG.debug((Object)("Deleting region " + region.getRegionNameAsString() + " from META and FS"));
            MetaEditor.deleteRegion(this.server.getCatalogTracker(), region);
            this.masterServices.getMasterFileSystem().deleteRegion(region);
        }
        this.masterServices.getMasterFileSystem().deleteTable(this.tableName);
        am.undisableTable(Bytes.toString(this.tableName));
    }
}

