/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.handler;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.util.Bytes;

public class DisableTableHandler
extends EventHandler {
    private static final Log LOG = LogFactory.getLog(DisableTableHandler.class);
    private final byte[] tableName;
    private final String tableNameStr;
    private final AssignmentManager assignmentManager;

    public DisableTableHandler(Server server, byte[] tableName, CatalogTracker catalogTracker, AssignmentManager assignmentManager) throws TableNotFoundException, IOException {
        super(server, EventHandler.EventType.C_M_DISABLE_TABLE);
        this.tableName = tableName;
        this.tableNameStr = Bytes.toString(this.tableName);
        this.assignmentManager = assignmentManager;
        if (!MetaReader.tableExists(catalogTracker, this.tableNameStr)) {
            throw new TableNotFoundException(Bytes.toString(tableName));
        }
    }

    @Override
    public void process() {
        try {
            LOG.info((Object)("Attemping to disable the table " + this.tableNameStr));
            this.handleDisableTable();
        }
        catch (IOException e) {
            LOG.error((Object)("Error trying to disable the table " + this.tableNameStr), (Throwable)e);
        }
    }

    private void handleDisableTable() throws IOException {
        if (this.assignmentManager.isTableDisabled(this.tableNameStr)) {
            LOG.info((Object)("Table " + this.tableNameStr + " is already disabled; skipping disable"));
            return;
        }
        this.assignmentManager.disableTable(this.tableNameStr);
        List<HRegionInfo> regions = this.assignmentManager.getRegionsOfTable(this.tableName);
        for (HRegionInfo region : regions) {
            this.assignmentManager.unassign(region);
        }
        for (HRegionInfo region : regions) {
            this.assignmentManager.waitOnRegionToClearRegionsInTransition(region);
        }
    }
}

