/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.handler;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.util.Bytes;

public class EnableTableHandler
extends EventHandler {
    private static final Log LOG = LogFactory.getLog(EnableTableHandler.class);
    private final byte[] tableName;
    private final String tableNameStr;
    private final AssignmentManager assignmentManager;
    private final CatalogTracker ct;

    public EnableTableHandler(Server server, byte[] tableName, CatalogTracker catalogTracker, AssignmentManager assignmentManager) throws TableNotFoundException, IOException {
        super(server, EventHandler.EventType.C_M_ENABLE_TABLE);
        this.tableName = tableName;
        this.tableNameStr = Bytes.toString(tableName);
        this.ct = catalogTracker;
        this.assignmentManager = assignmentManager;
        if (!MetaReader.tableExists(catalogTracker, this.tableNameStr)) {
            throw new TableNotFoundException(Bytes.toString(tableName));
        }
    }

    @Override
    public void process() {
        try {
            LOG.info((Object)("Attemping to enable the table " + this.tableNameStr));
            this.handleEnableTable();
        }
        catch (IOException e) {
            LOG.error((Object)("Error trying to enable the table " + this.tableNameStr), (Throwable)e);
        }
    }

    private void handleEnableTable() throws IOException {
        if (!this.assignmentManager.isTableDisabled(this.tableNameStr)) {
            LOG.info((Object)("Table " + this.tableNameStr + " is not disabled; skipping enable"));
            return;
        }
        List<HRegionInfo> regions = MetaReader.getTableRegions(this.ct, this.tableName);
        this.assignmentManager.undisableTable(this.tableNameStr);
        for (HRegionInfo region : regions) {
            this.assignmentManager.assign(region, true);
        }
        for (HRegionInfo region : regions) {
            this.assignmentManager.waitOnRegionToClearRegionsInTransition(region);
        }
    }
}

