/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.handler;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HServerInfo;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.handler.TotesHRegionInfo;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.zookeeper.KeeperException;

public class OpenedRegionHandler
extends EventHandler
implements TotesHRegionInfo {
    private static final Log LOG = LogFactory.getLog(OpenedRegionHandler.class);
    private final AssignmentManager assignmentManager;
    private final HRegionInfo regionInfo;
    private final HServerInfo serverInfo;
    private final OpenedPriority priority;

    public OpenedRegionHandler(Server server, AssignmentManager assignmentManager, HRegionInfo regionInfo, HServerInfo serverInfo) {
        super(server, EventHandler.EventType.RS_ZK_REGION_OPENED);
        this.assignmentManager = assignmentManager;
        this.regionInfo = regionInfo;
        this.serverInfo = serverInfo;
        this.priority = regionInfo.isRootRegion() ? OpenedPriority.ROOT : (regionInfo.isMetaRegion() ? OpenedPriority.META : OpenedPriority.USER);
    }

    @Override
    public int getPriority() {
        return this.priority.getValue();
    }

    @Override
    public HRegionInfo getHRegionInfo() {
        return this.regionInfo;
    }

    @Override
    public void process() {
        LOG.debug((Object)("Handling OPENED event for " + this.regionInfo.getEncodedName() + "; deleting unassigned node"));
        try {
            ZKAssign.deleteOpenedNode(this.server.getZooKeeper(), this.regionInfo.getEncodedName());
        }
        catch (KeeperException e) {
            this.server.abort("Error deleting OPENED node in ZK for transition ZK node (" + this.regionInfo.getEncodedName() + ")", e);
        }
        this.assignmentManager.regionOnline(this.regionInfo, this.serverInfo);
        if (this.assignmentManager.isTableDisabled(this.regionInfo.getTableDesc().getNameAsString())) {
            LOG.debug((Object)("Opened region " + this.regionInfo.getRegionNameAsString() + " but " + "this table is disabled, triggering close of region"));
            this.assignmentManager.unassign(this.regionInfo);
        } else {
            LOG.debug((Object)("Opened region " + this.regionInfo.getRegionNameAsString() + " on " + this.serverInfo.getServerName()));
        }
    }

    private static enum OpenedPriority {
        ROOT(1),
        META(2),
        USER(3);

        private final int value;

        private OpenedPriority(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

