/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.handler;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.util.Bytes;

public abstract class TableEventHandler
extends EventHandler {
    private static final Log LOG = LogFactory.getLog(TableEventHandler.class);
    protected final MasterServices masterServices;
    protected final byte[] tableName;

    public TableEventHandler(EventHandler.EventType eventType, byte[] tableName, Server server, MasterServices masterServices) throws IOException {
        super(server, eventType);
        this.masterServices = masterServices;
        this.tableName = tableName;
        this.masterServices.checkTableModifiable(tableName);
    }

    @Override
    public void process() {
        try {
            LOG.info((Object)("Handling table operation " + (Object)((Object)this.eventType) + " on table " + Bytes.toString(this.tableName)));
            List<HRegionInfo> hris = MetaReader.getTableRegions(this.server.getCatalogTracker(), this.tableName);
            this.handleTableOperation(hris);
        }
        catch (IOException e) {
            LOG.error((Object)("Error trying to delete the table " + Bytes.toString(this.tableName)), (Throwable)e);
        }
    }

    protected abstract void handleTableOperation(List<HRegionInfo> var1) throws IOException;
}

