/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.metrics;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.master.metrics.MasterStatistics;
import org.apache.hadoop.hbase.metrics.MetricsRate;
import org.apache.hadoop.hbase.metrics.PersistentMetricsTimeVaryingRate;
import org.apache.hadoop.metrics.ContextFactory;
import org.apache.hadoop.metrics.MetricsContext;
import org.apache.hadoop.metrics.MetricsRecord;
import org.apache.hadoop.metrics.MetricsUtil;
import org.apache.hadoop.metrics.Updater;
import org.apache.hadoop.metrics.jvm.JvmMetrics;
import org.apache.hadoop.metrics.util.MetricsRegistry;

public class MasterMetrics
implements Updater {
    private final Log LOG = LogFactory.getLog(this.getClass());
    private final MetricsRecord metricsRecord;
    private final MetricsRegistry registry = new MetricsRegistry();
    private final MasterStatistics masterStatistics;
    private long lastUpdate = System.currentTimeMillis();
    private long lastExtUpdate = System.currentTimeMillis();
    private long extendedPeriod = 0L;
    private final MetricsRate cluster_requests = new MetricsRate("cluster_requests", this.registry);
    final PersistentMetricsTimeVaryingRate splitTime = new PersistentMetricsTimeVaryingRate("splitTime", this.registry);
    final PersistentMetricsTimeVaryingRate splitSize = new PersistentMetricsTimeVaryingRate("splitSize", this.registry);

    public MasterMetrics(String name) {
        MetricsContext context = MetricsUtil.getContext((String)"hbase");
        this.metricsRecord = MetricsUtil.createRecord((MetricsContext)context, (String)"master");
        this.metricsRecord.setTag("Master", name);
        context.registerUpdater((Updater)this);
        JvmMetrics.init((String)"Master", (String)name);
        this.masterStatistics = new MasterStatistics(this.registry);
        try {
            Object m = ContextFactory.getFactory().getAttribute("hbase.extendedperiod");
            if (m instanceof String) {
                this.extendedPeriod = Long.parseLong((String)m) * 1000L;
            }
        }
        catch (IOException ioe) {
            this.LOG.info((Object)"Couldn't load ContextFactory for Metrics config info");
        }
        this.LOG.info((Object)"Initialized");
    }

    public void shutdown() {
        if (this.masterStatistics != null) {
            this.masterStatistics.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUpdates(MetricsContext unused) {
        MasterMetrics masterMetrics = this;
        synchronized (masterMetrics) {
            this.lastUpdate = System.currentTimeMillis();
            if (this.extendedPeriod > 0L && this.lastUpdate - this.lastExtUpdate >= this.extendedPeriod) {
                this.lastExtUpdate = this.lastUpdate;
                this.splitTime.resetMinMaxAvg();
                this.splitSize.resetMinMaxAvg();
                this.resetAllMinMax();
            }
            this.cluster_requests.pushMetric(this.metricsRecord);
            this.splitTime.pushMetric(this.metricsRecord);
            this.splitSize.pushMetric(this.metricsRecord);
        }
        this.metricsRecord.update();
    }

    public void resetAllMinMax() {
    }

    public synchronized void addSplit(long time, long size) {
        this.splitTime.inc(time);
        this.splitSize.inc(size);
    }

    public float getRequests() {
        return this.cluster_requests.getPreviousIntervalValue();
    }

    public void incrementRequests(int inc) {
        this.cluster_requests.inc(inc);
    }
}

