/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.RemoteExceptionHandler;
import org.apache.hadoop.hbase.regionserver.CompactionRequestor;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.PriorityCompactionQueue;
import org.apache.hadoop.hbase.regionserver.SplitTransaction;
import org.apache.hadoop.util.StringUtils;

public class CompactSplitThread
extends Thread
implements CompactionRequestor {
    static final Log LOG = LogFactory.getLog(CompactSplitThread.class);
    private final long frequency;
    private final ReentrantLock lock = new ReentrantLock();
    private final HRegionServer server;
    private final Configuration conf;
    private final PriorityCompactionQueue compactionQueue = new PriorityCompactionQueue();
    public static final int PRIORITY_USER = 1;
    private int regionSplitLimit;

    public CompactSplitThread(HRegionServer server) {
        this.server = server;
        this.conf = server.getConfiguration();
        this.regionSplitLimit = this.conf.getInt("hbase.regionserver.regionSplitLimit", Integer.MAX_VALUE);
        this.frequency = this.conf.getLong("hbase.regionserver.thread.splitcompactcheckfrequency", 20000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.server.isStopped()) {
            HRegion r = null;
            try {
                r = this.compactionQueue.poll(this.frequency, TimeUnit.MILLISECONDS);
                if (r == null) continue;
                this.lock.lock();
                try {
                    if (this.server.isStopped()) continue;
                    byte[] midKey = r.compactStores();
                    if (r.getLastCompactInfo() != null) {
                        this.server.getMetrics().addCompaction(r.getLastCompactInfo());
                    }
                    if (!this.shouldSplitRegion() || midKey == null || this.server.isStopped()) continue;
                    this.split(r, midKey);
                }
                finally {
                    this.lock.unlock();
                }
            }
            catch (InterruptedException ex) {
            }
            catch (IOException ex) {
                LOG.error((Object)("Compaction/Split failed for region " + r.getRegionNameAsString()), (Throwable)RemoteExceptionHandler.checkIOException(ex));
                if (this.server.checkFileSystem()) continue;
                break;
            }
            catch (Exception ex) {
                LOG.error((Object)("Compaction failed" + (r != null ? " for region " + r.getRegionNameAsString() : "")), (Throwable)ex);
                if (this.server.checkFileSystem()) continue;
                break;
            }
        }
        this.compactionQueue.clear();
        LOG.info((Object)(this.getName() + " exiting"));
    }

    @Override
    public synchronized void requestCompaction(HRegion r, String why) {
        this.requestCompaction(r, false, why, r.getCompactPriority());
    }

    @Override
    public synchronized void requestCompaction(HRegion r, String why, int p) {
        this.requestCompaction(r, false, why, p);
    }

    public synchronized void requestCompaction(HRegion r, boolean force, String why, int priority) {
        if (this.server.isStopped()) {
            return;
        }
        if (force) {
            r.setForceMajorCompaction(force);
        }
        if (this.compactionQueue.add(r, priority) && LOG.isDebugEnabled()) {
            LOG.debug((Object)("Compaction " + (force ? "(major) " : "") + "requested for region " + r.getRegionNameAsString() + (why != null && !why.isEmpty() ? " because: " + why : "") + "; Priority: " + priority + "; Compaction queue size: " + this.compactionQueue.size()));
        }
    }

    private void split(HRegion parent, byte[] midKey) throws IOException {
        long startTime = System.currentTimeMillis();
        SplitTransaction st = new SplitTransaction(parent, midKey);
        if (!st.prepare()) {
            return;
        }
        try {
            st.execute(this.server, this.server);
        }
        catch (IOException ioe) {
            try {
                LOG.info((Object)("Running rollback of failed split of " + parent.getRegionNameAsString() + "; " + ioe.getMessage()));
                st.rollback(this.server);
                LOG.info((Object)("Successful rollback of failed split of " + parent.getRegionNameAsString()));
            }
            catch (RuntimeException e) {
                LOG.info((Object)("Failed rollback of failed split of " + parent.getRegionNameAsString() + " -- aborting server"), (Throwable)e);
                this.server.abort("Failed split");
            }
            return;
        }
        this.server.reportSplit(parent.getRegionInfo(), st.getFirstDaughter(), st.getSecondDaughter());
        LOG.info((Object)("Region split, META updated, and report to master. Parent=" + parent.getRegionInfo().getRegionNameAsString() + ", new regions: " + st.getFirstDaughter().getRegionNameAsString() + ", " + st.getSecondDaughter().getRegionNameAsString() + ". Split took " + StringUtils.formatTimeDiff((long)System.currentTimeMillis(), (long)startTime)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void interruptIfNecessary() {
        if (this.lock.tryLock()) {
            try {
                this.interrupt();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public int getCompactionQueueSize() {
        return this.compactionQueue.size();
    }

    private boolean shouldSplitRegion() {
        return this.regionSplitLimit > this.server.getNumberOfOnlineRegions();
    }

    public int getRegionSplitLimit() {
        return this.regionSplitLimit;
    }
}

