/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.KeyValueHeap;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;

public class MinorCompactingStoreScanner
implements KeyValueScanner,
InternalScanner {
    private KeyValueHeap heap;
    private KeyValue.KVComparator comparator;

    MinorCompactingStoreScanner(Store store, List<? extends KeyValueScanner> scanners) throws IOException {
        this.comparator = store.comparator;
        KeyValue firstKv = KeyValue.createFirstOnRow(HConstants.EMPTY_START_ROW);
        for (KeyValueScanner keyValueScanner : scanners) {
            keyValueScanner.seek(firstKv);
        }
        this.heap = new KeyValueHeap(scanners, store.comparator);
    }

    MinorCompactingStoreScanner(String cfName, KeyValue.KVComparator comparator, List<? extends KeyValueScanner> scanners) throws IOException {
        this.comparator = comparator;
        KeyValue firstKv = KeyValue.createFirstOnRow(HConstants.EMPTY_START_ROW);
        for (KeyValueScanner keyValueScanner : scanners) {
            keyValueScanner.seek(firstKv);
        }
        this.heap = new KeyValueHeap(scanners, comparator);
    }

    @Override
    public KeyValue peek() {
        return this.heap.peek();
    }

    @Override
    public KeyValue next() throws IOException {
        return this.heap.next();
    }

    @Override
    public boolean seek(KeyValue key) {
        throw new UnsupportedOperationException("Can't seek a MinorCompactingStoreScanner");
    }

    @Override
    public boolean reseek(KeyValue key) {
        return this.seek(key);
    }

    public boolean next(StoreFile.Writer writer) throws IOException {
        KeyValue kv;
        KeyValue row = this.heap.peek();
        if (row == null) {
            this.close();
            return false;
        }
        while ((kv = this.heap.peek()) != null) {
            if (this.comparator.compareRows(row, kv) != 0) {
                return true;
            }
            writer.append(this.heap.next());
        }
        this.close();
        return false;
    }

    @Override
    public boolean next(List<KeyValue> results) throws IOException {
        KeyValue kv;
        KeyValue row = this.heap.peek();
        if (row == null) {
            this.close();
            return false;
        }
        while ((kv = this.heap.peek()) != null) {
            if (this.comparator.compareRows(row, kv) != 0) {
                return true;
            }
            results.add(this.heap.next());
        }
        this.close();
        return false;
    }

    @Override
    public boolean next(List<KeyValue> results, int limit) throws IOException {
        return this.next(results);
    }

    @Override
    public void close() {
        this.heap.close();
    }

    @Override
    public long getSequenceID() {
        return 0L;
    }
}

