/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.handler;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.util.Progressable;
import org.apache.zookeeper.KeeperException;

public class OpenRegionHandler
extends EventHandler {
    private static final Log LOG = LogFactory.getLog(OpenRegionHandler.class);
    private final RegionServerServices rsServices;
    private final HRegionInfo regionInfo;

    public OpenRegionHandler(Server server, RegionServerServices rsServices, HRegionInfo regionInfo) {
        this(server, rsServices, regionInfo, EventHandler.EventType.M_RS_OPEN_REGION);
    }

    protected OpenRegionHandler(Server server, RegionServerServices rsServices, HRegionInfo regionInfo, EventHandler.EventType eventType) {
        super(server, eventType);
        this.rsServices = rsServices;
        this.regionInfo = regionInfo;
    }

    public HRegionInfo getRegionInfo() {
        return this.regionInfo;
    }

    @Override
    public void process() throws IOException {
        final String name = this.regionInfo.getRegionNameAsString();
        LOG.debug((Object)("Processing open of " + name));
        if (this.server.isStopped()) {
            LOG.info((Object)("Server stopping, skipping open of " + name));
            return;
        }
        String encodedName = this.regionInfo.getEncodedName();
        HRegion region = this.rsServices.getFromOnlineRegions(encodedName);
        if (region != null) {
            LOG.warn((Object)("Attempting open of " + name + " but it's already online on this server"));
            return;
        }
        int openingVersion = this.transitionZookeeperOfflineToOpening(encodedName);
        if (openingVersion == -1) {
            return;
        }
        final AtomicInteger openingInteger = new AtomicInteger(openingVersion);
        try {
            region = HRegion.openHRegion(this.regionInfo, this.rsServices.getWAL(), this.server.getConfiguration(), this.rsServices.getFlushRequester(), new Progressable(){

                public void progress() {
                    try {
                        int vsn = ZKAssign.retransitionNodeOpening(OpenRegionHandler.this.server.getZooKeeper(), OpenRegionHandler.this.regionInfo, OpenRegionHandler.this.server.getServerName(), openingInteger.get());
                        if (vsn == -1) {
                            throw KeeperException.create((KeeperException.Code)KeeperException.Code.BADVERSION);
                        }
                        openingInteger.set(vsn);
                    }
                    catch (KeeperException e) {
                        OpenRegionHandler.this.server.abort("ZK exception refreshing OPENING node; " + name, e);
                    }
                }
            });
        }
        catch (IOException e) {
            LOG.error((Object)("IOException instantiating region for " + (Object)((Object)this.regionInfo) + "; resetting state of transition node from OPENING to OFFLINE"));
            try {
                ZKAssign.forceNodeOffline(this.server.getZooKeeper(), this.regionInfo, this.server.getServerName());
            }
            catch (KeeperException e1) {
                LOG.error((Object)("Error forcing node back to OFFLINE from OPENING; " + name));
            }
            return;
        }
        openingVersion = openingInteger.get();
        try {
            openingVersion = ZKAssign.retransitionNodeOpening(this.server.getZooKeeper(), this.regionInfo, this.server.getServerName(), openingVersion);
            if (openingVersion == -1) {
                LOG.warn((Object)("Completed the OPEN of region " + name + " but when transitioning from " + " OPENING to OPENING got a version mismatch, someone else clashed " + "-- closing region"));
                this.cleanupFailedOpen(region);
                return;
            }
        }
        catch (KeeperException e) {
            LOG.error((Object)("Failed transitioning node " + name + " from OPENING to OPENED -- closing region"), (Throwable)e);
            this.cleanupFailedOpen(region);
            return;
        }
        catch (IOException e) {
            LOG.error((Object)("Failed to close region " + name + " after failing to transition -- closing region"), (Throwable)e);
            this.cleanupFailedOpen(region);
            return;
        }
        try {
            this.rsServices.postOpenDeployTasks(region, this.server.getCatalogTracker(), false);
        }
        catch (IOException e) {
            LOG.error((Object)("Error updating " + name + " location in catalog table -- " + "closing region"), (Throwable)e);
            this.cleanupFailedOpen(region);
            return;
        }
        catch (KeeperException e) {
            LOG.error((Object)("ZK Error updating " + name + " location in catalog " + "table -- closing region"), (Throwable)e);
            this.cleanupFailedOpen(region);
            return;
        }
        try {
            if (ZKAssign.transitionNodeOpened(this.server.getZooKeeper(), this.regionInfo, this.server.getServerName(), openingVersion) == -1) {
                LOG.warn((Object)("Completed the OPEN of region " + name + " but when transitioning from " + " OPENING to OPENED got a version mismatch, someone else clashed " + "so now unassigning -- closing region"));
                this.cleanupFailedOpen(region);
                return;
            }
        }
        catch (KeeperException e) {
            LOG.error((Object)("Failed transitioning node " + name + " from OPENING to OPENED -- closing region"), (Throwable)e);
            this.cleanupFailedOpen(region);
            return;
        }
        catch (IOException e) {
            LOG.error((Object)("Failed to close " + name + " after failing to transition -- closing region"), (Throwable)e);
            this.cleanupFailedOpen(region);
            return;
        }
        LOG.debug((Object)("Opened " + name));
    }

    private void cleanupFailedOpen(HRegion region) throws IOException {
        if (region != null) {
            region.close();
        }
        this.rsServices.removeFromOnlineRegions(this.regionInfo.getEncodedName());
    }

    int transitionZookeeperOfflineToOpening(String encodedName) {
        int openingVersion = -1;
        try {
            openingVersion = ZKAssign.transitionNodeOpening(this.server.getZooKeeper(), this.regionInfo, this.server.getServerName());
            if (openingVersion == -1) {
                LOG.warn((Object)"Error transitioning node from OFFLINE to OPENING, aborting open");
            }
        }
        catch (KeeperException e) {
            LOG.error((Object)("Error transitioning node from OFFLINE to OPENING for region " + encodedName), (Throwable)e);
        }
        return openingVersion;
    }
}

