/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.WritableComparable;

public class HLogKey
implements WritableComparable<HLogKey> {
    private byte[] encodedRegionName;
    private byte[] tablename;
    private long logSeqNum;
    private long writeTime;
    private byte clusterId;

    public HLogKey() {
        this(null, null, 0L, Long.MAX_VALUE);
    }

    public HLogKey(byte[] encodedRegionName, byte[] tablename, long logSeqNum, long now) {
        this.encodedRegionName = encodedRegionName;
        this.tablename = tablename;
        this.logSeqNum = logSeqNum;
        this.writeTime = now;
        this.clusterId = 0;
    }

    public byte[] getEncodedRegionName() {
        return this.encodedRegionName;
    }

    public byte[] getTablename() {
        return this.tablename;
    }

    public long getLogSeqNum() {
        return this.logSeqNum;
    }

    void setLogSeqNum(long logSeqNum) {
        this.logSeqNum = logSeqNum;
    }

    public long getWriteTime() {
        return this.writeTime;
    }

    public byte getClusterId() {
        return this.clusterId;
    }

    public void setClusterId(byte clusterId) {
        this.clusterId = clusterId;
    }

    public String toString() {
        return Bytes.toString(this.tablename) + "/" + Bytes.toString(this.encodedRegionName) + "/" + this.logSeqNum;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.compareTo((HLogKey)obj) == 0;
    }

    public int hashCode() {
        int result = Bytes.hashCode(this.encodedRegionName);
        result = (int)((long)result ^ this.logSeqNum);
        result = (int)((long)result ^ this.writeTime);
        return result ^= this.clusterId;
    }

    public int compareTo(HLogKey o) {
        int result = Bytes.compareTo(this.encodedRegionName, o.encodedRegionName);
        if (result == 0) {
            if (this.logSeqNum < o.logSeqNum) {
                result = -1;
            } else if (this.logSeqNum > o.logSeqNum) {
                result = 1;
            }
            if (result == 0) {
                if (this.writeTime < o.writeTime) {
                    result = -1;
                } else if (this.writeTime > o.writeTime) {
                    return 1;
                }
            }
        }
        return result;
    }

    public void write(DataOutput out) throws IOException {
        Bytes.writeByteArray(out, this.encodedRegionName);
        Bytes.writeByteArray(out, this.tablename);
        out.writeLong(this.logSeqNum);
        out.writeLong(this.writeTime);
        out.writeByte(this.clusterId);
    }

    public void readFields(DataInput in) throws IOException {
        this.encodedRegionName = Bytes.readByteArray(in);
        this.tablename = Bytes.readByteArray(in);
        this.logSeqNum = in.readLong();
        this.writeTime = in.readLong();
        try {
            this.clusterId = in.readByte();
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }
}

