/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.EOFException;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.RemoteExceptionHandler;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;

public class HLogSplitter {
    private static final String LOG_SPLITTER_IMPL = "hbase.hlog.splitter.impl";
    static final Log LOG = LogFactory.getLog(HLogSplitter.class);
    private long splitTime = 0L;
    private long splitSize = 0L;
    public static final String RECOVERED_EDITS = "recovered.edits";

    public static HLogSplitter createLogSplitter(Configuration conf) {
        Class splitterClass = conf.getClass(LOG_SPLITTER_IMPL, HLogSplitter.class);
        try {
            return (HLogSplitter)splitterClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public List<Path> splitLog(Path rootDir, Path srcDir, Path oldLogDir, FileSystem fs, Configuration conf) throws IOException {
        long startTime = System.currentTimeMillis();
        List<Path> splits = null;
        if (!fs.exists(srcDir)) {
            return splits;
        }
        FileStatus[] logfiles = fs.listStatus(srcDir);
        if (logfiles == null || logfiles.length == 0) {
            return splits;
        }
        LOG.info((Object)("Splitting " + logfiles.length + " hlog(s) in " + srcDir.toString()));
        splits = this.splitLog(rootDir, srcDir, oldLogDir, logfiles, fs, conf);
        try {
            FileStatus[] files;
            for (FileStatus file : files = fs.listStatus(srcDir)) {
                Path newPath = HLog.getHLogArchivePath(oldLogDir, file.getPath());
                LOG.info((Object)("Moving " + FSUtils.getPath(file.getPath()) + " to " + FSUtils.getPath(newPath)));
                if (fs.rename(file.getPath(), newPath)) continue;
                throw new IOException("Unable to rename " + file.getPath() + " to " + newPath);
            }
            LOG.debug((Object)("Moved " + files.length + " log files to " + FSUtils.getPath(oldLogDir)));
            if (!fs.delete(srcDir, true)) {
                throw new IOException("Unable to delete " + srcDir);
            }
        }
        catch (IOException e) {
            e = RemoteExceptionHandler.checkIOException(e);
            IOException io = new IOException("Cannot delete: " + srcDir);
            io.initCause(e);
            throw io;
        }
        this.splitTime = System.currentTimeMillis() - startTime;
        LOG.info((Object)("hlog file splitting completed in " + this.splitTime + " ms for " + srcDir.toString()));
        return splits;
    }

    public long getTime() {
        return this.splitTime;
    }

    public long getSize() {
        return this.splitSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Path> splitLog(Path rootDir, Path srcDir, Path oldLogDir, FileStatus[] logfiles, FileSystem fs, Configuration conf) throws IOException {
        ArrayList<Path> processedLogs = new ArrayList<Path>();
        ArrayList<Path> corruptedLogs = new ArrayList<Path>();
        Map<byte[], WriterAndPath> logWriters = Collections.synchronizedMap(new TreeMap(Bytes.BYTES_COMPARATOR));
        ArrayList<Path> splits = null;
        int logFilesPerStep = conf.getInt("hbase.hlog.split.batch.size", 3);
        boolean skipErrors = conf.getBoolean("hbase.hlog.split.skip.errors", false);
        this.splitSize = 0L;
        try {
            int i = -1;
            while (i < logfiles.length) {
                TreeMap<byte[], LinkedList<HLog.Entry>> editsByRegion = new TreeMap<byte[], LinkedList<HLog.Entry>>(Bytes.BYTES_COMPARATOR);
                for (int j = 0; j < logFilesPerStep && ++i != logfiles.length; ++j) {
                    FileStatus log = logfiles[i];
                    Path logPath = log.getPath();
                    long logLength = log.getLen();
                    this.splitSize += logLength;
                    LOG.debug((Object)("Splitting hlog " + (i + 1) + " of " + logfiles.length + ": " + logPath + ", length=" + logLength));
                    try {
                        FSUtils.recoverFileLease(fs, logPath, conf);
                        this.parseHLog(log, editsByRegion, fs, conf);
                        processedLogs.add(logPath);
                        continue;
                    }
                    catch (EOFException eof) {
                        LOG.info((Object)("EOF from hlog " + logPath + ".  continuing"));
                        processedLogs.add(logPath);
                        continue;
                    }
                    catch (IOException e) {
                        if (e.getCause() instanceof ParseException) {
                            LOG.warn((Object)("ParseException from hlog " + logPath + ".  continuing"));
                            processedLogs.add(logPath);
                            continue;
                        }
                        if (skipErrors) {
                            LOG.info((Object)("Got while parsing hlog " + logPath + ". Marking as corrupted"), (Throwable)e);
                            corruptedLogs.add(logPath);
                            continue;
                        }
                        throw e;
                    }
                }
                this.writeEditsBatchToRegions(editsByRegion, logWriters, rootDir, fs, conf);
            }
            if (fs.listStatus(srcDir).length > processedLogs.size() + corruptedLogs.size()) {
                throw new IOException("Discovered orphan hlog after split. Maybe HRegionServer was not dead when we started");
            }
            HLogSplitter.archiveLogs(corruptedLogs, processedLogs, oldLogDir, fs, conf);
            splits = new ArrayList(logWriters.size());
        }
        catch (Throwable throwable) {
            splits = new ArrayList<Path>(logWriters.size());
            for (WriterAndPath wap : logWriters.values()) {
                wap.w.close();
                splits.add(wap.p);
                LOG.debug((Object)("Closed " + wap.p));
            }
            throw throwable;
        }
        for (WriterAndPath wap : logWriters.values()) {
            wap.w.close();
            splits.add(wap.p);
            LOG.debug((Object)("Closed " + wap.p));
        }
        return splits;
    }

    private void writeEditsBatchToRegions(Map<byte[], LinkedList<HLog.Entry>> splitLogsMap, Map<byte[], WriterAndPath> logWriters, Path rootDir, FileSystem fs, Configuration conf) throws IOException {
        HashMap<byte[], Future<Void>> writeFutureResult;
        block10: {
            int logWriterThreads = conf.getInt("hbase.regionserver.hlog.splitlog.writer.threads", 3);
            boolean skipErrors = conf.getBoolean("hbase.skip.errors", false);
            writeFutureResult = new HashMap<byte[], Future<Void>>();
            ThreadFactoryBuilder builder = new ThreadFactoryBuilder();
            builder.setNameFormat("SplitWriter-%1$d");
            ThreadFactory factory = builder.build();
            ThreadPoolExecutor threadPool = (ThreadPoolExecutor)Executors.newFixedThreadPool(logWriterThreads, factory);
            for (byte[] region : splitLogsMap.keySet()) {
                Callable<Void> splitter = this.createNewSplitter(rootDir, logWriters, splitLogsMap, region, fs, conf);
                writeFutureResult.put(region, threadPool.submit(splitter));
            }
            threadPool.shutdown();
            try {
                int j = 0;
                while (!threadPool.awaitTermination(5L, TimeUnit.SECONDS)) {
                    String message = "Waiting for hlog writers to terminate, elapsed " + j * 5 + " seconds";
                    if (j < 30) {
                        LOG.debug((Object)message);
                    } else {
                        LOG.info((Object)message);
                    }
                    ++j;
                }
            }
            catch (InterruptedException ex) {
                LOG.warn((Object)"Hlog writers were interrupted, possible data loss!");
                if (skipErrors) break block10;
                throw new IOException("Could not finish writing log entries", ex);
            }
        }
        for (Map.Entry entry : writeFutureResult.entrySet()) {
            try {
                ((Future)entry.getValue()).get();
            }
            catch (ExecutionException e) {
                throw new IOException(e.getCause());
            }
            catch (InterruptedException e1) {
                LOG.warn((Object)("Writer for region " + Bytes.toString((byte[])entry.getKey()) + " was interrupted, however the write process should have " + "finished. Throwing up "), (Throwable)e1);
                throw new IOException(e1.getCause());
            }
        }
    }

    private static void archiveLogs(List<Path> corruptedLogs, List<Path> processedLogs, Path oldLogDir, FileSystem fs, Configuration conf) throws IOException {
        Path corruptDir = new Path(conf.get("hbase.rootdir"), conf.get("hbase.regionserver.hlog.splitlog.corrupt.dir", ".corrupt"));
        if (!fs.mkdirs(corruptDir)) {
            LOG.info((Object)("Unable to mkdir " + corruptDir));
        }
        fs.mkdirs(oldLogDir);
        for (Path corrupted : corruptedLogs) {
            Path p;
            if (!fs.rename(corrupted, p = new Path(corruptDir, corrupted.getName()))) {
                LOG.info((Object)("Unable to move corrupted log " + corrupted + " to " + p));
                continue;
            }
            LOG.info((Object)("Moving corrupted log " + corrupted + " to " + p));
        }
        for (Path p : processedLogs) {
            Path newPath;
            if (!fs.rename(p, newPath = HLog.getHLogArchivePath(oldLogDir, p))) {
                LOG.info((Object)("Unable to move  " + p + " to " + newPath));
                continue;
            }
            LOG.info((Object)("Archived processed log " + p + " to " + newPath));
        }
    }

    static Path getRegionSplitEditsPath(FileSystem fs, HLog.Entry logEntry, Path rootDir) throws IOException {
        Path tableDir = HTableDescriptor.getTableDir(rootDir, logEntry.getKey().getTablename());
        Path regiondir = HRegion.getRegionDir(tableDir, Bytes.toString(logEntry.getKey().getEncodedRegionName()));
        if (!fs.exists(regiondir)) {
            LOG.info((Object)("This region's directory doesn't exist: " + regiondir.toString() + ". It is very likely that it was" + " already split so it's safe to discard those edits."));
            return null;
        }
        Path dir = HLog.getRegionDirRecoveredEditsDir(regiondir);
        if (!fs.exists(dir) && !fs.mkdirs(dir)) {
            LOG.warn((Object)("mkdir failed on " + dir));
        }
        return new Path(dir, HLogSplitter.formatRecoveredEditsFileName(logEntry.getKey().getLogSeqNum()));
    }

    static String formatRecoveredEditsFileName(long seqid) {
        return String.format("%019d", seqid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseHLog(FileStatus logfile, Map<byte[], LinkedList<HLog.Entry>> splitLogsMap, FileSystem fs, Configuration conf) throws IOException {
        HLog.Reader in;
        long length = logfile.getLen();
        if (length <= 0L) {
            LOG.warn((Object)("File " + logfile.getPath() + " might be still open, length is 0"));
        }
        Path path = logfile.getPath();
        int editsCount = 0;
        try {
            in = this.getReader(fs, path, conf);
        }
        catch (EOFException e) {
            if (length <= 0L) {
                LOG.warn((Object)("Could not open " + path + " for reading. File is empty" + e));
                return;
            }
            throw e;
        }
        try {
            HLog.Entry entry;
            while ((entry = in.next()) != null) {
                byte[] region = entry.getKey().getEncodedRegionName();
                LinkedList<HLog.Entry> queue = splitLogsMap.get(region);
                if (queue == null) {
                    queue = new LinkedList();
                    splitLogsMap.put(region, queue);
                }
                queue.addLast(entry);
                ++editsCount;
            }
        }
        finally {
            LOG.debug((Object)("Pushed=" + editsCount + " entries from " + path));
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                LOG.warn((Object)"Close log reader in finally threw exception -- continuing", (Throwable)e);
            }
        }
    }

    private Callable<Void> createNewSplitter(final Path rootDir, final Map<byte[], WriterAndPath> logWriters, final Map<byte[], LinkedList<HLog.Entry>> logEntries, final byte[] region, final FileSystem fs, final Configuration conf) {
        return new Callable<Void>(){

            public String getName() {
                return "Split writer thread for region " + Bytes.toStringBinary(region);
            }

            @Override
            public Void call() throws IOException {
                LinkedList entries = (LinkedList)logEntries.get(region);
                LOG.debug((Object)(this.getName() + " got " + entries.size() + " to process"));
                long threadTime = System.currentTimeMillis();
                try {
                    int editsCount = 0;
                    WriterAndPath wap = (WriterAndPath)logWriters.get(region);
                    for (HLog.Entry logEntry : entries) {
                        if (wap == null) {
                            Path regionedits = HLogSplitter.getRegionSplitEditsPath(fs, logEntry, rootDir);
                            if (regionedits == null) break;
                            if (fs.exists(regionedits)) {
                                LOG.warn((Object)("Found existing old edits file. It could be the result of a previous failed split attempt. Deleting " + regionedits + ", length=" + fs.getFileStatus(regionedits).getLen()));
                                if (!fs.delete(regionedits, false)) {
                                    LOG.warn((Object)("Failed delete of old " + regionedits));
                                }
                            }
                            HLog.Writer w = HLogSplitter.this.createWriter(fs, regionedits, conf);
                            wap = new WriterAndPath(regionedits, w);
                            logWriters.put(region, wap);
                            LOG.debug((Object)("Creating writer path=" + regionedits + " region=" + Bytes.toStringBinary(region)));
                        }
                        wap.w.append(logEntry);
                        ++editsCount;
                    }
                    LOG.debug((Object)(this.getName() + " Applied " + editsCount + " total edits to " + Bytes.toStringBinary(region) + " in " + (System.currentTimeMillis() - threadTime) + "ms"));
                }
                catch (IOException e) {
                    e = RemoteExceptionHandler.checkIOException(e);
                    LOG.fatal((Object)(this.getName() + " Got while writing log entry to log"), (Throwable)e);
                    throw e;
                }
                return null;
            }
        };
    }

    protected HLog.Writer createWriter(FileSystem fs, Path logfile, Configuration conf) throws IOException {
        return HLog.createWriter(fs, logfile, conf);
    }

    protected HLog.Reader getReader(FileSystem fs, Path curLogFile, Configuration conf) throws IOException {
        return HLog.getReader(fs, curLogFile, conf);
    }

    private static final class WriterAndPath {
        final Path p;
        final HLog.Writer w;

        WriterAndPath(Path p, HLog.Writer w) {
            this.p = p;
            this.w = w;
        }
    }
}

