/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.replication.ReplicationZookeeper;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSource;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceInterface;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperListener;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

public class ReplicationSourceManager {
    private static final Log LOG = LogFactory.getLog(ReplicationSourceManager.class);
    private final List<ReplicationSourceInterface> sources = new ArrayList<ReplicationSourceInterface>();
    private final List<ReplicationSourceInterface> oldsources;
    private final AtomicBoolean replicating;
    private final ReplicationZookeeper zkHelper;
    private final Stoppable stopper;
    private final SortedSet<String> hlogs;
    private final Configuration conf;
    private final FileSystem fs;
    private Path latestPath;
    private final List<String> otherRegionServers;
    private final Path logDir;
    private final Path oldLogDir;

    public ReplicationSourceManager(ReplicationZookeeper zkHelper, Configuration conf, Stoppable stopper, FileSystem fs, AtomicBoolean replicating, Path logDir, Path oldLogDir) {
        this.replicating = replicating;
        this.zkHelper = zkHelper;
        this.stopper = stopper;
        this.hlogs = new TreeSet<String>();
        this.oldsources = new ArrayList<ReplicationSourceInterface>();
        this.conf = conf;
        this.fs = fs;
        this.logDir = logDir;
        this.oldLogDir = oldLogDir;
        this.zkHelper.registerRegionServerListener(new OtherRegionServerWatcher(this.zkHelper.getZookeeperWatcher()));
        ArrayList otherRSs = this.zkHelper.getRegisteredRegionServers();
        this.zkHelper.registerRegionServerListener(new PeersWatcher(this.zkHelper.getZookeeperWatcher()));
        this.zkHelper.listPeersIdsAndWatch();
        this.otherRegionServers = otherRSs == null ? new ArrayList() : otherRSs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logPositionAndCleanOldLogs(Path log, String id, long position, boolean queueRecovered) {
        String key = log.getName();
        LOG.info((Object)("Going to report log #" + key + " for position " + position + " in " + log));
        this.zkHelper.writeReplicationStatus(key.toString(), id, position);
        SortedSet<String> sortedSet = this.hlogs;
        synchronized (sortedSet) {
            if (!queueRecovered && this.hlogs.first() != key) {
                SortedSet<String> hlogSet = this.hlogs.headSet(key);
                LOG.info((Object)("Removing " + hlogSet.size() + " logs in the list: " + hlogSet));
                for (String hlog : hlogSet) {
                    this.zkHelper.removeLogFromList(hlog.toString(), id);
                }
                hlogSet.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws IOException {
        for (String string : this.zkHelper.getPeerClusters().keySet()) {
            this.addSource(string);
        }
        List<String> currentReplicators = this.zkHelper.getRegisteredRegionServers();
        if (currentReplicators == null || currentReplicators.size() == 0) {
            return;
        }
        List<String> list = this.otherRegionServers;
        synchronized (list) {
            LOG.info((Object)("Current list of replicators: " + currentReplicators + " other RSs: " + this.otherRegionServers));
        }
        for (String rs : currentReplicators) {
            List<String> list2 = this.otherRegionServers;
            synchronized (list2) {
                if (!this.otherRegionServers.contains(rs)) {
                    this.transferQueues(rs);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReplicationSourceInterface addSource(String id) throws IOException {
        ReplicationSourceInterface src = this.getReplicationSource(this.conf, this.fs, this, this.stopper, this.replicating, id);
        src.setSourceEnabled(true);
        SortedSet<String> sortedSet = this.hlogs;
        synchronized (sortedSet) {
            this.sources.add(src);
            if (this.hlogs.size() > 0) {
                this.zkHelper.addLogToList(this.hlogs.last(), this.sources.get(0).getPeerClusterZnode());
                src.enqueueLog(this.latestPath);
            }
        }
        src.startup();
        return src;
    }

    public void join() {
        if (this.sources.size() == 0) {
            this.zkHelper.deleteOwnRSZNode();
        }
        for (ReplicationSourceInterface source : this.sources) {
            source.terminate("Region server is closing");
        }
    }

    protected SortedSet<String> getHLogs() {
        return new TreeSet<String>(this.hlogs);
    }

    public List<ReplicationSourceInterface> getSources() {
        return this.sources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void logRolled(Path newLog) {
        if (!this.replicating.get()) {
            LOG.warn((Object)"Replication stopped, won't add new log");
            return;
        }
        if (this.sources.size() > 0) {
            this.zkHelper.addLogToList(newLog.getName(), this.sources.get(0).getPeerClusterZnode());
        }
        SortedSet<String> sortedSet = this.hlogs;
        synchronized (sortedSet) {
            this.hlogs.add(newLog.getName());
        }
        this.latestPath = newLog;
        for (ReplicationSourceInterface source : this.sources) {
            source.enqueueLog(newLog);
        }
    }

    public ReplicationZookeeper getRepZkWrapper() {
        return this.zkHelper;
    }

    public ReplicationSourceInterface getReplicationSource(Configuration conf, FileSystem fs, ReplicationSourceManager manager, Stoppable stopper, AtomicBoolean replicating, String peerClusterId) throws IOException {
        ReplicationSourceInterface src;
        try {
            Class<?> c = Class.forName(conf.get("replication.replicationsource.implementation", ReplicationSource.class.getCanonicalName()));
            src = (ReplicationSourceInterface)c.newInstance();
        }
        catch (Exception e) {
            LOG.warn((Object)"Passed replication source implemention throws errors, defaulting to ReplicationSource", (Throwable)e);
            src = new ReplicationSource();
        }
        src.init(conf, fs, manager, stopper, replicating, peerClusterId);
        return src;
    }

    public void transferQueues(String rsZnode) {
        if (this.stopper.isStopped()) {
            LOG.info((Object)"Not transferring queue since we are shutting down");
            return;
        }
        if (!this.zkHelper.lockOtherRS(rsZnode)) {
            return;
        }
        LOG.info((Object)("Moving " + rsZnode + "'s hlogs to my queue"));
        SortedMap<String, SortedSet<String>> newQueues = this.zkHelper.copyQueuesFromRS(rsZnode);
        this.zkHelper.deleteRsQueues(rsZnode);
        if (newQueues == null || newQueues.size() == 0) {
            return;
        }
        for (Map.Entry<String, SortedSet<String>> entry : newQueues.entrySet()) {
            String peerId = entry.getKey();
            try {
                ReplicationSourceInterface src = this.getReplicationSource(this.conf, this.fs, this, this.stopper, this.replicating, peerId);
                if (!this.zkHelper.getPeerClusters().containsKey(src.getPeerClusterId())) {
                    src.terminate("Recovered queue doesn't belong to any current peer");
                    break;
                }
                this.oldsources.add(src);
                for (String hlog : entry.getValue()) {
                    src.enqueueLog(new Path(this.oldLogDir, hlog));
                }
                src.setSourceEnabled(true);
                src.startup();
            }
            catch (IOException e) {
                LOG.error((Object)"Failed creating a source", (Throwable)e);
            }
        }
    }

    public void closeRecoveredQueue(ReplicationSourceInterface src) {
        LOG.info((Object)("Done with the recovered queue " + src.getPeerClusterZnode()));
        this.oldsources.remove(src);
        this.zkHelper.deleteSource(src.getPeerClusterZnode(), false);
    }

    public void removePeer(String id) {
        LOG.info((Object)("Closing the following queue " + id + ", currently have " + this.sources.size() + " and another " + this.oldsources.size() + " that were recovered"));
        ReplicationSourceInterface srcToRemove = null;
        ArrayList<ReplicationSourceInterface> oldSourcesToDelete = new ArrayList<ReplicationSourceInterface>();
        for (ReplicationSourceInterface src : this.oldsources) {
            if (!id.equals(src.getPeerClusterId())) continue;
            oldSourcesToDelete.add(src);
        }
        for (ReplicationSourceInterface src : oldSourcesToDelete) {
            this.closeRecoveredQueue(src);
        }
        LOG.info((Object)("Number of deleted recovered sources for " + id + ": " + oldSourcesToDelete.size()));
        for (ReplicationSourceInterface src : this.sources) {
            if (!id.equals(src.getPeerClusterId())) continue;
            srcToRemove = src;
            break;
        }
        if (srcToRemove == null) {
            LOG.error((Object)("The queue we wanted to close is missing " + id));
            return;
        }
        srcToRemove.terminate("Replication stream was removed by a user");
        this.sources.remove(srcToRemove);
        this.zkHelper.deleteSource(id, true);
    }

    public Path getOldLogDir() {
        return this.oldLogDir;
    }

    public Path getLogDir() {
        return this.logDir;
    }

    public FileSystem getFs() {
        return this.fs;
    }

    public class PeersWatcher
    extends ZooKeeperListener {
        public PeersWatcher(ZooKeeperWatcher watcher) {
            super(watcher);
        }

        @Override
        public void nodeDeleted(String path) {
            List<String> peers = this.refreshPeersList(path);
            if (peers == null) {
                return;
            }
            ReplicationSourceManager.this.zkHelper;
            String id = ReplicationZookeeper.getZNodeName(path);
            ReplicationSourceManager.this.removePeer(id);
        }

        @Override
        public void nodeChildrenChanged(String path) {
            List<String> peers = this.refreshPeersList(path);
            if (peers == null) {
                return;
            }
            for (String id : peers) {
                try {
                    boolean added = ReplicationSourceManager.this.zkHelper.connectToPeer(id);
                    if (!added) continue;
                    ReplicationSourceManager.this.addSource(id);
                }
                catch (IOException e) {
                    LOG.error((Object)"Error while adding a new peer", (Throwable)e);
                }
                catch (KeeperException e) {
                    LOG.error((Object)"Error while adding a new peer", (Throwable)e);
                }
            }
        }

        private List<String> refreshPeersList(String path) {
            if (!path.startsWith(ReplicationSourceManager.this.zkHelper.getPeersZNode())) {
                return null;
            }
            return ReplicationSourceManager.this.zkHelper.listPeersIdsAndWatch();
        }
    }

    public class OtherRegionServerWatcher
    extends ZooKeeperListener {
        public OtherRegionServerWatcher(ZooKeeperWatcher watcher) {
            super(watcher);
        }

        @Override
        public void nodeCreated(String path) {
            this.refreshRegionServersList(path);
        }

        @Override
        public void nodeDeleted(String path) {
            boolean cont = this.refreshRegionServersList(path);
            if (!cont) {
                return;
            }
            LOG.info((Object)(path + " znode expired, trying to lock it"));
            ReplicationSourceManager.this.zkHelper;
            ReplicationSourceManager.this.transferQueues(ReplicationZookeeper.getZNodeName(path));
        }

        @Override
        public void nodeChildrenChanged(String path) {
            this.refreshRegionServersList(path);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean refreshRegionServersList(String path) {
            if (!path.startsWith(((ReplicationSourceManager)ReplicationSourceManager.this).zkHelper.getZookeeperWatcher().rsZNode)) {
                return false;
            }
            List<String> newRsList = ReplicationSourceManager.this.zkHelper.getRegisteredRegionServers();
            if (newRsList == null) {
                return false;
            }
            List list = ReplicationSourceManager.this.otherRegionServers;
            synchronized (list) {
                ReplicationSourceManager.this.otherRegionServers.clear();
                ReplicationSourceManager.this.otherRegionServers.addAll(newRsList);
            }
            return true;
        }
    }
}

