/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import com.sun.jersey.spi.container.servlet.ServletContainer;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.rest.Constants;
import org.apache.hadoop.hbase.rest.RESTServlet;
import org.apache.hadoop.hbase.rest.ResourceConfig;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;

public class Main
implements Constants {
    private static final String DEFAULT_LISTEN_PORT = "8080";

    private static void printUsageAndExit(Options options, int exitCode) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("REST", null, options, "To start the REST server run 'bin/hbase-daemon.sh start rest'\nTo shutdown the REST server run 'bin/hbase-daemon.sh stop rest' or send a kill signal to the rest server pid", true);
        System.exit(exitCode);
    }

    public static void main(String[] args) throws Exception {
        Log LOG = LogFactory.getLog((String)"RESTServer");
        Options options = new Options();
        options.addOption("p", "port", true, "Port to bind to [default:8080]");
        PosixParser parser = new PosixParser();
        CommandLine cmd = parser.parse(options, args);
        List<String> commandLine = Arrays.asList(args);
        boolean stop = commandLine.contains("stop");
        boolean start = commandLine.contains("start");
        if (cmd.hasOption("help") || !start || stop) {
            Main.printUsageAndExit(options, 1);
        }
        int port = 0;
        try {
            port = Integer.parseInt(cmd.getOptionValue("port", DEFAULT_LISTEN_PORT));
        }
        catch (NumberFormatException e) {
            LOG.error((Object)"Could not parse the value provided for the port option", (Throwable)e);
            Main.printUsageAndExit(options, -1);
        }
        ServletHolder sh = new ServletHolder(ServletContainer.class);
        sh.setInitParameter("com.sun.jersey.config.property.resourceConfigClass", ResourceConfig.class.getCanonicalName());
        sh.setInitParameter("com.sun.jersey.config.property.packages", "jetty");
        RESTServlet servlet = RESTServlet.getInstance();
        port = servlet.getConfiguration().getInt("hbase.rest.port", port);
        Server server = new Server(port);
        server.setSendServerVersion(false);
        server.setSendDateHeader(false);
        server.setStopAtShutdown(true);
        Context context = new Context((HandlerContainer)server, "/", 1);
        context.addServlet(sh, "/*");
        server.start();
        server.join();
    }
}

