/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.HTablePool;
import org.apache.hadoop.hbase.rest.Constants;
import org.apache.hadoop.hbase.rest.metrics.RESTMetrics;

public class RESTServlet
implements Constants {
    private static RESTServlet INSTANCE;
    private final Configuration conf;
    private final HTablePool pool;
    private final RESTMetrics metrics = new RESTMetrics();

    public static synchronized RESTServlet getInstance() throws IOException {
        if (INSTANCE == null) {
            INSTANCE = new RESTServlet();
        }
        return INSTANCE;
    }

    public static synchronized RESTServlet getInstance(Configuration conf) throws IOException {
        if (INSTANCE == null) {
            INSTANCE = new RESTServlet(conf);
        }
        return INSTANCE;
    }

    public static synchronized void stop() {
        if (INSTANCE != null) {
            INSTANCE = null;
        }
    }

    RESTServlet() throws IOException {
        this(HBaseConfiguration.create());
    }

    RESTServlet(Configuration conf) throws IOException {
        this.conf = conf;
        this.pool = new HTablePool(conf, 10);
    }

    HTablePool getTablePool() {
        return this.pool;
    }

    Configuration getConfiguration() {
        return this.conf;
    }

    RESTMetrics getMetrics() {
        return this.metrics;
    }
}

