/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.client;

import org.apache.commons.httpclient.Header;

public class Response {
    private int code;
    private Header[] headers;
    private byte[] body;

    public Response(int code) {
        this(code, null, null);
    }

    public Response(int code, Header[] headers) {
        this(code, headers, null);
    }

    public Response(int code, Header[] headers, byte[] body) {
        this.code = code;
        this.headers = headers;
        this.body = body;
    }

    public int getCode() {
        return this.code;
    }

    public Header[] getHeaders() {
        return this.headers;
    }

    public String getLocation() {
        for (Header header : this.headers) {
            if (!header.getName().equals("Location")) continue;
            return header.getValue();
        }
        return null;
    }

    public boolean hasBody() {
        return this.body != null;
    }

    public byte[] getBody() {
        return this.body;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setHeaders(Header[] headers) {
        this.headers = headers;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }
}

