/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.metrics;

import org.apache.hadoop.hbase.metrics.MetricsRate;
import org.apache.hadoop.hbase.rest.metrics.RESTStatistics;
import org.apache.hadoop.metrics.MetricsContext;
import org.apache.hadoop.metrics.MetricsRecord;
import org.apache.hadoop.metrics.MetricsUtil;
import org.apache.hadoop.metrics.Updater;
import org.apache.hadoop.metrics.jvm.JvmMetrics;
import org.apache.hadoop.metrics.util.MetricsRegistry;

public class RESTMetrics
implements Updater {
    private final MetricsRecord metricsRecord;
    private final MetricsRegistry registry = new MetricsRegistry();
    private final RESTStatistics restStatistics;
    private MetricsRate requests = new MetricsRate("requests", this.registry);

    public RESTMetrics() {
        MetricsContext context = MetricsUtil.getContext((String)"rest");
        this.metricsRecord = MetricsUtil.createRecord((MetricsContext)context, (String)"rest");
        String name = Thread.currentThread().getName();
        this.metricsRecord.setTag("REST", name);
        context.registerUpdater((Updater)this);
        JvmMetrics.init((String)"rest", (String)name);
        this.restStatistics = new RESTStatistics(this.registry);
    }

    public void shutdown() {
        if (this.restStatistics != null) {
            this.restStatistics.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUpdates(MetricsContext unused) {
        RESTMetrics rESTMetrics = this;
        synchronized (rESTMetrics) {
            this.requests.pushMetric(this.metricsRecord);
        }
        this.metricsRecord.update();
    }

    public void resetAllMinMax() {
    }

    public float getRequests() {
        return this.requests.getPreviousIntervalValue();
    }

    public void incrementRequests(int inc) {
        this.requests.inc(inc);
    }
}

