/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.io.hfile.Compression;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.io.compress.Compressor;

public class CompressionTest {
    static final Log LOG = LogFactory.getLog(CompressionTest.class);
    private static final Boolean[] compressionTestResults = new Boolean[Compression.Algorithm.values().length];
    protected static Path path;

    public static boolean testCompression(String codec) {
        Compression.Algorithm a;
        codec = codec.toLowerCase();
        try {
            a = Compression.getCompressionAlgorithmByName(codec);
        }
        catch (IllegalArgumentException e) {
            LOG.warn((Object)("Codec type: " + codec + " is not known"));
            return false;
        }
        try {
            CompressionTest.testCompression(a);
            return true;
        }
        catch (IOException ignored) {
            LOG.warn((Object)("Can't instantiate codec: " + codec), (Throwable)ignored);
            return false;
        }
    }

    public static void testCompression(Compression.Algorithm algo) throws IOException {
        if (compressionTestResults[algo.ordinal()] != null) {
            if (compressionTestResults[algo.ordinal()].booleanValue()) {
                return;
            }
            throw new IOException("Compression algorithm '" + algo.getName() + "'" + " previously failed test.");
        }
        try {
            Compressor c = algo.getCompressor();
            algo.returnCompressor(c);
            CompressionTest.compressionTestResults[algo.ordinal()] = true;
        }
        catch (Throwable t) {
            CompressionTest.compressionTestResults[algo.ordinal()] = false;
            throw new IOException(t);
        }
    }

    public static void usage() {
        System.err.println("Usage: CompressionTest HDFS_PATH none|gz|lzo");
        System.exit(1);
    }

    protected static DistributedFileSystem openConnection(String urlString) throws URISyntaxException, IOException {
        URI dfsUri = new URI(urlString);
        Configuration dfsConf = new Configuration();
        DistributedFileSystem dfs = new DistributedFileSystem();
        dfs.initialize(dfsUri, dfsConf);
        return dfs;
    }

    protected static boolean closeConnection(DistributedFileSystem dfs) {
        if (dfs != null) {
            try {
                dfs.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return dfs == null;
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            CompressionTest.usage();
        }
        try {
            DistributedFileSystem dfs = CompressionTest.openConnection(args[0]);
            dfs.delete(path, false);
            HFile.Writer writer = new HFile.Writer((FileSystem)dfs, path, 65536, args[1], null);
            writer.append(Bytes.toBytes("testkey"), Bytes.toBytes("testval"));
            writer.appendFileInfo(Bytes.toBytes("infokey"), Bytes.toBytes("infoval"));
            writer.close();
            HFile.Reader reader = new HFile.Reader((FileSystem)dfs, path, null, false);
            reader.loadFileInfo();
            byte[] key = reader.getFirstKey();
            boolean rc = Bytes.toString(key).equals("testkey");
            reader.close();
            dfs.delete(path, false);
            CompressionTest.closeConnection(dfs);
            if (rc) {
                System.exit(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("FAILED");
        System.exit(1);
    }

    static {
        for (int i = 0; i < compressionTestResults.length; ++i) {
            CompressionTest.compressionTestResults[i] = null;
        }
        path = new Path(".hfile-comp-test");
    }
}

