/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.net.URL;
import java.util.Map;
import org.apache.hadoop.http.HttpServer;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.handler.ContextHandlerCollection;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.DefaultServlet;

public class InfoServer
extends HttpServer {
    public InfoServer(String name, String bindAddress, int port, boolean findPort) throws IOException {
        super(name, bindAddress, port, findPort);
        this.webServer.addHandler((Handler)new ContextHandlerCollection());
    }

    protected void addDefaultApps(ContextHandlerCollection parent, String appDir) throws IOException {
        String logDir;
        super.addDefaultApps(parent, appDir);
        String logsContextPath = "/logs";
        Context oldLogsContext = null;
        for (Map.Entry e : this.defaultContexts.entrySet()) {
            if (!((Context)e.getKey()).getContextPath().equals("/logs")) continue;
            oldLogsContext = (Context)e.getKey();
            break;
        }
        if (oldLogsContext != null) {
            this.defaultContexts.put(oldLogsContext, Boolean.FALSE);
        }
        if ((logDir = System.getProperty("hbase.log.dir")) != null) {
            Context logContext = new Context((HandlerContainer)parent, "/logs");
            logContext.setResourceBase(logDir);
            logContext.addServlet(DefaultServlet.class, "/");
            this.defaultContexts.put(logContext, true);
        }
    }

    protected String getWebAppsPath() throws IOException {
        String master = "master";
        String p = InfoServer.getWebAppDir("master");
        return p.substring(0, p.length() - ("master".length() + 1));
    }

    private static String getWebAppsPath(String path) throws IOException {
        URL url = InfoServer.class.getClassLoader().getResource(path);
        if (url == null) {
            throw new IOException("hbase-webapps not found in CLASSPATH: " + path);
        }
        return url.toString();
    }

    public static String getWebAppDir(String webappName) throws IOException {
        String webappDir = InfoServer.getWebAppsPath("hbase-webapps/" + webappName);
        return webappDir;
    }
}

