/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import java.io.DataInput;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Schema;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.exec.ConditionalTask;
import org.apache.hadoop.hive.ql.exec.ExecDriver;
import org.apache.hadoop.hive.ql.exec.FetchTask;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.TaskResult;
import org.apache.hadoop.hive.ql.exec.TaskRunner;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.history.HiveHistory;
import org.apache.hadoop.hive.ql.hooks.ExecuteWithHookContext;
import org.apache.hadoop.hive.ql.hooks.Hook;
import org.apache.hadoop.hive.ql.hooks.HookContext;
import org.apache.hadoop.hive.ql.hooks.PostExecute;
import org.apache.hadoop.hive.ql.hooks.PreExecute;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.lockmgr.HiveLock;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockManager;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockManagerCtx;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockMode;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockObj;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockObject;
import org.apache.hadoop.hive.ql.lockmgr.LockException;
import org.apache.hadoop.hive.ql.metadata.AuthorizationException;
import org.apache.hadoop.hive.ql.metadata.DummyPartition;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.ppr.PartitionPruner;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.AbstractSemanticAnalyzerHook;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ErrorMsg;
import org.apache.hadoop.hive.ql.parse.HiveSemanticAnalyzerHookContextImpl;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.ParseDriver;
import org.apache.hadoop.hive.ql.parse.ParseException;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.VariableSubstitution;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.api.Query;
import org.apache.hadoop.hive.ql.processors.CommandProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.util.ReflectionUtils;

public class Driver
implements CommandProcessor {
    private static final Log LOG = LogFactory.getLog((String)Driver.class.getName());
    private static final SessionState.LogHelper console = new SessionState.LogHelper(LOG);
    private int maxRows = 100;
    ByteStream.Output bos = new ByteStream.Output();
    private HiveConf conf;
    private DataInput resStream;
    private Context ctx;
    private QueryPlan plan;
    private Schema schema;
    private HiveLockManager hiveLockMgr;
    private String errorMessage;
    private String SQLState;
    private int maxthreads;
    private final int sleeptime = 2000;

    private int checkLockManager() {
        boolean supportConcurrency = this.conf.getBoolVar(HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY);
        if (supportConcurrency && this.hiveLockMgr == null) {
            try {
                this.setLockManager();
            }
            catch (SemanticException e) {
                this.errorMessage = "FAILED: Error in semantic analysis: " + e.getMessage();
                this.SQLState = ErrorMsg.findSQLState(e.getMessage());
                console.printError(this.errorMessage, "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                return 12;
            }
        }
        return 0;
    }

    private void setLockManager() throws SemanticException {
        boolean supportConcurrency = this.conf.getBoolVar(HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY);
        if (supportConcurrency) {
            String lockMgr = this.conf.getVar(HiveConf.ConfVars.HIVE_LOCK_MANAGER);
            if (lockMgr == null || lockMgr.isEmpty()) {
                throw new SemanticException(ErrorMsg.LOCKMGR_NOT_SPECIFIED.getMsg());
            }
            try {
                this.hiveLockMgr = (HiveLockManager)ReflectionUtils.newInstance((Class)this.conf.getClassByName(lockMgr), (Configuration)this.conf);
                this.hiveLockMgr.setContext(new HiveLockManagerCtx(this.conf));
            }
            catch (Exception e) {
                throw new SemanticException(ErrorMsg.LOCKMGR_NOT_INITIALIZED.getMsg() + e.getMessage());
            }
        }
    }

    @Override
    public void init() {
        Operator.resetId();
    }

    public ClusterStatus getClusterStatus() throws Exception {
        ClusterStatus cs;
        try {
            JobConf job = new JobConf((Configuration)this.conf, ExecDriver.class);
            JobClient jc = new JobClient(job);
            cs = jc.getClusterStatus();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        LOG.info((Object)("Returning cluster status: " + cs.toString()));
        return cs;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public static Schema getSchema(BaseSemanticAnalyzer sem, HiveConf conf) {
        Schema schema = null;
        if (sem != null) {
            if (sem.getResultSchema() != null) {
                List<FieldSchema> lst = sem.getResultSchema();
                schema = new Schema(lst, null);
            } else if (sem.getFetchTask() != null) {
                FetchTask ft = sem.getFetchTask();
                TableDesc td = ft.getTblDesc();
                if (td == null && ft.getWork() != null && ((FetchWork)ft.getWork()).getPartDesc() != null && ((FetchWork)ft.getWork()).getPartDesc().size() > 0) {
                    td = ((FetchWork)ft.getWork()).getPartDesc().get(0).getTableDesc();
                }
                if (td == null) {
                    LOG.info((Object)"No returning schema.");
                } else {
                    String tableName = "result";
                    List lst = null;
                    try {
                        lst = MetaStoreUtils.getFieldsFromDeserializer((String)tableName, (Deserializer)td.getDeserializer());
                    }
                    catch (Exception e) {
                        LOG.warn((Object)("Error getting schema: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
                    }
                    if (lst != null) {
                        schema = new Schema(lst, null);
                    }
                }
            }
        }
        if (schema == null) {
            schema = new Schema();
        }
        LOG.info((Object)("Returning Hive schema: " + schema));
        return schema;
    }

    public Schema getThriftSchema() throws Exception {
        Schema schema;
        try {
            List lst;
            schema = this.getSchema();
            if (schema != null && (lst = schema.getFieldSchemas()) != null) {
                for (FieldSchema f : lst) {
                    f.setType(MetaStoreUtils.typeToThriftType((String)f.getType()));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        LOG.info((Object)("Returning Thrift schema: " + schema));
        return schema;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    public boolean hasReduceTasks(List<Task<? extends Serializable>> tasks) {
        if (tasks == null) {
            return false;
        }
        boolean hasReduce = false;
        for (Task<? extends Serializable> task : tasks) {
            if (task.hasReduce()) {
                return true;
            }
            hasReduce = hasReduce || this.hasReduceTasks(task.getChildTasks());
        }
        return hasReduce;
    }

    public Driver(HiveConf conf) {
        this.conf = conf;
    }

    public Driver() {
        if (SessionState.get() != null) {
            this.conf = SessionState.get().getConf();
        }
    }

    public int compile(String command) {
        if (this.plan != null) {
            this.close();
            this.plan = null;
        }
        TaskFactory.resetId();
        try {
            command = new VariableSubstitution().substitute(this.conf, command);
            this.ctx = new Context(this.conf);
            ParseDriver pd = new ParseDriver();
            ASTNode tree = pd.parse(command, this.ctx);
            tree = ParseUtils.findRootNonNullToken(tree);
            BaseSemanticAnalyzer sem = SemanticAnalyzerFactory.get(this.conf, tree);
            List<AbstractSemanticAnalyzerHook> saHooks = this.getSemanticAnalyzerHooks();
            if (saHooks != null) {
                HiveSemanticAnalyzerHookContextImpl hookCtx = new HiveSemanticAnalyzerHookContextImpl();
                hookCtx.setConf(this.conf);
                for (AbstractSemanticAnalyzerHook hook : saHooks) {
                    tree = hook.preAnalyze(hookCtx, tree);
                }
                sem.analyze(tree, this.ctx);
                for (AbstractSemanticAnalyzerHook hook : saHooks) {
                    hook.postAnalyze(hookCtx, sem.getRootTasks());
                }
            } else {
                sem.analyze(tree, this.ctx);
            }
            LOG.info((Object)"Semantic Analysis Completed");
            sem.validate();
            this.plan = new QueryPlan(command, sem);
            if (this.plan.getFetchTask() != null) {
                this.plan.getFetchTask().initialize(this.conf, this.plan, null);
            }
            this.schema = Driver.getSchema(sem, this.conf);
            if ("true".equalsIgnoreCase(System.getProperty("test.serialize.qplan"))) {
                String queryPlanFileName = this.ctx.getLocalScratchDir(true) + '/' + "queryplan.xml";
                LOG.info((Object)("query plan = " + queryPlanFileName));
                queryPlanFileName = new Path(queryPlanFileName).toUri().getPath();
                FileOutputStream fos = new FileOutputStream(queryPlanFileName);
                Utilities.serializeQueryPlan(this.plan, fos);
                fos.close();
                FileInputStream fis = new FileInputStream(queryPlanFileName);
                QueryPlan newPlan = Utilities.deserializeQueryPlan(fis, this.conf);
                fis.close();
                this.plan = newPlan;
            }
            if (this.plan.getFetchTask() != null) {
                this.plan.getFetchTask().initialize(this.conf, this.plan, null);
            }
            if (HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_AUTHORIZATION_ENABLED)) {
                try {
                    this.doAuthorization(sem);
                }
                catch (AuthorizationException authExp) {
                    console.printError("Authorization failed:" + authExp.getMessage() + ". Use show grant to get more details.");
                    return 403;
                }
            }
            return 0;
        }
        catch (SemanticException e) {
            this.errorMessage = "FAILED: Error in semantic analysis: " + e.getMessage();
            this.SQLState = ErrorMsg.findSQLState(e.getMessage());
            console.printError(this.errorMessage, "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            return 10;
        }
        catch (ParseException e) {
            this.errorMessage = "FAILED: Parse Error: " + e.getMessage();
            this.SQLState = ErrorMsg.findSQLState(e.getMessage());
            console.printError(this.errorMessage, "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            return 11;
        }
        catch (Exception e) {
            this.errorMessage = "FAILED: Hive Internal Error: " + Utilities.getNameMessage(e);
            this.SQLState = ErrorMsg.findSQLState(e.getMessage());
            console.printError(this.errorMessage + "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            return 12;
        }
    }

    private void doAuthorization(BaseSemanticAnalyzer sem) throws HiveException, AuthorizationException {
        HashSet<ReadEntity> inputs = sem.getInputs();
        HashSet<WriteEntity> outputs = sem.getOutputs();
        SessionState ss = SessionState.get();
        HiveOperation op = ss.getHiveOperation();
        Hive db = sem.getDb();
        if (op != null) {
            if (op.equals((Object)HiveOperation.CREATETABLE_AS_SELECT) || op.equals((Object)HiveOperation.CREATETABLE)) {
                ss.getAuthorizer().authorize(db.getDatabase(db.getCurrentDatabase()), null, HiveOperation.CREATETABLE_AS_SELECT.getOutputRequiredPrivileges());
            }
            if (outputs != null && outputs.size() > 0) {
                for (WriteEntity write : outputs) {
                    Partition part;
                    if (write.getType() == WriteEntity.Type.PARTITION && (part = db.getPartition(write.getTable(), write.getPartition().getSpec(), false)) != null) {
                        ss.getAuthorizer().authorize(write.getPartition(), null, op.getOutputRequiredPrivileges());
                        continue;
                    }
                    if (write.getTable() == null) continue;
                    ss.getAuthorizer().authorize(write.getTable(), null, op.getOutputRequiredPrivileges());
                }
            }
        }
        if (inputs != null && inputs.size() > 0) {
            HashMap tab2Cols = new HashMap();
            HashMap part2Cols = new HashMap();
            for (ReadEntity read : inputs) {
                boolean part;
                boolean bl = part = read.getPartition() != null;
                if (part) {
                    part2Cols.put(read.getPartition(), new ArrayList());
                    continue;
                }
                tab2Cols.put(read.getTable(), new ArrayList());
            }
            if (op.equals((Object)HiveOperation.CREATETABLE_AS_SELECT) || op.equals((Object)HiveOperation.QUERY)) {
                SemanticAnalyzer querySem = (SemanticAnalyzer)sem;
                ParseContext parseCtx = querySem.getParseContext();
                HashMap<TableScanOperator, Table> tsoTopMap = parseCtx.getTopToTable();
                for (Map.Entry<String, Operator<? extends Serializable>> topOpMap : querySem.getParseContext().getTopOps().entrySet()) {
                    int i;
                    Operator<? extends Serializable> topOp = topOpMap.getValue();
                    if (!(topOp instanceof TableScanOperator) || !tsoTopMap.containsKey(topOp)) continue;
                    TableScanOperator tableScanOp = (TableScanOperator)topOp;
                    Table tbl = (Table)tsoTopMap.get(tableScanOp);
                    ArrayList<Integer> neededColumnIds = tableScanOp.getNeededColumnIDs();
                    List<FieldSchema> columns = tbl.getCols();
                    ArrayList<String> cols = new ArrayList<String>();
                    if (neededColumnIds != null && neededColumnIds.size() > 0) {
                        for (i = 0; i < neededColumnIds.size(); ++i) {
                            cols.add(columns.get((Integer)neededColumnIds.get(i)).getName());
                        }
                    } else {
                        for (i = 0; i < columns.size(); ++i) {
                            cols.add(columns.get(i).getName());
                        }
                    }
                    if (tbl.isPartitioned()) {
                        String alias_id = topOpMap.getKey();
                        PrunedPartitionList partsList = PartitionPruner.prune(parseCtx.getTopToTable().get(topOp), parseCtx.getOpToPartPruner().get(topOp), parseCtx.getConf(), alias_id, parseCtx.getPrunedPartitions());
                        HashSet<Partition> parts = new HashSet<Partition>();
                        parts.addAll(partsList.getConfirmedPartns());
                        parts.addAll(partsList.getUnknownPartns());
                        for (Partition part : parts) {
                            part2Cols.put(part, cols);
                        }
                        continue;
                    }
                    tab2Cols.put(tbl, cols);
                }
            }
            for (ReadEntity read : inputs) {
                List cols;
                if (read.getPartition() != null) {
                    cols = (List)part2Cols.get(read.getPartition());
                    if (cols != null && cols.size() > 0) {
                        ss.getAuthorizer().authorize(read.getPartition().getTable(), read.getPartition(), cols, op.getInputRequiredPrivileges(), null);
                        continue;
                    }
                    ss.getAuthorizer().authorize(read.getPartition(), op.getInputRequiredPrivileges(), null);
                    continue;
                }
                if (read.getTable() == null) continue;
                cols = (List)tab2Cols.get(read.getTable());
                if (cols != null && cols.size() > 0) {
                    ss.getAuthorizer().authorize(read.getTable(), null, cols, op.getInputRequiredPrivileges(), null);
                    continue;
                }
                ss.getAuthorizer().authorize(read.getTable(), op.getInputRequiredPrivileges(), null);
            }
        }
    }

    public QueryPlan getPlan() {
        return this.plan;
    }

    private List<HiveLockObj> getLockObjects(Table t, Partition p, HiveLockMode mode) throws SemanticException {
        LinkedList<HiveLockObj> locks = new LinkedList<HiveLockObj>();
        HiveLockObject.HiveLockObjectData lockData = new HiveLockObject.HiveLockObjectData(this.plan.getQueryId(), String.valueOf(System.currentTimeMillis()), "IMPLICIT");
        if (t != null) {
            locks.add(new HiveLockObj(new HiveLockObject(t, lockData), mode));
            return locks;
        }
        if (p != null) {
            if (!(p instanceof DummyPartition)) {
                locks.add(new HiveLockObj(new HiveLockObject(p, lockData), mode));
            }
            mode = HiveLockMode.SHARED;
            String name = p.getName();
            if (p instanceof DummyPartition) {
                name = p.getName().split("@")[2];
            }
            String partName = name;
            String partialName = "";
            String[] partns = name.split("/");
            int len = p instanceof DummyPartition ? partns.length : partns.length - 1;
            for (int idx = 0; idx < len; ++idx) {
                String partn = partns[idx];
                partialName = partialName + partn;
                try {
                    locks.add(new HiveLockObj(new HiveLockObject(new DummyPartition(p.getTable(), p.getTable().getDbName() + "/" + p.getTable().getTableName() + "/" + partialName), lockData), mode));
                    partialName = partialName + "/";
                    continue;
                }
                catch (HiveException e) {
                    throw new SemanticException(e.getMessage());
                }
            }
            locks.add(new HiveLockObj(new HiveLockObject(p.getTable(), lockData), mode));
        }
        return locks;
    }

    public int acquireReadWriteLocks() {
        try {
            boolean tryNum = true;
            int sleepTime = this.conf.getIntVar(HiveConf.ConfVars.HIVE_LOCK_SLEEP_BETWEEN_RETRIES) * 1000;
            int numRetries = this.conf.getIntVar(HiveConf.ConfVars.HIVE_LOCK_NUMRETRIES);
            boolean supportConcurrency = this.conf.getBoolVar(HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY);
            if (!supportConcurrency) {
                return 0;
            }
            ArrayList<HiveLockObj> lockObjects = new ArrayList<HiveLockObj>();
            for (ReadEntity input : this.plan.getInputs()) {
                if (input.getType() == ReadEntity.Type.TABLE) {
                    lockObjects.addAll(this.getLockObjects(input.getTable(), null, HiveLockMode.SHARED));
                    continue;
                }
                lockObjects.addAll(this.getLockObjects(null, input.getPartition(), HiveLockMode.SHARED));
            }
            for (WriteEntity output : this.plan.getOutputs()) {
                if (output.getTyp() == WriteEntity.Type.TABLE) {
                    lockObjects.addAll(this.getLockObjects(output.getTable(), null, output.isComplete() ? HiveLockMode.EXCLUSIVE : HiveLockMode.SHARED));
                    continue;
                }
                if (output.getTyp() == WriteEntity.Type.PARTITION) {
                    lockObjects.addAll(this.getLockObjects(null, output.getPartition(), HiveLockMode.EXCLUSIVE));
                    continue;
                }
                if (output.getTyp() != WriteEntity.Type.DUMMYPARTITION) continue;
                lockObjects.addAll(this.getLockObjects(null, output.getPartition(), HiveLockMode.SHARED));
            }
            if (lockObjects.isEmpty() && !this.ctx.isNeedLockMgr()) {
                return 0;
            }
            int ret = this.checkLockManager();
            if (ret != 0) {
                return ret;
            }
            HiveLockObject.HiveLockObjectData lockData = new HiveLockObject.HiveLockObjectData(this.plan.getQueryId(), String.valueOf(System.currentTimeMillis()), "IMPLICIT");
            try {
                Hive db = Hive.get(this.conf);
                lockObjects.add(new HiveLockObj(new HiveLockObject(db.getCurrentDatabase(), lockData), HiveLockMode.SHARED));
            }
            catch (HiveException e) {
                throw new SemanticException(e.getMessage());
            }
            this.ctx.setHiveLockMgr(this.hiveLockMgr);
            List<HiveLock> hiveLocks = this.ctx.getHiveLockMgr().lock(lockObjects, false, numRetries, sleepTime);
            if (hiveLocks == null) {
                throw new SemanticException(ErrorMsg.LOCK_CANNOT_BE_ACQUIRED.getMsg());
            }
            this.ctx.setHiveLocks(hiveLocks);
            return 0;
        }
        catch (SemanticException e) {
            this.errorMessage = "FAILED: Error in acquiring locks: " + e.getMessage();
            this.SQLState = ErrorMsg.findSQLState(e.getMessage());
            console.printError(this.errorMessage, "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            return 10;
        }
        catch (LockException e) {
            this.errorMessage = "FAILED: Error in acquiring locks: " + e.getMessage();
            this.SQLState = ErrorMsg.findSQLState(e.getMessage());
            console.printError(this.errorMessage, "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            return 10;
        }
    }

    private void releaseLocks() {
        if (this.ctx != null && this.ctx.getHiveLockMgr() != null) {
            try {
                this.ctx.getHiveLockMgr().close();
                this.ctx.setHiveLocks(null);
            }
            catch (LockException lockException) {
                // empty catch block
            }
        }
    }

    private void releaseLocks(List<HiveLock> hiveLocks) {
        if (hiveLocks != null) {
            this.ctx.getHiveLockMgr().releaseLocks(hiveLocks);
        }
        this.ctx.setHiveLocks(null);
    }

    @Override
    public CommandProcessorResponse run(String command) {
        this.errorMessage = null;
        this.SQLState = null;
        int ret = this.compile(command);
        if (ret != 0) {
            this.releaseLocks(this.ctx.getHiveLocks());
            return new CommandProcessorResponse(ret, this.errorMessage, this.SQLState);
        }
        ret = this.acquireReadWriteLocks();
        if (ret != 0) {
            this.releaseLocks(this.ctx.getHiveLocks());
            return new CommandProcessorResponse(ret, this.errorMessage, this.SQLState);
        }
        ret = this.execute();
        if (ret != 0) {
            this.releaseLocks(this.ctx.getHiveLocks());
            return new CommandProcessorResponse(ret, this.errorMessage, this.SQLState);
        }
        this.releaseLocks(this.ctx.getHiveLocks());
        return new CommandProcessorResponse(ret);
    }

    private List<AbstractSemanticAnalyzerHook> getSemanticAnalyzerHooks() throws Exception {
        String[] peClasses;
        ArrayList<AbstractSemanticAnalyzerHook> saHooks = new ArrayList<AbstractSemanticAnalyzerHook>();
        String pestr = this.conf.getVar(HiveConf.ConfVars.SEMANTIC_ANALYZER_HOOK);
        if (pestr == null) {
            return saHooks;
        }
        if ((pestr = pestr.trim()).equals("")) {
            return saHooks;
        }
        for (String peClass : peClasses = pestr.split(",")) {
            try {
                AbstractSemanticAnalyzerHook hook = HiveUtils.getSemanticAnalyzerHook(this.conf, peClass);
                saHooks.add(hook);
            }
            catch (HiveException e) {
                console.printError("Pre Exec Hook Class not found:" + e.getMessage());
                throw e;
            }
        }
        return saHooks;
    }

    private List<Hook> getPreExecHooks() throws Exception {
        String[] peClasses;
        ArrayList<Hook> pehooks = new ArrayList<Hook>();
        String pestr = this.conf.getVar(HiveConf.ConfVars.PREEXECHOOKS);
        if ((pestr = pestr.trim()).equals("")) {
            return pehooks;
        }
        for (String peClass : peClasses = pestr.split(",")) {
            try {
                pehooks.add((Hook)Class.forName(peClass.trim(), true, JavaUtils.getClassLoader()).newInstance());
            }
            catch (ClassNotFoundException e) {
                console.printError("Pre Exec Hook Class not found:" + e.getMessage());
                throw e;
            }
        }
        return pehooks;
    }

    private List<Hook> getPostExecHooks() throws Exception {
        String[] peClasses;
        ArrayList<Hook> pehooks = new ArrayList<Hook>();
        String pestr = this.conf.getVar(HiveConf.ConfVars.POSTEXECHOOKS);
        if ((pestr = pestr.trim()).equals("")) {
            return pehooks;
        }
        for (String peClass : peClasses = pestr.split(",")) {
            try {
                pehooks.add((Hook)Class.forName(peClass.trim(), true, JavaUtils.getClassLoader()).newInstance());
            }
            catch (ClassNotFoundException e) {
                console.printError("Post Exec Hook Class not found:" + e.getMessage());
                throw e;
            }
        }
        return pehooks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute() {
        boolean noName = StringUtils.isEmpty(this.conf.getVar(HiveConf.ConfVars.HADOOPJOBNAME));
        int maxlen = this.conf.getIntVar(HiveConf.ConfVars.HIVEJOBNAMELENGTH);
        String queryId = this.plan.getQueryId();
        String queryStr = this.plan.getQueryStr();
        this.conf.setVar(HiveConf.ConfVars.HIVEQUERYID, queryId);
        this.conf.setVar(HiveConf.ConfVars.HIVEQUERYSTRING, queryStr);
        this.maxthreads = HiveConf.getIntVar(this.conf, HiveConf.ConfVars.EXECPARALLETHREADNUMBER);
        try {
            LOG.info((Object)("Starting command: " + queryStr));
            this.plan.setStarted();
            if (SessionState.get() != null) {
                SessionState.get().getHiveHistory().startQuery(queryStr, this.conf.getVar(HiveConf.ConfVars.HIVEQUERYID));
                SessionState.get().getHiveHistory().logPlanProgress(this.plan);
            }
            this.resStream = null;
            HookContext hookContext = new HookContext(this.plan, this.conf);
            for (Hook peh : this.getPreExecHooks()) {
                if (peh instanceof ExecuteWithHookContext) {
                    ((ExecuteWithHookContext)peh).run(hookContext);
                    continue;
                }
                if (!(peh instanceof PreExecute)) continue;
                ((PreExecute)peh).run(SessionState.get(), this.plan.getInputs(), this.plan.getOutputs(), ShimLoader.getHadoopShims().getUGIForConf(this.conf));
            }
            int jobs = Utilities.getMRTasks(this.plan.getRootTasks()).size();
            if (jobs > 0) {
                console.printInfo("Total MapReduce jobs = " + jobs);
            }
            if (SessionState.get() != null) {
                SessionState.get().getHiveHistory().setQueryProperty(queryId, HiveHistory.Keys.QUERY_NUM_TASKS, String.valueOf(jobs));
                SessionState.get().getHiveHistory().setIdToTableMap(this.plan.getIdToTableNameMap());
            }
            String jobname = Utilities.abbreviate(queryStr, maxlen - 6);
            LinkedList<Task<? extends Serializable>> runnable = new LinkedList<Task<? extends Serializable>>();
            HashMap<TaskResult, TaskRunner> running = new HashMap<TaskResult, TaskRunner>();
            DriverContext driverCxt = new DriverContext(runnable, this.ctx);
            for (Task<? extends Serializable> tsk : this.plan.getRootTasks()) {
                driverCxt.addToRunnable(tsk);
            }
            while (running.size() != 0 || runnable.peek() != null) {
                while (runnable.peek() != null && running.size() < this.maxthreads) {
                    Task tsk = (Task)runnable.remove();
                    this.launchTask(tsk, queryId, noName, running, jobname, jobs, driverCxt);
                }
                TaskResult tskRes = this.pollTasks(running.keySet());
                TaskRunner tskRun = (TaskRunner)running.remove(tskRes);
                Task<? extends Serializable> tsk = tskRun.getTask();
                hookContext.addCompleteTask(tskRun);
                int exitVal = tskRes.getExitVal();
                if (exitVal != 0) {
                    Task<Serializable> backupTask = tsk.getAndInitBackupTask();
                    if (backupTask != null) {
                        this.errorMessage = "FAILED: Execution Error, return code " + exitVal + " from " + tsk.getClass().getName();
                        console.printError(this.errorMessage);
                        this.errorMessage = "ATTEMPT: Execute BackupTask: " + backupTask.getClass().getName();
                        console.printError(this.errorMessage);
                        if (!DriverContext.isLaunchable(backupTask)) continue;
                        driverCxt.addToRunnable(backupTask);
                        continue;
                    }
                    this.errorMessage = "FAILED: Execution Error, return code " + exitVal + " from " + tsk.getClass().getName();
                    this.SQLState = "08S01";
                    console.printError(this.errorMessage);
                    if (running.size() != 0) {
                        this.taskCleanup();
                    }
                    int n = 9;
                    return n;
                }
                if (SessionState.get() != null) {
                    SessionState.get().getHiveHistory().setTaskProperty(queryId, tsk.getId(), HiveHistory.Keys.TASK_RET_CODE, String.valueOf(exitVal));
                    SessionState.get().getHiveHistory().endTask(queryId, tsk);
                }
                if (tsk.getChildTasks() == null) continue;
                for (Task<Serializable> child : tsk.getChildTasks()) {
                    if (!DriverContext.isLaunchable(child)) continue;
                    driverCxt.addToRunnable(child);
                }
            }
            this.ctx.restoreOriginalTracker();
            HashSet<WriteEntity> remOutputs = new HashSet<WriteEntity>();
            for (WriteEntity output : this.plan.getOutputs()) {
                if (output.isComplete()) continue;
                remOutputs.add(output);
            }
            for (WriteEntity output : remOutputs) {
                this.plan.getOutputs().remove(output);
            }
            for (Hook peh : this.getPostExecHooks()) {
                if (peh instanceof ExecuteWithHookContext) {
                    ((ExecuteWithHookContext)peh).run(hookContext);
                    continue;
                }
                if (!(peh instanceof PostExecute)) continue;
                ((PostExecute)peh).run(SessionState.get(), this.plan.getInputs(), this.plan.getOutputs(), SessionState.get() != null ? SessionState.get().getLineageState().getLineageInfo() : null, ShimLoader.getHadoopShims().getUGIForConf(this.conf));
            }
            if (SessionState.get() != null) {
                SessionState.get().getHiveHistory().setQueryProperty(queryId, HiveHistory.Keys.QUERY_RET_CODE, String.valueOf(0));
                SessionState.get().getHiveHistory().printRowCount(queryId);
            }
        }
        catch (Exception e) {
            if (SessionState.get() != null) {
                SessionState.get().getHiveHistory().setQueryProperty(queryId, HiveHistory.Keys.QUERY_RET_CODE, String.valueOf(12));
            }
            this.errorMessage = "FAILED: Hive Internal Error: " + Utilities.getNameMessage(e);
            this.SQLState = "08S01";
            console.printError(this.errorMessage + "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            int n = 12;
            return n;
        }
        finally {
            if (SessionState.get() != null) {
                SessionState.get().getHiveHistory().endQuery(queryId);
            }
            if (noName) {
                this.conf.setVar(HiveConf.ConfVars.HADOOPJOBNAME, "");
            }
        }
        this.plan.setDone();
        if (SessionState.get() != null) {
            try {
                SessionState.get().getHiveHistory().logPlanProgress(this.plan);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        console.printInfo("OK");
        return 0;
    }

    public void launchTask(Task<? extends Serializable> tsk, String queryId, boolean noName, Map<TaskResult, TaskRunner> running, String jobname, int jobs, DriverContext cxt) {
        if (SessionState.get() != null) {
            SessionState.get().getHiveHistory().startTask(queryId, tsk, tsk.getClass().getName());
        }
        if (tsk.isMapRedTask() && !(tsk instanceof ConditionalTask)) {
            if (noName) {
                this.conf.setVar(HiveConf.ConfVars.HADOOPJOBNAME, jobname + "(" + tsk.getId() + ")");
            }
            cxt.incCurJobNo(1);
            console.printInfo("Launching Job " + cxt.getCurJobNo() + " out of " + jobs);
        }
        tsk.initialize(this.conf, this.plan, cxt);
        TaskResult tskRes = new TaskResult();
        TaskRunner tskRun = new TaskRunner(tsk, tskRes);
        if (HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.EXECPARALLEL) && tsk.isMapRedTask()) {
            tskRun.start();
        } else {
            tskRun.runSequential();
        }
        running.put(tskRes, tskRun);
    }

    public void taskCleanup() {
        System.exit(9);
    }

    public TaskResult pollTasks(Set<TaskResult> results) {
        Iterator<TaskResult> resultIterator = results.iterator();
        while (true) {
            if (resultIterator.hasNext()) {
                TaskResult tskRes = resultIterator.next();
                if (tskRes.isRunning()) continue;
                return tskRes;
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            resultIterator = results.iterator();
        }
    }

    public boolean getResults(ArrayList<String> res) throws IOException {
        if (this.plan != null && this.plan.getFetchTask() != null) {
            FetchTask ft = this.plan.getFetchTask();
            ft.setMaxRows(this.maxRows);
            return ft.fetch(res);
        }
        if (this.resStream == null) {
            this.resStream = this.ctx.getStream();
        }
        if (this.resStream == null) {
            return false;
        }
        int numRows = 0;
        String row = null;
        while (numRows < this.maxRows) {
            Utilities.StreamStatus ss;
            if (this.resStream == null) {
                return numRows > 0;
            }
            this.bos.reset();
            try {
                ss = Utilities.readColumn(this.resStream, this.bos);
                if (this.bos.getCount() > 0) {
                    row = new String(this.bos.getData(), 0, this.bos.getCount(), "UTF-8");
                } else if (ss == Utilities.StreamStatus.TERMINATED) {
                    row = new String();
                }
                if (row != null) {
                    ++numRows;
                    res.add(row);
                }
            }
            catch (IOException e) {
                console.printError("FAILED: Unexpected IO exception : " + e.getMessage());
                res = null;
                return false;
            }
            if (ss != Utilities.StreamStatus.EOF) continue;
            this.resStream = this.ctx.getStream();
        }
        return true;
    }

    public int close() {
        try {
            FetchTask fetchTask;
            if (this.plan != null && null != (fetchTask = this.plan.getFetchTask())) {
                try {
                    fetchTask.clearFetch();
                }
                catch (Exception e) {
                    LOG.debug((Object)" Exception while clearing the Fetch task ", (Throwable)e);
                }
            }
            if (this.ctx != null) {
                this.ctx.clear();
            }
            if (null != this.resStream) {
                try {
                    ((FSDataInputStream)this.resStream).close();
                }
                catch (Exception e) {
                    LOG.debug((Object)" Exception while closing the resStream ", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            console.printError("FAILED: Hive Internal Error: " + Utilities.getNameMessage(e) + "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            return 13;
        }
        return 0;
    }

    public void destroy() {
        this.releaseLocks();
    }

    public Query getQueryPlan() throws IOException {
        return this.plan.getQueryPlan();
    }
}

