/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.net.NetUtils;

public final class JobTrackerURLResolver {
    public static String getURL(JobConf conf) throws IOException {
        String infoAddr = conf.get("mapred.job.tracker.http.address");
        if (infoAddr == null) {
            throw new IOException("Unable to find job tracker info port.");
        }
        InetSocketAddress infoSocAddr = NetUtils.createSocketAddr((String)infoAddr);
        int infoPort = infoSocAddr.getPort();
        String tracker = "http://" + JobTracker.getAddress((Configuration)conf).getHostName() + ":" + infoPort;
        return tracker;
    }

    private JobTrackerURLResolver() {
    }
}

