/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.Tree;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.ql.exec.FetchTask;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.index.HiveIndex;
import org.apache.hadoop.hive.ql.index.HiveIndexHandler;
import org.apache.hadoop.hive.ql.io.IgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ErrorMsg;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.AddPartitionDesc;
import org.apache.hadoop.hive.ql.plan.AlterDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.AlterIndexDesc;
import org.apache.hadoop.hive.ql.plan.AlterTableDesc;
import org.apache.hadoop.hive.ql.plan.AlterTableSimpleDesc;
import org.apache.hadoop.hive.ql.plan.CreateDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.CreateIndexDesc;
import org.apache.hadoop.hive.ql.plan.DDLWork;
import org.apache.hadoop.hive.ql.plan.DescDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.DescFunctionDesc;
import org.apache.hadoop.hive.ql.plan.DescTableDesc;
import org.apache.hadoop.hive.ql.plan.DropDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.DropIndexDesc;
import org.apache.hadoop.hive.ql.plan.DropTableDesc;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.GrantDesc;
import org.apache.hadoop.hive.ql.plan.GrantRevokeRoleDDL;
import org.apache.hadoop.hive.ql.plan.LockTableDesc;
import org.apache.hadoop.hive.ql.plan.MsckDesc;
import org.apache.hadoop.hive.ql.plan.PrincipalDesc;
import org.apache.hadoop.hive.ql.plan.PrivilegeDesc;
import org.apache.hadoop.hive.ql.plan.PrivilegeObjectDesc;
import org.apache.hadoop.hive.ql.plan.RevokeDesc;
import org.apache.hadoop.hive.ql.plan.RoleDDLDesc;
import org.apache.hadoop.hive.ql.plan.ShowDatabasesDesc;
import org.apache.hadoop.hive.ql.plan.ShowFunctionsDesc;
import org.apache.hadoop.hive.ql.plan.ShowGrantDesc;
import org.apache.hadoop.hive.ql.plan.ShowIndexesDesc;
import org.apache.hadoop.hive.ql.plan.ShowLocksDesc;
import org.apache.hadoop.hive.ql.plan.ShowPartitionsDesc;
import org.apache.hadoop.hive.ql.plan.ShowTableStatusDesc;
import org.apache.hadoop.hive.ql.plan.ShowTablesDesc;
import org.apache.hadoop.hive.ql.plan.SwitchDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.UnlockTableDesc;
import org.apache.hadoop.hive.ql.security.authorization.Privilege;
import org.apache.hadoop.hive.ql.security.authorization.PrivilegeRegistry;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.mapred.TextInputFormat;

public class DDLSemanticAnalyzer
extends BaseSemanticAnalyzer {
    private static final Log LOG = LogFactory.getLog((String)"hive.ql.parse.DDLSemanticAnalyzer");
    public static final Map<Integer, String> TokenToTypeName = new HashMap<Integer, String>();
    public static final Set<String> reservedPartitionValues = new HashSet<String>();

    public static String getTypeName(int token) throws SemanticException {
        if (token == 74 || token == 75 || token == 76) {
            throw new SemanticException(ErrorMsg.UNSUPPORTED_TYPE.getMsg());
        }
        return TokenToTypeName.get(token);
    }

    public DDLSemanticAnalyzer(HiveConf conf) throws SemanticException {
        super(conf);
        reservedPartitionValues.add(HiveConf.getVar(conf, HiveConf.ConfVars.DEFAULTPARTITIONNAME));
        reservedPartitionValues.add(HiveConf.getVar(conf, HiveConf.ConfVars.DEFAULT_ZOOKEEPER_PARTITION_NAME));
        reservedPartitionValues.add(HiveConf.getVar(conf, HiveConf.ConfVars.METASTORE_INT_ORIGINAL));
        reservedPartitionValues.add(HiveConf.getVar(conf, HiveConf.ConfVars.METASTORE_INT_ARCHIVED));
        reservedPartitionValues.add(HiveConf.getVar(conf, HiveConf.ConfVars.METASTORE_INT_EXTRACTED));
    }

    @Override
    public void analyzeInternal(ASTNode ast) throws SemanticException {
        switch (ast.getToken().getType()) {
            case 92: {
                TablePartition tblPart = new TablePartition((ASTNode)ast.getChild(0));
                String tableName = tblPart.tableName;
                HashMap<String, String> partSpec = tblPart.partSpec;
                ast = (ASTNode)ast.getChild(1);
                if (ast.getToken().getType() == 106) {
                    this.analyzeAlterTableFileFormat(ast, tableName, partSpec);
                    break;
                }
                if (ast.getToken().getType() == 99) {
                    this.analyzeAlterTableProtectMode(ast, tableName, partSpec);
                    break;
                }
                if (ast.getToken().getType() != 107) break;
                this.analyzeAlterTableLocation(ast, tableName, partSpec);
                break;
            }
            case 123: {
                this.analyzeDropTable(ast, false);
                break;
            }
            case 85: {
                this.analyzeCreateIndex(ast);
                break;
            }
            case 88: {
                this.analyzeDropIndex(ast);
                break;
            }
            case 90: {
                this.ctx.setResFile(new Path(this.ctx.getLocalTmpFileURI()));
                this.analyzeDescribeTable(ast);
                break;
            }
            case 113: {
                this.ctx.setResFile(new Path(this.ctx.getLocalTmpFileURI()));
                this.analyzeShowDatabases(ast);
                break;
            }
            case 114: {
                this.ctx.setResFile(new Path(this.ctx.getLocalTmpFileURI()));
                this.analyzeShowTables(ast);
                break;
            }
            case 117: {
                this.ctx.setResFile(new Path(this.ctx.getLocalTmpFileURI()));
                this.analyzeShowTableStatus(ast);
                break;
            }
            case 115: {
                this.ctx.setResFile(new Path(this.ctx.getLocalTmpFileURI()));
                this.analyzeShowFunctions(ast);
                break;
            }
            case 118: {
                this.ctx.setResFile(new Path(this.ctx.getLocalTmpFileURI()));
                this.analyzeShowLocks(ast);
                break;
            }
            case 91: {
                this.ctx.setResFile(new Path(this.ctx.getLocalTmpFileURI()));
                this.analyzeDescFunction(ast);
                break;
            }
            case 213: {
                this.ctx.setResFile(new Path(this.ctx.getLocalTmpFileURI()));
                this.analyzeDescDatabase(ast);
                break;
            }
            case 112: {
                this.ctx.setResFile(new Path(this.ctx.getLocalTmpFileURI()));
                this.analyzeMetastoreCheck(ast);
                break;
            }
            case 158: {
                this.analyzeDropTable(ast, true);
                break;
            }
            case 159: {
                this.analyzeAlterTableProps(ast, true);
                break;
            }
            case 93: {
                this.analyzeAlterTableRename(ast);
                break;
            }
            case 100: {
                this.analyzeAlterTableTouch(ast);
                break;
            }
            case 101: {
                this.analyzeAlterTableArchive(ast, false);
                break;
            }
            case 102: {
                this.analyzeAlterTableArchive(ast, true);
                break;
            }
            case 94: {
                this.analyzeAlterTableModifyCols(ast, AlterTableDesc.AlterTableTypes.ADDCOLS);
                break;
            }
            case 96: {
                this.analyzeAlterTableModifyCols(ast, AlterTableDesc.AlterTableTypes.REPLACECOLS);
                break;
            }
            case 95: {
                this.analyzeAlterTableRenameCol(ast);
                break;
            }
            case 97: {
                this.analyzeAlterTableAddParts(ast);
                break;
            }
            case 98: {
                this.analyzeAlterTableDropParts(ast);
                break;
            }
            case 108: {
                this.analyzeAlterTableProps(ast, false);
                break;
            }
            case 103: {
                this.analyzeAlterTableSerdeProps(ast);
                break;
            }
            case 104: {
                this.analyzeAlterTableSerde(ast);
                break;
            }
            case 146: {
                this.analyzeAlterTableClusterSort(ast);
                break;
            }
            case 110: {
                this.analyzeAlterIndexRebuild(ast);
                break;
            }
            case 111: {
                this.analyzeAlterIndexProps(ast);
                break;
            }
            case 116: {
                this.ctx.setResFile(new Path(this.ctx.getLocalTmpFileURI()));
                this.analyzeShowPartitions(ast);
                break;
            }
            case 211: {
                this.ctx.setResFile(new Path(this.ctx.getLocalTmpFileURI()));
                this.analyzeShowIndexes(ast);
                break;
            }
            case 119: {
                this.analyzeLockTable(ast);
                break;
            }
            case 120: {
                this.analyzeUnlockTable(ast);
                break;
            }
            case 83: {
                this.analyzeCreateDatabase(ast);
                break;
            }
            case 122: {
                this.analyzeDropDatabase(ast);
                break;
            }
            case 121: {
                this.analyzeSwitchDatabase(ast);
                break;
            }
            case 216: {
                this.analyzeAlterDatabase(ast);
                break;
            }
            case 185: {
                this.analyzeCreateRole(ast);
                break;
            }
            case 186: {
                this.analyzeDropRole(ast);
                break;
            }
            case 210: {
                this.ctx.setResFile(new Path(this.ctx.getLocalTmpFileURI()));
                this.analyzeShowRoleGrant(ast);
                break;
            }
            case 208: {
                this.analyzeGrantRevokeRole(true, ast);
                break;
            }
            case 209: {
                this.analyzeGrantRevokeRole(false, ast);
                break;
            }
            case 187: {
                this.analyzeGrant(ast);
                break;
            }
            case 189: {
                this.ctx.setResFile(new Path(this.ctx.getLocalTmpFileURI()));
                this.analyzeShowGrant(ast);
                break;
            }
            case 188: {
                this.analyzeRevoke(ast);
                break;
            }
            default: {
                throw new SemanticException("Unsupported command.");
            }
        }
    }

    private void analyzeGrantRevokeRole(boolean grant, ASTNode ast) {
        List<PrincipalDesc> principalDesc = this.analyzePrincipalListDef((ASTNode)ast.getChild(0));
        ArrayList<String> roles = new ArrayList<String>();
        for (int i = 1; i < ast.getChildCount(); ++i) {
            roles.add(DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(i).getText()));
        }
        String roleOwnerName = "";
        if (SessionState.get() != null && SessionState.get().getAuthenticator() != null) {
            roleOwnerName = SessionState.get().getAuthenticator().getUserName();
        }
        GrantRevokeRoleDDL grantRevokeRoleDDL = new GrantRevokeRoleDDL(grant, roles, principalDesc, roleOwnerName, PrincipalType.USER, true);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), grantRevokeRoleDDL), this.conf, new Task[0]));
    }

    private void analyzeShowGrant(ASTNode ast) throws SemanticException {
        ASTNode child;
        PrivilegeObjectDesc privHiveObj = null;
        ASTNode principal = (ASTNode)ast.getChild(0);
        PrincipalType type = PrincipalType.USER;
        switch (principal.getType()) {
            case 193: {
                type = PrincipalType.USER;
                break;
            }
            case 194: {
                type = PrincipalType.GROUP;
                break;
            }
            case 195: {
                type = PrincipalType.ROLE;
            }
        }
        String principalName = DDLSemanticAnalyzer.unescapeIdentifier(principal.getChild(0).getText());
        PrincipalDesc principalDesc = new PrincipalDesc(principalName, type);
        List<String> cols = null;
        if (ast.getChildCount() > 1 && (child = (ASTNode)ast.getChild(1)).getToken().getType() == 207) {
            privHiveObj = new PrivilegeObjectDesc();
            privHiveObj.setObject(DDLSemanticAnalyzer.unescapeIdentifier(child.getChild(0).getText()));
            if (child.getChildCount() > 1) {
                for (int i = 1; i < child.getChildCount(); ++i) {
                    ASTNode grandChild = (ASTNode)child.getChild(i);
                    if (grandChild.getToken().getType() == 11) {
                        privHiveObj.setPartSpec(DDLSemanticAnalyzer.getPartSpec(grandChild));
                        continue;
                    }
                    if (grandChild.getToken().getType() == 147) {
                        cols = this.getColumnNames(grandChild);
                        continue;
                    }
                    privHiveObj.setTable(child.getChild(i) != null);
                }
            }
        }
        if (privHiveObj == null && cols != null) {
            throw new SemanticException("For user-level privileges, column sets should be null. columns=" + cols.toString());
        }
        ShowGrantDesc showGrant = new ShowGrantDesc(this.ctx.getResFile().toString(), principalDesc, privHiveObj, cols);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), showGrant), this.conf, new Task[0]));
    }

    private void analyzeGrant(ASTNode ast) throws SemanticException {
        List<PrivilegeDesc> privilegeDesc = this.analyzePrivilegeListDef((ASTNode)ast.getChild(0));
        List<PrincipalDesc> principalDesc = this.analyzePrincipalListDef((ASTNode)ast.getChild(1));
        boolean grantOption = false;
        PrivilegeObjectDesc privilegeObj = null;
        if (ast.getChildCount() > 2) {
            for (int i = 2; i < ast.getChildCount(); ++i) {
                ASTNode astChild = (ASTNode)ast.getChild(i);
                if (astChild.getType() == 196) {
                    grantOption = true;
                    continue;
                }
                if (astChild.getType() != 206) continue;
                privilegeObj = this.analyzePrivilegeObject(astChild);
            }
        }
        String userName = null;
        if (SessionState.get() != null && SessionState.get().getAuthenticator() != null) {
            userName = SessionState.get().getAuthenticator().getUserName();
        }
        GrantDesc grantDesc = new GrantDesc(privilegeObj, privilegeDesc, principalDesc, userName, PrincipalType.USER, grantOption);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), grantDesc), this.conf, new Task[0]));
    }

    private void analyzeRevoke(ASTNode ast) throws SemanticException {
        List<PrivilegeDesc> privilegeDesc = this.analyzePrivilegeListDef((ASTNode)ast.getChild(0));
        List<PrincipalDesc> principalDesc = this.analyzePrincipalListDef((ASTNode)ast.getChild(1));
        PrivilegeObjectDesc hiveObj = null;
        if (ast.getChildCount() > 2) {
            ASTNode astChild = (ASTNode)ast.getChild(2);
            hiveObj = this.analyzePrivilegeObject(astChild);
        }
        RevokeDesc revokeDesc = new RevokeDesc(privilegeDesc, principalDesc, hiveObj);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), revokeDesc), this.conf, new Task[0]));
    }

    private PrivilegeObjectDesc analyzePrivilegeObject(ASTNode ast) throws SemanticException {
        PrivilegeObjectDesc subject = new PrivilegeObjectDesc();
        subject.setObject(DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText()));
        if (ast.getChildCount() > 1) {
            for (int i = 0; i < ast.getChildCount(); ++i) {
                ASTNode astChild = (ASTNode)ast.getChild(i);
                if (astChild.getToken().getType() == 11) {
                    subject.setPartSpec(DDLSemanticAnalyzer.getPartSpec(astChild));
                    continue;
                }
                subject.setTable(ast.getChild(0) != null);
            }
        }
        return subject;
    }

    private List<PrincipalDesc> analyzePrincipalListDef(ASTNode node) {
        ArrayList<PrincipalDesc> principalList = new ArrayList<PrincipalDesc>();
        for (int i = 0; i < node.getChildCount(); ++i) {
            ASTNode child = (ASTNode)node.getChild(i);
            PrincipalType type = null;
            switch (child.getType()) {
                case 193: {
                    type = PrincipalType.USER;
                    break;
                }
                case 194: {
                    type = PrincipalType.GROUP;
                    break;
                }
                case 195: {
                    type = PrincipalType.ROLE;
                }
            }
            String principalName = DDLSemanticAnalyzer.unescapeIdentifier(child.getChild(0).getText());
            PrincipalDesc principalDesc = new PrincipalDesc(principalName, type);
            principalList.add(principalDesc);
        }
        return principalList;
    }

    private List<PrivilegeDesc> analyzePrivilegeListDef(ASTNode node) throws SemanticException {
        ArrayList<PrivilegeDesc> ret = new ArrayList<PrivilegeDesc>();
        for (int i = 0; i < node.getChildCount(); ++i) {
            ASTNode privilegeDef = (ASTNode)node.getChild(i);
            ASTNode privilegeType = (ASTNode)privilegeDef.getChild(0);
            Privilege privObj = PrivilegeRegistry.getPrivilege(privilegeType.getType());
            if (privObj == null) {
                throw new SemanticException("undefined privilege " + privObj.toString());
            }
            List<String> cols = null;
            if (privilegeDef.getChildCount() > 1) {
                cols = this.getColumnNames((ASTNode)privilegeDef.getChild(1));
            }
            PrivilegeDesc privilegeDesc = new PrivilegeDesc(privObj, cols);
            ret.add(privilegeDesc);
        }
        return ret;
    }

    private void analyzeCreateRole(ASTNode ast) {
        String roleName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        RoleDDLDesc createRoleDesc = new RoleDDLDesc(roleName, RoleDDLDesc.RoleOperation.CREATE_ROLE);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), createRoleDesc), this.conf, new Task[0]));
    }

    private void analyzeDropRole(ASTNode ast) {
        String roleName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        RoleDDLDesc createRoleDesc = new RoleDDLDesc(roleName, RoleDDLDesc.RoleOperation.DROP_ROLE);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), createRoleDesc), this.conf, new Task[0]));
    }

    private void analyzeShowRoleGrant(ASTNode ast) {
        ASTNode child = (ASTNode)ast.getChild(0);
        PrincipalType principalType = PrincipalType.USER;
        switch (child.getType()) {
            case 193: {
                principalType = PrincipalType.USER;
                break;
            }
            case 194: {
                principalType = PrincipalType.GROUP;
                break;
            }
            case 195: {
                principalType = PrincipalType.ROLE;
            }
        }
        String principalName = DDLSemanticAnalyzer.unescapeIdentifier(child.getChild(0).getText());
        RoleDDLDesc createRoleDesc = new RoleDDLDesc(principalName, principalType, RoleDDLDesc.RoleOperation.SHOW_ROLE_GRANT, null);
        createRoleDesc.setResFile(this.ctx.getResFile().toString());
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), createRoleDesc), this.conf, new Task[0]));
    }

    private void analyzeAlterDatabase(ASTNode ast) throws SemanticException {
        String dbName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        HashMap<String, String> dbProps = null;
        block3: for (int i = 1; i < ast.getChildCount(); ++i) {
            ASTNode childNode = (ASTNode)ast.getChild(i);
            switch (childNode.getToken().getType()) {
                case 214: {
                    dbProps = DDLSemanticAnalyzer.getProps((ASTNode)childNode.getChild(0));
                    continue block3;
                }
                default: {
                    throw new SemanticException("Unrecognized token in CREATE DATABASE statement");
                }
            }
        }
        AlterDatabaseDesc alterDesc = new AlterDatabaseDesc(dbName, null, null, false);
        alterDesc.setDatabaseProperties(dbProps);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterDesc), this.conf, new Task[0]));
    }

    private void analyzeCreateDatabase(ASTNode ast) throws SemanticException {
        String dbName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        boolean ifNotExists = false;
        String dbComment = null;
        HashMap<String, String> dbProps = null;
        block5: for (int i = 1; i < ast.getChildCount(); ++i) {
            ASTNode childNode = (ASTNode)ast.getChild(i);
            switch (childNode.getToken().getType()) {
                case 170: {
                    ifNotExists = true;
                    continue block5;
                }
                case 124: {
                    dbComment = DDLSemanticAnalyzer.unescapeSQLString(childNode.getChild(0).getText());
                    continue block5;
                }
                case 214: {
                    dbProps = DDLSemanticAnalyzer.getProps((ASTNode)childNode.getChild(0));
                    continue block5;
                }
                default: {
                    throw new SemanticException("Unrecognized token in CREATE DATABASE statement");
                }
            }
        }
        CreateDatabaseDesc createDatabaseDesc = new CreateDatabaseDesc();
        createDatabaseDesc.setName(dbName);
        createDatabaseDesc.setComment(dbComment);
        createDatabaseDesc.setIfNotExists(ifNotExists);
        createDatabaseDesc.setLocationUri(null);
        if (dbProps != null) {
            createDatabaseDesc.setDatabaseProperties(dbProps);
        }
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), createDatabaseDesc), this.conf, new Task[0]));
    }

    private void analyzeDropDatabase(ASTNode ast) throws SemanticException {
        String dbName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        boolean ifExists = false;
        if (null != ast.getFirstChildWithType(169)) {
            ifExists = true;
        }
        DropDatabaseDesc dropDatabaseDesc = new DropDatabaseDesc(dbName, ifExists);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), dropDatabaseDesc), this.conf, new Task[0]));
    }

    private void analyzeSwitchDatabase(ASTNode ast) {
        String dbName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        SwitchDatabaseDesc switchDatabaseDesc = new SwitchDatabaseDesc(dbName);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), switchDatabaseDesc), this.conf, new Task[0]));
    }

    private void analyzeDropTable(ASTNode ast, boolean expectView) throws SemanticException {
        String tableName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        boolean ifExists = ast.getFirstChildWithType(169) != null;
        boolean throwException = !ifExists && !HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.DROPIGNORESNONEXISTENT);
        try {
            Table tab = this.db.getTable(this.db.getCurrentDatabase(), tableName, throwException);
            if (tab != null) {
                this.inputs.add(new ReadEntity(tab));
                this.outputs.add(new WriteEntity(tab));
            }
        }
        catch (HiveException e) {
            throw new SemanticException(ErrorMsg.INVALID_TABLE.getMsg(tableName));
        }
        DropTableDesc dropTblDesc = new DropTableDesc(tableName, expectView);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), dropTblDesc), this.conf, new Task[0]));
    }

    private void analyzeCreateIndex(ASTNode ast) throws SemanticException {
        String indexName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        String typeName = DDLSemanticAnalyzer.unescapeSQLString(ast.getChild(1).getText());
        String tableName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(2).getText());
        List<String> indexedCols = this.getColumnNames((ASTNode)ast.getChild(3));
        HiveIndex.IndexType indexType = HiveIndex.getIndexType(typeName);
        if (indexType != null) {
            typeName = indexType.getHandlerClsName();
        } else {
            try {
                Class.forName(typeName);
            }
            catch (Exception e) {
                throw new SemanticException("class name provided for index handler not found.", e);
            }
        }
        String indexTableName = null;
        boolean deferredRebuild = false;
        String location = null;
        HashMap<String, String> tblProps = null;
        HashMap<String, String> idxProps = null;
        String indexComment = null;
        BaseSemanticAnalyzer.RowFormatParams rowFormatParams = new BaseSemanticAnalyzer.RowFormatParams();
        BaseSemanticAnalyzer.StorageFormat storageFormat = new BaseSemanticAnalyzer.StorageFormat();
        BaseSemanticAnalyzer.AnalyzeCreateCommonVars shared = new BaseSemanticAnalyzer.AnalyzeCreateCommonVars();
        block12: for (int idx = 4; idx < ast.getChildCount(); ++idx) {
            ASTNode child = (ASTNode)ast.getChild(idx);
            if (storageFormat.fillStorageFormat(child, shared)) continue;
            switch (child.getToken().getType()) {
                case 130: {
                    rowFormatParams.analyzeRowFormat(shared, child);
                    continue block12;
                }
                case 86: {
                    ASTNode ch = (ASTNode)child.getChild(0);
                    indexTableName = DDLSemanticAnalyzer.unescapeIdentifier(ch.getText());
                    continue block12;
                }
                case 87: {
                    deferredRebuild = true;
                    continue block12;
                }
                case 148: {
                    location = DDLSemanticAnalyzer.unescapeSQLString(child.getChild(0).getText());
                    continue block12;
                }
                case 162: {
                    tblProps = DDLSemanticAnalyzer.getProps((ASTNode)child.getChild(0));
                    continue block12;
                }
                case 164: {
                    idxProps = DDLSemanticAnalyzer.getProps((ASTNode)child.getChild(0));
                    continue block12;
                }
                case 161: {
                    child = (ASTNode)child.getChild(0);
                    shared.serde = DDLSemanticAnalyzer.unescapeSQLString(child.getChild(0).getText());
                    if (child.getChildCount() != 2) continue block12;
                    DDLSemanticAnalyzer.readProps((ASTNode)child.getChild(1).getChild(0), shared.serdeProps);
                    continue block12;
                }
                case 212: {
                    child = (ASTNode)child.getChild(0);
                    indexComment = DDLSemanticAnalyzer.unescapeSQLString(child.getText());
                }
            }
        }
        storageFormat.fillDefaultStorageFormat(shared);
        CreateIndexDesc crtIndexDesc = new CreateIndexDesc(tableName, indexName, indexedCols, indexTableName, deferredRebuild, storageFormat.inputFormat, storageFormat.outputFormat, storageFormat.storageHandler, typeName, location, idxProps, tblProps, shared.serde, shared.serdeProps, rowFormatParams.collItemDelim, rowFormatParams.fieldDelim, rowFormatParams.fieldEscape, rowFormatParams.lineDelim, rowFormatParams.mapKeyDelim, indexComment);
        Task<DDLWork> createIndex = TaskFactory.get(new DDLWork(crtIndexDesc), this.conf, new Task[0]);
        this.rootTasks.add(createIndex);
    }

    private void analyzeDropIndex(ASTNode ast) throws SemanticException {
        boolean throwException;
        String indexName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        String tableName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(1).getText());
        boolean ifExists = ast.getFirstChildWithType(169) != null;
        boolean bl = throwException = !ifExists && !HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.DROPIGNORESNONEXISTENT);
        if (throwException) {
            try {
                Index idx = this.db.getIndex(tableName, indexName);
            }
            catch (HiveException e) {
                throw new SemanticException(ErrorMsg.INVALID_INDEX.getMsg(indexName));
            }
        }
        DropIndexDesc dropIdxDesc = new DropIndexDesc(indexName, tableName);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), dropIdxDesc), this.conf, new Task[0]));
    }

    private void analyzeAlterIndexRebuild(ASTNode ast) throws SemanticException {
        String baseTableName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        String indexName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(1).getText());
        HashMap<String, String> partSpec = null;
        Tree part = ast.getChild(2);
        if (part != null) {
            partSpec = this.extractPartitionSpecs(part);
        }
        List<Task<?>> indexBuilder = this.getIndexBuilderMapRed(baseTableName, indexName, partSpec);
        this.rootTasks.addAll(indexBuilder);
    }

    private void analyzeAlterIndexProps(ASTNode ast) throws SemanticException {
        String baseTableName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        String indexName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(1).getText());
        HashMap<String, String> mapProp = DDLSemanticAnalyzer.getProps((ASTNode)ast.getChild(2).getChild(0));
        AlterIndexDesc alterIdxDesc = new AlterIndexDesc(AlterIndexDesc.AlterIndexTypes.ADDPROPS);
        alterIdxDesc.setProps(mapProp);
        alterIdxDesc.setIndexName(indexName);
        alterIdxDesc.setBaseTableName(baseTableName);
        alterIdxDesc.setDbName(this.db.getCurrentDatabase());
        this.rootTasks.add(TaskFactory.get(new DDLWork(alterIdxDesc), this.conf, new Task[0]));
    }

    private List<Task<?>> getIndexBuilderMapRed(String baseTableName, String indexName, HashMap<String, String> partSpec) throws SemanticException {
        try {
            String dbName = this.db.getCurrentDatabase();
            Index index = this.db.getIndex(dbName, baseTableName, indexName);
            Table indexTbl = this.db.getTable(dbName, index.getIndexTableName());
            String baseTblName = index.getOrigTableName();
            Table baseTbl = this.db.getTable(dbName, baseTblName);
            String handlerCls = index.getIndexHandlerClass();
            HiveIndexHandler handler = HiveUtils.getIndexHandler(this.conf, handlerCls);
            ArrayList<Partition> indexTblPartitions = null;
            List<Partition> baseTblPartitions = null;
            if (indexTbl != null) {
                indexTblPartitions = new ArrayList<Partition>();
                baseTblPartitions = this.preparePartitions(baseTbl, partSpec, indexTbl, this.db, indexTblPartitions);
            }
            List<Task<?>> ret = handler.generateIndexBuildTaskList(baseTbl, index, indexTblPartitions, baseTblPartitions, indexTbl, this.getInputs(), this.getOutputs());
            return ret;
        }
        catch (Exception e) {
            throw new SemanticException(e);
        }
    }

    private List<Partition> preparePartitions(Table baseTbl, HashMap<String, String> partSpec, Table indexTbl, Hive db, List<Partition> indexTblPartitions) throws HiveException, MetaException {
        List<Partition> baseTblPartitions = new ArrayList<Partition>();
        if (partSpec != null) {
            Partition part = db.getPartition(baseTbl, partSpec, false);
            if (part == null) {
                throw new HiveException("Partition " + Warehouse.makePartName(partSpec, (boolean)false) + " does not exist in table " + baseTbl.getTableName());
            }
            baseTblPartitions.add(part);
            Partition indexPart = db.getPartition(indexTbl, partSpec, false);
            if (indexPart == null) {
                indexPart = db.createPartition(indexTbl, partSpec);
            }
            indexTblPartitions.add(indexPart);
        } else if (baseTbl.isPartitioned()) {
            baseTblPartitions = db.getPartitions(baseTbl);
            for (Partition basePart : baseTblPartitions) {
                LinkedHashMap<String, String> pSpec = basePart.getSpec();
                Partition indexPart = db.getPartition(indexTbl, pSpec, false);
                if (indexPart == null) {
                    indexPart = db.createPartition(indexTbl, pSpec);
                }
                indexTblPartitions.add(indexPart);
            }
        }
        return baseTblPartitions;
    }

    private void analyzeAlterTableProps(ASTNode ast, boolean expectView) throws SemanticException {
        String tableName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        HashMap<String, String> mapProp = DDLSemanticAnalyzer.getProps((ASTNode)ast.getChild(1).getChild(0));
        AlterTableDesc alterTblDesc = new AlterTableDesc(AlterTableDesc.AlterTableTypes.ADDPROPS, expectView);
        alterTblDesc.setProps(mapProp);
        alterTblDesc.setOldName(tableName);
        try {
            Table tab = this.db.getTable(this.db.getCurrentDatabase(), tableName, false);
            if (tab != null) {
                this.inputs.add(new ReadEntity(tab));
                this.outputs.add(new WriteEntity(tab));
            }
        }
        catch (HiveException e) {
            throw new SemanticException(ErrorMsg.INVALID_TABLE.getMsg(tableName));
        }
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf, new Task[0]));
    }

    private void analyzeAlterTableSerdeProps(ASTNode ast) throws SemanticException {
        String tableName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        HashMap<String, String> mapProp = DDLSemanticAnalyzer.getProps((ASTNode)ast.getChild(1).getChild(0));
        AlterTableDesc alterTblDesc = new AlterTableDesc(AlterTableDesc.AlterTableTypes.ADDSERDEPROPS);
        alterTblDesc.setProps(mapProp);
        alterTblDesc.setOldName(tableName);
        try {
            Table tab = this.db.getTable(this.db.getCurrentDatabase(), tableName, false);
            if (tab != null) {
                this.inputs.add(new ReadEntity(tab));
                this.outputs.add(new WriteEntity(tab));
            }
        }
        catch (HiveException e) {
            throw new SemanticException(ErrorMsg.INVALID_TABLE.getMsg(tableName));
        }
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf, new Task[0]));
    }

    private void analyzeAlterTableSerde(ASTNode ast) throws SemanticException {
        String tableName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        String serdeName = DDLSemanticAnalyzer.unescapeSQLString(ast.getChild(1).getText());
        AlterTableDesc alterTblDesc = new AlterTableDesc(AlterTableDesc.AlterTableTypes.ADDSERDE);
        if (ast.getChildCount() > 2) {
            HashMap<String, String> mapProp = DDLSemanticAnalyzer.getProps((ASTNode)ast.getChild(2).getChild(0));
            alterTblDesc.setProps(mapProp);
        }
        alterTblDesc.setOldName(tableName);
        alterTblDesc.setSerdeName(serdeName);
        try {
            Table tab = this.db.getTable(this.db.getCurrentDatabase(), tableName, false);
            if (tab != null) {
                this.inputs.add(new ReadEntity(tab));
                this.outputs.add(new WriteEntity(tab));
            }
        }
        catch (HiveException e) {
            throw new SemanticException(ErrorMsg.INVALID_TABLE.getMsg(tableName));
        }
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf, new Task[0]));
    }

    private void analyzeAlterTableFileFormat(ASTNode ast, String tableName, HashMap<String, String> partSpec) throws SemanticException {
        String inputFormat = null;
        String outputFormat = null;
        String storageHandler = null;
        String serde = null;
        ASTNode child = (ASTNode)ast.getChild(0);
        switch (child.getToken().getType()) {
            case 138: {
                inputFormat = DDLSemanticAnalyzer.unescapeSQLString(((ASTNode)child.getChild(0)).getToken().getText());
                outputFormat = DDLSemanticAnalyzer.unescapeSQLString(((ASTNode)child.getChild(1)).getToken().getText());
                try {
                    Class.forName(inputFormat);
                    Class.forName(outputFormat);
                    break;
                }
                catch (ClassNotFoundException e) {
                    throw new SemanticException(e);
                }
            }
            case 145: {
                storageHandler = DDLSemanticAnalyzer.unescapeSQLString(((ASTNode)child.getChild(1)).getToken().getText());
                try {
                    Class.forName(storageHandler);
                    break;
                }
                catch (ClassNotFoundException e) {
                    throw new SemanticException(e);
                }
            }
            case 135: {
                inputFormat = SEQUENCEFILE_INPUT;
                outputFormat = SEQUENCEFILE_OUTPUT;
                break;
            }
            case 136: {
                inputFormat = TEXTFILE_INPUT;
                outputFormat = TEXTFILE_OUTPUT;
                break;
            }
            case 137: {
                inputFormat = RCFILE_INPUT;
                outputFormat = RCFILE_OUTPUT;
                serde = COLUMNAR_SERDE;
                break;
            }
            case 139: {
                this.handleGenericFileFormat(child);
            }
        }
        AlterTableDesc alterTblDesc = new AlterTableDesc(tableName, inputFormat, outputFormat, serde, storageHandler, partSpec);
        this.addInputsOutputsAlterTable(tableName, partSpec);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf, new Task[0]));
    }

    private void addInputsOutputsAlterTable(String tableName, HashMap<String, String> partSpec) throws SemanticException {
        try {
            Table tab = this.db.getTable(this.db.getCurrentDatabase(), tableName, false);
            if (tab != null) {
                this.inputs.add(new ReadEntity(tab));
                if (partSpec == null || partSpec.isEmpty()) {
                    this.outputs.add(new WriteEntity(tab));
                } else {
                    Partition part = this.db.getPartition(tab, partSpec, false);
                    if (part != null) {
                        this.outputs.add(new WriteEntity(part));
                    }
                }
            }
        }
        catch (HiveException e) {
            throw new SemanticException(ErrorMsg.INVALID_TABLE.getMsg(tableName));
        }
    }

    private void analyzeAlterTableLocation(ASTNode ast, String tableName, HashMap<String, String> partSpec) throws SemanticException {
        String newLocation = DDLSemanticAnalyzer.unescapeSQLString(ast.getChild(0).getText());
        AlterTableDesc alterTblDesc = new AlterTableDesc(tableName, newLocation, partSpec);
        this.addInputsOutputsAlterTable(tableName, partSpec);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf, new Task[0]));
    }

    private void analyzeAlterTableProtectMode(ASTNode ast, String tableName, HashMap<String, String> partSpec) throws SemanticException {
        AlterTableDesc alterTblDesc = new AlterTableDesc(AlterTableDesc.AlterTableTypes.ALTERPROTECTMODE);
        alterTblDesc.setOldName(tableName);
        alterTblDesc.setPartSpec(partSpec);
        ASTNode child = (ASTNode)ast.getChild(0);
        switch (child.getToken().getType()) {
            case 141: {
                alterTblDesc.setProtectModeEnable(true);
                break;
            }
            case 142: {
                alterTblDesc.setProtectModeEnable(false);
                break;
            }
            default: {
                throw new SemanticException("Set Protect mode Syntax parsing error.");
            }
        }
        ASTNode grandChild = (ASTNode)child.getChild(0);
        switch (grandChild.getToken().getType()) {
            case 140: {
                alterTblDesc.setProtectModeType(AlterTableDesc.ProtectModeType.OFFLINE);
                break;
            }
            case 144: {
                alterTblDesc.setProtectModeType(AlterTableDesc.ProtectModeType.NO_DROP);
                break;
            }
            case 143: {
                throw new SemanticException("Potect mode READONLY is not implemented");
            }
            default: {
                throw new SemanticException("Only protect mode NO_DROP or OFFLINE supported");
            }
        }
        this.addInputsOutputsAlterTable(tableName, partSpec);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf, new Task[0]));
    }

    private void analyzeAlterTableClusterSort(ASTNode ast) throws SemanticException {
        String tableName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        try {
            Table tab = this.db.getTable(this.db.getCurrentDatabase(), tableName, false);
            if (tab != null) {
                this.inputs.add(new ReadEntity(tab));
                this.outputs.add(new WriteEntity(tab));
            }
        }
        catch (HiveException e) {
            throw new SemanticException(ErrorMsg.INVALID_TABLE.getMsg(tableName));
        }
        if (ast.getChildCount() == 1) {
            AlterTableDesc alterTblDesc = new AlterTableDesc(tableName, -1, new ArrayList<String>(), new ArrayList<Order>());
            this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf, new Task[0]));
        } else {
            ASTNode buckets = (ASTNode)ast.getChild(1);
            List<String> bucketCols = this.getColumnNames((ASTNode)buckets.getChild(0));
            ArrayList<Order> sortCols = new ArrayList();
            int numBuckets = -1;
            if (buckets.getChildCount() == 2) {
                numBuckets = Integer.valueOf(buckets.getChild(1).getText());
            } else {
                sortCols = this.getColumnNamesOrder((ASTNode)buckets.getChild(1));
                numBuckets = Integer.valueOf(buckets.getChild(2).getText());
            }
            if (numBuckets <= 0) {
                throw new SemanticException(ErrorMsg.INVALID_BUCKET_NUMBER.getMsg());
            }
            AlterTableDesc alterTblDesc = new AlterTableDesc(tableName, numBuckets, bucketCols, sortCols);
            this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf, new Task[0]));
        }
    }

    static HashMap<String, String> getProps(ASTNode prop) {
        HashMap<String, String> mapProp = new HashMap<String, String>();
        DDLSemanticAnalyzer.readProps(prop, mapProp);
        return mapProp;
    }

    private String getFullyQualifiedName(ASTNode ast) {
        if (ast.getChildCount() == 0) {
            return ast.getText();
        }
        return this.getFullyQualifiedName((ASTNode)ast.getChild(0)) + "." + this.getFullyQualifiedName((ASTNode)ast.getChild(1));
    }

    private FetchTask createFetchTask(String schema) {
        Properties prop = new Properties();
        prop.setProperty("serialization.format", "9");
        prop.setProperty("serialization.null.format", " ");
        String[] colTypes = schema.split("#");
        prop.setProperty("columns", colTypes[0]);
        prop.setProperty("columns.types", colTypes[1]);
        FetchWork fetch = new FetchWork(this.ctx.getResFile().toString(), new TableDesc(LazySimpleSerDe.class, TextInputFormat.class, IgnoreKeyTextOutputFormat.class, prop), -1);
        fetch.setSerializationNullFormat(" ");
        return (FetchTask)TaskFactory.get(fetch, this.conf, new Task[0]);
    }

    private void analyzeDescribeTable(ASTNode ast) throws SemanticException {
        ASTNode tableTypeExpr = (ASTNode)ast.getChild(0);
        String tableName = this.getFullyQualifiedName((ASTNode)tableTypeExpr.getChild(0));
        HashMap<String, String> partSpec = null;
        if (tableTypeExpr.getChildCount() == 2) {
            ASTNode partspec = (ASTNode)tableTypeExpr.getChild(1);
            partSpec = DDLSemanticAnalyzer.getPartSpec(partspec);
        }
        DescTableDesc descTblDesc = new DescTableDesc(this.ctx.getResFile(), tableName, partSpec);
        if (ast.getChildCount() == 2) {
            int descOptions = ast.getChild(1).getType();
            descTblDesc.setFormatted(descOptions == 290);
            descTblDesc.setExt(descOptions == 218);
        }
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), descTblDesc), this.conf, new Task[0]));
        this.setFetchTask(this.createFetchTask(DescTableDesc.getSchema()));
        LOG.info((Object)"analyzeDescribeTable done");
    }

    private void analyzeDescDatabase(ASTNode ast) throws SemanticException {
        boolean isExtended;
        String dbName;
        if (ast.getChildCount() == 1) {
            dbName = DDLSemanticAnalyzer.stripQuotes(ast.getChild(0).getText());
            isExtended = false;
        } else if (ast.getChildCount() == 2) {
            dbName = DDLSemanticAnalyzer.stripQuotes(ast.getChild(0).getText());
            isExtended = true;
        } else {
            throw new SemanticException("Unexpected Tokens at DESCRIBE DATABASE");
        }
        DescDatabaseDesc descDbDesc = new DescDatabaseDesc(this.ctx.getResFile(), dbName, isExtended);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), descDbDesc), this.conf, new Task[0]));
        this.setFetchTask(this.createFetchTask(descDbDesc.getSchema()));
    }

    private static HashMap<String, String> getPartSpec(ASTNode partspec) throws SemanticException {
        LinkedHashMap<String, String> partSpec = new LinkedHashMap<String, String>();
        for (int i = 0; i < partspec.getChildCount(); ++i) {
            ASTNode partspec_val = (ASTNode)partspec.getChild(i);
            String val = DDLSemanticAnalyzer.stripQuotes(partspec_val.getChild(1).getText());
            partSpec.put(partspec_val.getChild(0).getText().toLowerCase(), val);
        }
        return partSpec;
    }

    private void analyzeShowPartitions(ASTNode ast) throws SemanticException {
        String tableName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        List<Map<String, String>> partSpecs = this.getPartitionSpecs(ast);
        assert (partSpecs.size() <= 1);
        Map<String, String> partSpec = null;
        if (partSpecs.size() > 0) {
            partSpec = partSpecs.get(0);
        }
        ShowPartitionsDesc showPartsDesc = new ShowPartitionsDesc(tableName, this.ctx.getResFile(), partSpec);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), showPartsDesc), this.conf, new Task[0]));
        this.setFetchTask(this.createFetchTask(showPartsDesc.getSchema()));
    }

    private void analyzeShowDatabases(ASTNode ast) throws SemanticException {
        ShowDatabasesDesc showDatabasesDesc;
        if (ast.getChildCount() == 1) {
            String databasePattern = DDLSemanticAnalyzer.unescapeSQLString(ast.getChild(0).getText());
            showDatabasesDesc = new ShowDatabasesDesc(this.ctx.getResFile(), databasePattern);
        } else {
            showDatabasesDesc = new ShowDatabasesDesc(this.ctx.getResFile());
        }
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), showDatabasesDesc), this.conf, new Task[0]));
        this.setFetchTask(this.createFetchTask(showDatabasesDesc.getSchema()));
    }

    private void analyzeShowTables(ASTNode ast) throws SemanticException {
        ShowTablesDesc showTblsDesc;
        String dbName = this.db.getCurrentDatabase();
        String tableNames = null;
        if (ast.getChildCount() > 3) {
            throw new SemanticException(ErrorMsg.GENERIC_ERROR.getMsg());
        }
        switch (ast.getChildCount()) {
            case 1: {
                tableNames = DDLSemanticAnalyzer.unescapeSQLString(ast.getChild(0).getText());
                showTblsDesc = new ShowTablesDesc(this.ctx.getResFile(), dbName, tableNames);
                break;
            }
            case 2: {
                assert (ast.getChild(0).getType() == 9);
                dbName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(1).getText());
                showTblsDesc = new ShowTablesDesc(this.ctx.getResFile(), dbName);
                break;
            }
            case 3: {
                assert (ast.getChild(0).getType() == 9);
                dbName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(1).getText());
                tableNames = DDLSemanticAnalyzer.unescapeSQLString(ast.getChild(2).getText());
                showTblsDesc = new ShowTablesDesc(this.ctx.getResFile(), dbName, tableNames);
                break;
            }
            default: {
                showTblsDesc = new ShowTablesDesc(this.ctx.getResFile(), dbName);
            }
        }
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), showTblsDesc), this.conf, new Task[0]));
        this.setFetchTask(this.createFetchTask(showTblsDesc.getSchema()));
    }

    private void analyzeShowTableStatus(ASTNode ast) throws SemanticException {
        String tableNames = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        String dbName = this.db.getCurrentDatabase();
        int children = ast.getChildCount();
        HashMap<String, String> partSpec = null;
        if (children >= 2) {
            if (children > 3) {
                throw new SemanticException(ErrorMsg.GENERIC_ERROR.getMsg());
            }
            for (int i = 1; i < children; ++i) {
                ASTNode child = (ASTNode)ast.getChild(i);
                if (child.getToken().getType() == 233) {
                    dbName = DDLSemanticAnalyzer.unescapeIdentifier(child.getText());
                    continue;
                }
                if (child.getToken().getType() == 11) {
                    partSpec = DDLSemanticAnalyzer.getPartSpec(child);
                    continue;
                }
                throw new SemanticException(ErrorMsg.GENERIC_ERROR.getMsg());
            }
        }
        ShowTableStatusDesc showTblStatusDesc = new ShowTableStatusDesc(this.ctx.getResFile().toString(), dbName, tableNames, partSpec);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), showTblStatusDesc), this.conf, new Task[0]));
        this.setFetchTask(this.createFetchTask(showTblStatusDesc.getSchema()));
    }

    private void analyzeShowIndexes(ASTNode ast) throws SemanticException {
        String tableName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        ShowIndexesDesc showIndexesDesc = new ShowIndexesDesc(tableName, this.ctx.getResFile());
        if (ast.getChildCount() == 2) {
            int descOptions = ast.getChild(1).getType();
            showIndexesDesc.setFormatted(descOptions == 290);
        }
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), showIndexesDesc), this.conf, new Task[0]));
        this.setFetchTask(this.createFetchTask(showIndexesDesc.getSchema()));
    }

    private void analyzeShowFunctions(ASTNode ast) throws SemanticException {
        ShowFunctionsDesc showFuncsDesc;
        if (ast.getChildCount() == 1) {
            String funcNames = DDLSemanticAnalyzer.stripQuotes(ast.getChild(0).getText());
            showFuncsDesc = new ShowFunctionsDesc(this.ctx.getResFile(), funcNames);
        } else {
            showFuncsDesc = new ShowFunctionsDesc(this.ctx.getResFile());
        }
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), showFuncsDesc), this.conf, new Task[0]));
        this.setFetchTask(this.createFetchTask(showFuncsDesc.getSchema()));
    }

    private void analyzeShowLocks(ASTNode ast) throws SemanticException {
        String tableName = null;
        HashMap<String, String> partSpec = null;
        boolean isExtended = false;
        if (ast.getChildCount() >= 1) {
            for (int i = 0; i < ast.getChildCount(); ++i) {
                ASTNode child = (ASTNode)ast.getChild(i);
                if (child.getType() == 166) {
                    ASTNode tableTypeExpr = child;
                    tableName = this.getFullyQualifiedName((ASTNode)tableTypeExpr.getChild(0));
                    if (tableTypeExpr.getChildCount() != 2) continue;
                    ASTNode partspec = (ASTNode)tableTypeExpr.getChild(1);
                    partSpec = DDLSemanticAnalyzer.getPartSpec(partspec);
                    continue;
                }
                if (child.getType() != 218) continue;
                isExtended = true;
            }
        }
        ShowLocksDesc showLocksDesc = new ShowLocksDesc(this.ctx.getResFile(), tableName, partSpec, isExtended);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), showLocksDesc), this.conf, new Task[0]));
        this.setFetchTask(this.createFetchTask(showLocksDesc.getSchema()));
        this.ctx.setNeedLockMgr(true);
    }

    private void analyzeLockTable(ASTNode ast) throws SemanticException {
        String tableName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText().toLowerCase());
        String mode = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(1).getText().toUpperCase());
        List<Map<String, String>> partSpecs = this.getPartitionSpecs(ast);
        assert (partSpecs.size() <= 1);
        Map<String, String> partSpec = null;
        if (partSpecs.size() > 0) {
            partSpec = partSpecs.get(0);
        }
        LockTableDesc lockTblDesc = new LockTableDesc(tableName, mode, partSpec, HiveConf.getVar(this.conf, HiveConf.ConfVars.HIVEQUERYID));
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), lockTblDesc), this.conf, new Task[0]));
        this.ctx.setNeedLockMgr(true);
    }

    private void analyzeUnlockTable(ASTNode ast) throws SemanticException {
        String tableName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText().toLowerCase());
        List<Map<String, String>> partSpecs = this.getPartitionSpecs(ast);
        assert (partSpecs.size() <= 1);
        Map<String, String> partSpec = null;
        if (partSpecs.size() > 0) {
            partSpec = partSpecs.get(0);
        }
        UnlockTableDesc unlockTblDesc = new UnlockTableDesc(tableName, partSpec);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), unlockTblDesc), this.conf, new Task[0]));
        this.ctx.setNeedLockMgr(true);
    }

    private void analyzeDescFunction(ASTNode ast) throws SemanticException {
        boolean isExtended;
        String funcName;
        if (ast.getChildCount() == 1) {
            funcName = DDLSemanticAnalyzer.stripQuotes(ast.getChild(0).getText());
            isExtended = false;
        } else if (ast.getChildCount() == 2) {
            funcName = DDLSemanticAnalyzer.stripQuotes(ast.getChild(0).getText());
            isExtended = true;
        } else {
            throw new SemanticException("Unexpected Tokens at DESCRIBE FUNCTION");
        }
        DescFunctionDesc descFuncDesc = new DescFunctionDesc(this.ctx.getResFile(), funcName, isExtended);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), descFuncDesc), this.conf, new Task[0]));
        this.setFetchTask(this.createFetchTask(descFuncDesc.getSchema()));
    }

    private void analyzeAlterTableRename(ASTNode ast) throws SemanticException {
        String tblName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        AlterTableDesc alterTblDesc = new AlterTableDesc(tblName, DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(1).getText()));
        try {
            Table tab = this.db.getTable(this.db.getCurrentDatabase(), tblName, false);
            if (tab != null) {
                this.inputs.add(new ReadEntity(tab));
                this.outputs.add(new WriteEntity(tab));
            }
        }
        catch (HiveException e) {
            throw new SemanticException(ErrorMsg.INVALID_TABLE.getMsg(tblName));
        }
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf, new Task[0]));
    }

    private void analyzeAlterTableRenameCol(ASTNode ast) throws SemanticException {
        String tblName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        String newComment = null;
        String newType = null;
        newType = DDLSemanticAnalyzer.getTypeStringFromAST((ASTNode)ast.getChild(3));
        boolean first = false;
        String flagCol = null;
        ASTNode positionNode = null;
        if (ast.getChildCount() == 6) {
            newComment = DDLSemanticAnalyzer.unescapeSQLString(ast.getChild(4).getText());
            positionNode = (ASTNode)ast.getChild(5);
        } else if (ast.getChildCount() == 5) {
            if (ast.getChild(4).getType() == 223) {
                newComment = DDLSemanticAnalyzer.unescapeSQLString(ast.getChild(4).getText());
            } else {
                positionNode = (ASTNode)ast.getChild(4);
            }
        }
        if (positionNode != null) {
            if (positionNode.getChildCount() == 0) {
                first = true;
            } else {
                flagCol = DDLSemanticAnalyzer.unescapeIdentifier(positionNode.getChild(0).getText());
            }
        }
        AlterTableDesc alterTblDesc = new AlterTableDesc(tblName, DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(1).getText()), DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(2).getText()), newType, newComment, first, flagCol);
        try {
            Table tab = this.db.getTable(this.db.getCurrentDatabase(), tblName, false);
            if (tab != null) {
                this.inputs.add(new ReadEntity(tab));
                this.outputs.add(new WriteEntity(tab));
            }
        }
        catch (HiveException e) {
            throw new SemanticException(ErrorMsg.INVALID_TABLE.getMsg(tblName));
        }
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf, new Task[0]));
    }

    private void analyzeAlterTableModifyCols(ASTNode ast, AlterTableDesc.AlterTableTypes alterType) throws SemanticException {
        String tblName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        List<FieldSchema> newCols = this.getColumns((ASTNode)ast.getChild(1));
        AlterTableDesc alterTblDesc = new AlterTableDesc(tblName, newCols, alterType);
        try {
            Table tab = this.db.getTable(this.db.getCurrentDatabase(), tblName, false);
            if (tab != null) {
                this.inputs.add(new ReadEntity(tab));
                this.outputs.add(new WriteEntity(tab));
            }
        }
        catch (HiveException e) {
            throw new SemanticException(ErrorMsg.INVALID_TABLE.getMsg(tblName));
        }
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf, new Task[0]));
    }

    private void analyzeAlterTableDropParts(ASTNode ast) throws SemanticException {
        String tblName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        List<Map<String, String>> partSpecs = this.getPartitionSpecs(ast);
        DropTableDesc dropTblDesc = new DropTableDesc(tblName, partSpecs);
        try {
            Table tab = this.db.getTable(this.db.getCurrentDatabase(), tblName, false);
            if (tab != null) {
                this.inputs.add(new ReadEntity(tab));
            }
        }
        catch (HiveException e) {
            throw new SemanticException(ErrorMsg.INVALID_TABLE.getMsg(tblName));
        }
        if (partSpecs != null) {
            boolean ifExists = ast.getFirstChildWithType(169) != null;
            boolean throwException = !ifExists && !HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.DROPIGNORESNONEXISTENT);
            this.addTablePartsOutputs(tblName, partSpecs, throwException, ast);
        }
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), dropTblDesc), this.conf, new Task[0]));
    }

    private void analyzeAlterTableAddParts(CommonTree ast) throws SemanticException {
        String tblName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        try {
            Table tab = this.db.getTable(this.db.getCurrentDatabase(), tblName, false);
            if (tab != null) {
                this.inputs.add(new ReadEntity(tab));
            }
        }
        catch (HiveException e) {
            throw new SemanticException(ErrorMsg.INVALID_TABLE.getMsg(tblName));
        }
        List<Map<String, String>> partSpecs = this.getPartitionSpecs(ast);
        this.addTablePartsOutputs(tblName, partSpecs);
        Iterator<Map<String, String>> partIter = partSpecs.iterator();
        String currentLocation = null;
        Map<String, String> currentPart = null;
        boolean ifNotExists = false;
        int numCh = ast.getChildCount();
        block7: for (int num = 1; num < numCh; ++num) {
            CommonTree child = (CommonTree)ast.getChild(num);
            switch (child.getToken().getType()) {
                case 170: {
                    ifNotExists = true;
                    continue block7;
                }
                case 11: {
                    if (currentPart != null) {
                        this.validatePartitionValues(currentPart);
                        AddPartitionDesc addPartitionDesc = new AddPartitionDesc(this.db.getCurrentDatabase(), tblName, currentPart, currentLocation, ifNotExists);
                        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), addPartitionDesc), this.conf, new Task[0]));
                    }
                    currentLocation = null;
                    currentPart = partIter.next();
                    continue block7;
                }
                case 149: {
                    currentLocation = DDLSemanticAnalyzer.unescapeSQLString(child.getChild(0).getText());
                    continue block7;
                }
                default: {
                    throw new SemanticException("Unknown child: " + child);
                }
            }
        }
        if (currentPart != null) {
            this.validatePartitionValues(currentPart);
            AddPartitionDesc addPartitionDesc = new AddPartitionDesc(this.db.getCurrentDatabase(), tblName, currentPart, currentLocation, ifNotExists);
            this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), addPartitionDesc), this.conf, new Task[0]));
        }
    }

    private void analyzeAlterTableTouch(CommonTree ast) throws SemanticException {
        Table tab;
        String tblName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        try {
            tab = this.db.getTable(this.db.getCurrentDatabase(), tblName, false);
            if (tab != null) {
                this.inputs.add(new ReadEntity(tab));
            }
        }
        catch (HiveException e) {
            throw new SemanticException(ErrorMsg.INVALID_TABLE.getMsg(tblName));
        }
        List<Map<String, String>> partSpecs = this.getPartitionSpecs(ast);
        if (partSpecs.size() == 0) {
            AlterTableSimpleDesc touchDesc = new AlterTableSimpleDesc(this.db.getCurrentDatabase(), tblName, null, AlterTableDesc.AlterTableTypes.TOUCH);
            this.outputs.add(new WriteEntity(tab));
            this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), touchDesc), this.conf, new Task[0]));
        } else {
            this.addTablePartsOutputs(tblName, partSpecs);
            for (Map<String, String> partSpec : partSpecs) {
                AlterTableSimpleDesc touchDesc = new AlterTableSimpleDesc(this.db.getCurrentDatabase(), tblName, partSpec, AlterTableDesc.AlterTableTypes.TOUCH);
                this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), touchDesc), this.conf, new Task[0]));
            }
        }
    }

    private void analyzeAlterTableArchive(CommonTree ast, boolean isUnArchive) throws SemanticException {
        if (!this.conf.getBoolVar(HiveConf.ConfVars.HIVEARCHIVEENABLED)) {
            throw new SemanticException(ErrorMsg.ARCHIVE_METHODS_DISABLED.getMsg());
        }
        String tblName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        List<Map<String, String>> partSpecs = this.getPartitionSpecs(ast);
        try {
            Table tab = this.db.getTable(this.db.getCurrentDatabase(), tblName, false);
            if (tab != null) {
                this.inputs.add(new ReadEntity(tab));
            }
        }
        catch (HiveException e) {
            throw new SemanticException(ErrorMsg.INVALID_TABLE.getMsg(tblName));
        }
        this.addTablePartsOutputs(tblName, partSpecs);
        if (partSpecs.size() > 1) {
            throw new SemanticException(isUnArchive ? ErrorMsg.UNARCHIVE_ON_MULI_PARTS.getMsg() : ErrorMsg.ARCHIVE_ON_MULI_PARTS.getMsg());
        }
        if (partSpecs.size() == 0) {
            throw new SemanticException(ErrorMsg.ARCHIVE_ON_TABLE.getMsg());
        }
        Map<String, String> partSpec = partSpecs.get(0);
        AlterTableSimpleDesc archiveDesc = new AlterTableSimpleDesc(this.db.getCurrentDatabase(), tblName, partSpec, isUnArchive ? AlterTableDesc.AlterTableTypes.UNARCHIVE : AlterTableDesc.AlterTableTypes.ARCHIVE);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), archiveDesc), this.conf, new Task[0]));
    }

    private void analyzeMetastoreCheck(CommonTree ast) throws SemanticException {
        String tableName = null;
        boolean repair = false;
        if (ast.getChildCount() > 0) {
            boolean bl = repair = ast.getChild(0).getType() == 317;
            if (!repair) {
                tableName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
            } else if (ast.getChildCount() > 1) {
                tableName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(1).getText());
            }
        }
        List<Map<String, String>> specs = this.getPartitionSpecs(ast);
        MsckDesc checkDesc = new MsckDesc(tableName, specs, this.ctx.getResFile(), repair);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), checkDesc), this.conf, new Task[0]));
    }

    private List<Map<String, String>> getPartitionSpecs(CommonTree ast) throws SemanticException {
        ArrayList<Map<String, String>> partSpecs = new ArrayList<Map<String, String>>();
        int childIndex = 0;
        for (childIndex = 1; childIndex < ast.getChildCount(); ++childIndex) {
            Tree partspec = ast.getChild(childIndex);
            if (partspec.getType() != 11) continue;
            LinkedHashMap<String, String> partSpec = new LinkedHashMap<String, String>();
            for (int i = 0; i < partspec.getChildCount(); ++i) {
                CommonTree partspec_val = (CommonTree)partspec.getChild(i);
                String val = DDLSemanticAnalyzer.stripQuotes(partspec_val.getChild(1).getText());
                partSpec.put(partspec_val.getChild(0).getText().toLowerCase(), val);
            }
            partSpecs.add(partSpec);
        }
        return partSpecs;
    }

    private void validatePartitionValues(Map<String, String> partSpec) throws SemanticException {
        for (Map.Entry<String, String> e : partSpec.entrySet()) {
            for (String s : reservedPartitionValues) {
                if (!e.getValue().contains(s)) continue;
                throw new SemanticException(ErrorMsg.RESERVED_PART_VAL.getMsg("(User value: " + e.getValue() + " Reserved substring: " + s + ")"));
            }
        }
    }

    private void addTablePartsOutputs(String tblName, List<Map<String, String>> partSpecs) throws SemanticException {
        this.addTablePartsOutputs(tblName, partSpecs, false, null);
    }

    private void addTablePartsOutputs(String tblName, List<Map<String, String>> partSpecs, boolean throwIfNonExistent, ASTNode ast) throws SemanticException {
        Table tab;
        try {
            tab = this.db.getTable(tblName);
        }
        catch (HiveException e) {
            throw new SemanticException(ErrorMsg.INVALID_TABLE.getMsg(tblName));
        }
        Iterator<Map<String, String>> i = partSpecs.iterator();
        int index = 1;
        while (i.hasNext()) {
            block6: {
                Map<String, String> partSpec = i.next();
                try {
                    Partition part = this.db.getPartition(tab, partSpec, false);
                    if (part != null) {
                        this.outputs.add(new WriteEntity(part));
                    }
                }
                catch (HiveException e) {
                    if (!throwIfNonExistent) break block6;
                    throw new SemanticException(ErrorMsg.INVALID_PARTITION.getMsg(ast.getChild(index)));
                }
            }
            ++index;
        }
    }

    static {
        TokenToTypeName.put(71, "boolean");
        TokenToTypeName.put(67, "tinyint");
        TokenToTypeName.put(68, "smallint");
        TokenToTypeName.put(69, "int");
        TokenToTypeName.put(70, "bigint");
        TokenToTypeName.put(72, "float");
        TokenToTypeName.put(73, "double");
        TokenToTypeName.put(77, "string");
        TokenToTypeName.put(74, "date");
        TokenToTypeName.put(75, "datetime");
        TokenToTypeName.put(76, "timestamp");
    }

    static class TablePartition {
        String tableName;
        HashMap<String, String> partSpec = null;

        public TablePartition() {
        }

        public TablePartition(ASTNode tblPart) throws SemanticException {
            ASTNode part;
            this.tableName = BaseSemanticAnalyzer.unescapeIdentifier(tblPart.getChild(0).getText());
            if (tblPart.getChildCount() > 1 && (part = (ASTNode)tblPart.getChild(1)).getToken().getType() == 11) {
                this.partSpec = DDLSemanticAnalyzer.getPartSpec(part);
            }
        }
    }
}

