/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.objectinspector.primitive;

import java.util.HashMap;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveJavaObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveWritableObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaBooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaDoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaFloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaIntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaLongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaStringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaVoidObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableBooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableDoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableFloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableIntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableLongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableStringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableVoidObjectInspector;
import org.apache.hadoop.io.Writable;

public final class PrimitiveObjectInspectorFactory {
    public static final JavaBooleanObjectInspector javaBooleanObjectInspector = new JavaBooleanObjectInspector();
    public static final JavaByteObjectInspector javaByteObjectInspector = new JavaByteObjectInspector();
    public static final JavaShortObjectInspector javaShortObjectInspector = new JavaShortObjectInspector();
    public static final JavaIntObjectInspector javaIntObjectInspector = new JavaIntObjectInspector();
    public static final JavaLongObjectInspector javaLongObjectInspector = new JavaLongObjectInspector();
    public static final JavaFloatObjectInspector javaFloatObjectInspector = new JavaFloatObjectInspector();
    public static final JavaDoubleObjectInspector javaDoubleObjectInspector = new JavaDoubleObjectInspector();
    public static final JavaStringObjectInspector javaStringObjectInspector = new JavaStringObjectInspector();
    public static final JavaVoidObjectInspector javaVoidObjectInspector = new JavaVoidObjectInspector();
    public static final WritableBooleanObjectInspector writableBooleanObjectInspector = new WritableBooleanObjectInspector();
    public static final WritableByteObjectInspector writableByteObjectInspector = new WritableByteObjectInspector();
    public static final WritableShortObjectInspector writableShortObjectInspector = new WritableShortObjectInspector();
    public static final WritableIntObjectInspector writableIntObjectInspector = new WritableIntObjectInspector();
    public static final WritableLongObjectInspector writableLongObjectInspector = new WritableLongObjectInspector();
    public static final WritableFloatObjectInspector writableFloatObjectInspector = new WritableFloatObjectInspector();
    public static final WritableDoubleObjectInspector writableDoubleObjectInspector = new WritableDoubleObjectInspector();
    public static final WritableStringObjectInspector writableStringObjectInspector = new WritableStringObjectInspector();
    public static final WritableVoidObjectInspector writableVoidObjectInspector = new WritableVoidObjectInspector();
    private static HashMap<PrimitiveObjectInspector.PrimitiveCategory, AbstractPrimitiveWritableObjectInspector> cachedPrimitiveWritableInspectorCache = new HashMap();
    private static HashMap<PrimitiveObjectInspector.PrimitiveCategory, AbstractPrimitiveJavaObjectInspector> cachedPrimitiveJavaInspectorCache;

    public static AbstractPrimitiveWritableObjectInspector getPrimitiveWritableObjectInspector(PrimitiveObjectInspector.PrimitiveCategory primitiveCategory) {
        AbstractPrimitiveWritableObjectInspector result = cachedPrimitiveWritableInspectorCache.get((Object)primitiveCategory);
        if (result == null) {
            throw new RuntimeException("Internal error: Cannot find ObjectInspector  for " + (Object)((Object)primitiveCategory));
        }
        return result;
    }

    public static AbstractPrimitiveJavaObjectInspector getPrimitiveJavaObjectInspector(PrimitiveObjectInspector.PrimitiveCategory primitiveCategory) {
        AbstractPrimitiveJavaObjectInspector result = cachedPrimitiveJavaInspectorCache.get((Object)primitiveCategory);
        if (result == null) {
            throw new RuntimeException("Internal error: Cannot find ObjectInspector  for " + (Object)((Object)primitiveCategory));
        }
        return result;
    }

    public static PrimitiveObjectInspector getPrimitiveObjectInspectorFromClass(Class<?> c) {
        if (Writable.class.isAssignableFrom(c)) {
            PrimitiveObjectInspectorUtils.PrimitiveTypeEntry te = PrimitiveObjectInspectorUtils.getTypeEntryFromPrimitiveWritableClass(c);
            if (te == null) {
                throw new RuntimeException("Internal error: Cannot recognize " + c);
            }
            return PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector(te.primitiveCategory);
        }
        PrimitiveObjectInspectorUtils.PrimitiveTypeEntry te = PrimitiveObjectInspectorUtils.getTypeEntryFromPrimitiveJavaClass(c);
        if (te == null) {
            throw new RuntimeException("Internal error: Cannot recognize " + c);
        }
        return PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector(te.primitiveCategory);
    }

    private PrimitiveObjectInspectorFactory() {
    }

    static {
        cachedPrimitiveWritableInspectorCache.put(PrimitiveObjectInspector.PrimitiveCategory.BOOLEAN, writableBooleanObjectInspector);
        cachedPrimitiveWritableInspectorCache.put(PrimitiveObjectInspector.PrimitiveCategory.BYTE, writableByteObjectInspector);
        cachedPrimitiveWritableInspectorCache.put(PrimitiveObjectInspector.PrimitiveCategory.SHORT, writableShortObjectInspector);
        cachedPrimitiveWritableInspectorCache.put(PrimitiveObjectInspector.PrimitiveCategory.INT, writableIntObjectInspector);
        cachedPrimitiveWritableInspectorCache.put(PrimitiveObjectInspector.PrimitiveCategory.LONG, writableLongObjectInspector);
        cachedPrimitiveWritableInspectorCache.put(PrimitiveObjectInspector.PrimitiveCategory.FLOAT, writableFloatObjectInspector);
        cachedPrimitiveWritableInspectorCache.put(PrimitiveObjectInspector.PrimitiveCategory.DOUBLE, writableDoubleObjectInspector);
        cachedPrimitiveWritableInspectorCache.put(PrimitiveObjectInspector.PrimitiveCategory.STRING, writableStringObjectInspector);
        cachedPrimitiveWritableInspectorCache.put(PrimitiveObjectInspector.PrimitiveCategory.VOID, writableVoidObjectInspector);
        cachedPrimitiveJavaInspectorCache = new HashMap();
        cachedPrimitiveJavaInspectorCache.put(PrimitiveObjectInspector.PrimitiveCategory.BOOLEAN, javaBooleanObjectInspector);
        cachedPrimitiveJavaInspectorCache.put(PrimitiveObjectInspector.PrimitiveCategory.BYTE, javaByteObjectInspector);
        cachedPrimitiveJavaInspectorCache.put(PrimitiveObjectInspector.PrimitiveCategory.SHORT, javaShortObjectInspector);
        cachedPrimitiveJavaInspectorCache.put(PrimitiveObjectInspector.PrimitiveCategory.INT, javaIntObjectInspector);
        cachedPrimitiveJavaInspectorCache.put(PrimitiveObjectInspector.PrimitiveCategory.LONG, javaLongObjectInspector);
        cachedPrimitiveJavaInspectorCache.put(PrimitiveObjectInspector.PrimitiveCategory.FLOAT, javaFloatObjectInspector);
        cachedPrimitiveJavaInspectorCache.put(PrimitiveObjectInspector.PrimitiveCategory.DOUBLE, javaDoubleObjectInspector);
        cachedPrimitiveJavaInspectorCache.put(PrimitiveObjectInspector.PrimitiveCategory.STRING, javaStringObjectInspector);
        cachedPrimitiveJavaInspectorCache.put(PrimitiveObjectInspector.PrimitiveCategory.VOID, javaVoidObjectInspector);
    }
}

