/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.piggybank.storage.avro;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.io.DatumReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.piggybank.storage.avro.AvroStorageInputStream;
import org.apache.pig.piggybank.storage.avro.AvroStorageLog;
import org.apache.pig.piggybank.storage.avro.PigAvroDatumReader;

public class PigAvroRecordReader
extends RecordReader<NullWritable, Writable> {
    private static final Log LOG = LogFactory.getLog(PigAvroRecordReader.class);
    private AvroStorageInputStream in;
    private DataFileReader<Object> reader;
    private long start;
    private long end;
    private Path path;
    private boolean ignoreBadFiles;
    private TupleFactory tupleFactory = TupleFactory.getInstance();
    private ArrayList<Object> mProtoTuple;
    private Map<Path, Map<Integer, Integer>> schemaToMergedSchemaMap;

    public PigAvroRecordReader(TaskAttemptContext context, FileSplit split, Schema schema, boolean ignoreBadFiles, Map<Path, Map<Integer, Integer>> schemaToMergedSchemaMap) throws IOException {
        this.path = split.getPath();
        this.in = new AvroStorageInputStream(this.path, context);
        if (schema == null) {
            AvroStorageLog.details("No avro schema given; assuming the schema is embedded");
        }
        try {
            this.reader = new DataFileReader((SeekableInput)this.in, (DatumReader)new PigAvroDatumReader(schema));
        }
        catch (IOException e) {
            throw new IOException("Error initializing data file reader for file (" + split.getPath() + ")", e);
        }
        this.reader.sync(split.getStart());
        this.start = this.in.tell();
        this.end = split.getStart() + split.getLength();
        this.ignoreBadFiles = ignoreBadFiles;
        this.schemaToMergedSchemaMap = schemaToMergedSchemaMap;
        if (schemaToMergedSchemaMap != null) {
            int maxPos = 0;
            for (Map<Integer, Integer> map : schemaToMergedSchemaMap.values()) {
                for (Integer i : map.values()) {
                    maxPos = Math.max(i, maxPos);
                }
            }
            int tupleSize = maxPos + 1;
            AvroStorageLog.details("Creating proto tuple of fixed size: " + tupleSize);
            this.mProtoTuple = new ArrayList(tupleSize);
            for (int i = 0; i < tupleSize; ++i) {
                this.mProtoTuple.add(i, null);
            }
        }
    }

    public float getProgress() throws IOException {
        return this.end == this.start ? 0.0f : Math.min(1.0f, (float)(this.getPos() - this.start) / (float)(this.end - this.start));
    }

    public long getPos() throws IOException {
        return this.in.tell();
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public NullWritable getCurrentKey() throws IOException, InterruptedException {
        return NullWritable.get();
    }

    public Writable getCurrentValue() throws IOException, InterruptedException {
        Object obj = this.reader.next();
        Tuple result = null;
        if (obj instanceof Tuple) {
            AvroStorageLog.details("Class =" + obj.getClass());
            result = (Tuple)obj;
        } else {
            AvroStorageLog.details("Wrap calss " + obj.getClass() + " as a tuple.");
            result = this.wrapAsTuple(obj);
        }
        if (this.schemaToMergedSchemaMap != null) {
            Map<Integer, Integer> map = this.schemaToMergedSchemaMap.get(this.path);
            if (map == null) {
                throw new IOException("The schema of '" + this.path + "' " + "is not merged by AvroStorage.");
            }
            result = this.remap(result, map);
        }
        return result;
    }

    private Tuple remap(Tuple tuple, Map<Integer, Integer> map) throws IOException {
        try {
            for (int pos = 0; pos < tuple.size(); ++pos) {
                this.mProtoTuple.set(map.get(pos), tuple.get(pos));
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return this.tupleFactory.newTuple(this.mProtoTuple);
    }

    protected Tuple wrapAsTuple(Object in) {
        Tuple tuple = this.tupleFactory.newTuple();
        tuple.append(in);
        return tuple;
    }

    public void initialize(InputSplit arg0, TaskAttemptContext arg1) throws IOException, InterruptedException {
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        try {
            return this.reader.hasNext() && !this.reader.pastSync(this.end);
        }
        catch (AvroRuntimeException e) {
            if (this.ignoreBadFiles) {
                LOG.warn((Object)("Ignoring bad file '" + this.path + "'."));
                return false;
            }
            throw e;
        }
    }
}

