/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata.xml;

import java.net.URI;
import java.net.URISyntaxException;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.PersistenceFileMetaData;
import org.datanucleus.metadata.PersistenceUnitMetaData;
import org.datanucleus.metadata.xml.AbstractMetaDataHandler;
import org.datanucleus.util.NucleusLogger;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public class PersistenceFileMetaDataHandler
extends AbstractMetaDataHandler {
    URI rootURI = null;

    public PersistenceFileMetaDataHandler(MetaDataManager mgr, String filename, EntityResolver resolver) {
        super(mgr, filename, resolver);
        this.metadata = new PersistenceFileMetaData(filename);
        this.pushStack(this.metadata);
        if (filename.endsWith("/META-INF/persistence.xml")) {
            String rootFilename = filename.substring(0, filename.length() - "/META-INF/persistence.xml".length());
            try {
                this.rootURI = new URI(rootFilename);
            }
            catch (URISyntaxException e) {
                NucleusLogger.METADATA.warn("Error deriving persistence-unit root URI from " + rootFilename, e);
            }
        } else {
            String rootFilename = filename.substring(0, filename.lastIndexOf("/"));
            try {
                this.rootURI = new URI(rootFilename);
            }
            catch (URISyntaxException e) {
                NucleusLogger.METADATA.warn("Error deriving persistence-unit root URI from " + rootFilename, e);
            }
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        block8: {
            if (NucleusLogger.METADATA.isDebugEnabled()) {
                StringBuffer sb = new StringBuffer();
                sb.append("<" + qName);
                for (int i = 0; i < attrs.getLength(); ++i) {
                    sb.append(" ");
                    sb.append(attrs.getQName(i)).append("=\"").append(attrs.getValue(i)).append("\"");
                }
                sb.append(">");
                NucleusLogger.METADATA.debug(LOCALISER.msg("044034", (Object)sb.toString(), (Object)("" + this.stack.size())));
            }
            if (localName.length() < 1) {
                localName = qName;
            }
            try {
                PersistenceUnitMetaData pumd;
                if (localName.equals("persistence")) break block8;
                if (localName.equals("persistence-unit")) {
                    PersistenceFileMetaData filemd = (PersistenceFileMetaData)this.getStack();
                    PersistenceUnitMetaData pumd2 = new PersistenceUnitMetaData(this.getAttr(attrs, "name"), this.getAttr(attrs, "transaction-type"), this.rootURI);
                    filemd.addPersistenceUnit(pumd2);
                    this.pushStack(pumd2);
                    break block8;
                }
                if (localName.equals("properties")) break block8;
                if (localName.equals("property")) {
                    pumd = (PersistenceUnitMetaData)this.getStack();
                    pumd.addProperty(this.getAttr(attrs, "name"), this.getAttr(attrs, "value"));
                    break block8;
                }
                if (localName.equals("mapping-file") || localName.equals("class") || localName.equals("jar-file") || localName.equals("jta-data-source") || localName.equals("non-jta-data-source") || localName.equals("description") || localName.equals("provider")) break block8;
                if (localName.equals("exclude-unlisted-classes")) {
                    pumd = (PersistenceUnitMetaData)this.getStack();
                    pumd.setExcludeUnlistedClasses();
                    break block8;
                }
                String message = LOCALISER.msg("044037", (Object)qName);
                NucleusLogger.METADATA.error(message);
                throw new RuntimeException(message);
            }
            catch (RuntimeException ex) {
                NucleusLogger.METADATA.error(LOCALISER.msg("044042", (Object)qName, (Object)this.getStack(), (Object)uri), ex);
                throw ex;
            }
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        String currentString;
        if (NucleusLogger.METADATA.isDebugEnabled()) {
            NucleusLogger.METADATA.debug(LOCALISER.msg("044035", (Object)("<" + qName + ">"), (Object)("" + this.stack.size())));
        }
        if (localName.length() < 1) {
            localName = qName;
        }
        if ((currentString = this.getString().trim()).length() > 0) {
            MetaData md = this.getStack();
            if (localName.equals("description")) {
                ((PersistenceUnitMetaData)md).setDescription(currentString);
            } else if (localName.equals("provider")) {
                ((PersistenceUnitMetaData)md).setProvider(currentString);
            } else if (localName.equals("jta-data-source")) {
                ((PersistenceUnitMetaData)md).setJtaDataSource(currentString);
            } else if (localName.equals("non-jta-data-source")) {
                ((PersistenceUnitMetaData)md).setNonJtaDataSource(currentString);
            } else if (localName.equals("class")) {
                ((PersistenceUnitMetaData)md).addClassName(currentString);
            } else if (localName.equals("mapping-file")) {
                ((PersistenceUnitMetaData)md).addMappingFile(currentString);
            } else if (localName.equals("jar-file")) {
                ((PersistenceUnitMetaData)md).addJarFile(currentString);
            }
        }
        if (qName.equals("persistence-unit")) {
            this.popStack();
        }
    }
}

