/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.util;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import org.datanucleus.exceptions.NucleusException;

public class StringUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStringFromStackTrace(Throwable throwable) {
        if (throwable == null) {
            return "";
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        try {
            throwable.printStackTrace(printWriter);
            String string = stringWriter.getBuffer().toString();
            return string;
        }
        finally {
            try {
                stringWriter.close();
                printWriter.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static File getFileForFilename(String string) {
        return new File(StringUtils.getDecodedStringFromURLString(string));
    }

    public static JarFile getJarFileForFilename(String string) throws IOException {
        return new JarFile(StringUtils.getDecodedStringFromURLString(string));
    }

    public static String getDecodedStringFromURLString(String string) {
        try {
            string = string.replace("+", "%2B");
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new NucleusException("Error attempting to decode string", unsupportedEncodingException);
        }
    }

    public static String getEncodedURLStringFromString(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new NucleusException("Error attempting to encode string", unsupportedEncodingException);
        }
    }

    public static String replaceAll(String string, String string2, String string3) {
        if (string == null) {
            return null;
        }
        if (string.indexOf(string2) == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = string.length();
        int n2 = string2.length();
        while ((n = string.lastIndexOf(string2, n - 1)) > -1) {
            stringBuffer.replace(n, n + n2, string3);
        }
        return stringBuffer.toString();
    }

    public static boolean isWhitespace(String string) {
        return string == null || string.trim().length() == 0;
    }

    public static boolean areStringsEqual(String string, String string2) {
        if (string == null && string2 == null) {
            return true;
        }
        if (string == null && string2 != null) {
            return false;
        }
        if (string != null && string2 == null) {
            return false;
        }
        return string.equals(string2);
    }

    public static String leftAlignedPaddedString(String string, int n) {
        if (n <= 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        char c = ' ';
        if (string != null) {
            if (string.length() < n) {
                stringBuffer.append(string);
                for (int i = string.length(); i < n; ++i) {
                    stringBuffer.append(c);
                }
            } else {
                stringBuffer.append(string.substring(0, n));
            }
        } else {
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(c);
            }
        }
        return stringBuffer.toString();
    }

    public static String rightAlignedPaddedString(String string, int n) {
        if (n <= 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        char c = ' ';
        if (string != null) {
            if (string.length() < n) {
                for (int i = string.length(); i < n; ++i) {
                    stringBuffer.append(c);
                }
                stringBuffer.append(string);
            } else {
                stringBuffer.append(string.substring(0, n));
            }
        } else {
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(c);
            }
        }
        return stringBuffer.toString();
    }

    public static String[] split(String string, String string2) {
        String[] stringArray;
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
            stringArray = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n++] = stringTokenizer.nextToken();
            }
        } else {
            stringArray = null;
        }
        return stringArray;
    }

    public static String toJVMIDString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(object));
    }

    public static String booleanArrayToString(boolean[] blArray) {
        if (blArray == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer("[");
        for (int i = 0; i < blArray.length; ++i) {
            stringBuffer.append(blArray[i] ? (char)'Y' : 'N');
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public static String intArrayToString(int[] nArray) {
        if (nArray == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer("[");
        for (int i = 0; i < nArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(nArray[i]);
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public static String objectArrayToString(Object[] objectArray) {
        if (objectArray == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer("[");
        for (int i = 0; i < objectArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(objectArray[i]);
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public static String collectionToString(Collection collection) {
        if (collection == null) {
            return "<null>";
        }
        if (collection.isEmpty()) {
            return "<none>";
        }
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(iterator.next());
        }
        return stringBuffer.toString();
    }

    public static String mapToString(Map map) {
        if (map == null) {
            return "<null>";
        }
        if (map.isEmpty()) {
            return "<none>";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (Map.Entry entry : map.entrySet()) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("<" + entry.getKey() + "," + entry.getValue() + ">");
        }
        return stringBuffer.toString();
    }

    public static int getIntValueForProperty(Properties properties, String string, int n) {
        int n2 = n;
        if (properties != null && properties.containsKey(string)) {
            try {
                n2 = new Integer(properties.getProperty(string));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n2;
    }

    public static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static boolean notEmpty(String string) {
        return string != null && string.length() > 0;
    }

    public static String exponentialFormatBigDecimal(BigDecimal bigDecimal) {
        int n;
        int n2;
        String string = bigDecimal.unscaledValue().abs().toString();
        int n3 = bigDecimal.scale();
        for (n2 = string.length(); n2 > 1 && string.charAt(n2 - 1) == '0'; --n2) {
            --n3;
        }
        if (n2 < string.length()) {
            string = string.substring(0, n2);
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (bigDecimal.signum() < 0) {
            stringBuffer.append('-');
        }
        if ((n = n2 - n3) < 0 || n > n2) {
            stringBuffer.append('.').append(string).append('E').append(n);
        } else if (n == n2) {
            stringBuffer.append(string);
        } else {
            stringBuffer.append(string.substring(0, n)).append('.').append(string.substring(n));
        }
        return stringBuffer.toString();
    }
}

