/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.MapMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;

public class Schema
implements TBase,
Serializable,
Cloneable {
    private static final TStruct STRUCT_DESC = new TStruct("Schema");
    private static final TField FIELD_SCHEMAS_FIELD_DESC = new TField("fieldSchemas", 15, 1);
    private static final TField PROPERTIES_FIELD_DESC = new TField("properties", 13, 2);
    private List<FieldSchema> fieldSchemas;
    public static final int FIELDSCHEMAS = 1;
    private Map<String, String> properties;
    public static final int PROPERTIES = 2;
    private final Isset __isset = new Isset();
    public static final Map<Integer, FieldMetaData> metaDataMap = Collections.unmodifiableMap(new HashMap<Integer, FieldMetaData>(){
        {
            this.put(1, new FieldMetaData("fieldSchemas", 3, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, FieldSchema.class))));
            this.put(2, new FieldMetaData("properties", 3, (FieldValueMetaData)new MapMetaData(13, new FieldValueMetaData(11), new FieldValueMetaData(11))));
        }
    });

    public Schema() {
    }

    public Schema(List<FieldSchema> fieldSchemas, Map<String, String> properties) {
        this();
        this.fieldSchemas = fieldSchemas;
        this.properties = properties;
    }

    public Schema(Schema other) {
        if (other.isSetFieldSchemas()) {
            ArrayList<FieldSchema> __this__fieldSchemas = new ArrayList<FieldSchema>();
            for (FieldSchema fieldSchema : other.fieldSchemas) {
                __this__fieldSchemas.add(new FieldSchema(fieldSchema));
            }
            this.fieldSchemas = __this__fieldSchemas;
        }
        if (other.isSetProperties()) {
            HashMap<String, String> __this__properties = new HashMap<String, String>();
            for (Map.Entry entry : other.properties.entrySet()) {
                String other_element_key = (String)entry.getKey();
                String other_element_value = (String)entry.getValue();
                String __this__properties_copy_key = other_element_key;
                String __this__properties_copy_value = other_element_value;
                __this__properties.put(__this__properties_copy_key, __this__properties_copy_value);
            }
            this.properties = __this__properties;
        }
    }

    public Schema clone() {
        return new Schema(this);
    }

    public int getFieldSchemasSize() {
        return this.fieldSchemas == null ? 0 : this.fieldSchemas.size();
    }

    public Iterator<FieldSchema> getFieldSchemasIterator() {
        return this.fieldSchemas == null ? null : this.fieldSchemas.iterator();
    }

    public void addToFieldSchemas(FieldSchema elem) {
        if (this.fieldSchemas == null) {
            this.fieldSchemas = new ArrayList<FieldSchema>();
        }
        this.fieldSchemas.add(elem);
    }

    public List<FieldSchema> getFieldSchemas() {
        return this.fieldSchemas;
    }

    public void setFieldSchemas(List<FieldSchema> fieldSchemas) {
        this.fieldSchemas = fieldSchemas;
    }

    public void unsetFieldSchemas() {
        this.fieldSchemas = null;
    }

    public boolean isSetFieldSchemas() {
        return this.fieldSchemas != null;
    }

    public int getPropertiesSize() {
        return this.properties == null ? 0 : this.properties.size();
    }

    public void putToProperties(String key, String val) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(key, val);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public void unsetProperties() {
        this.properties = null;
    }

    public boolean isSetProperties() {
        return this.properties != null;
    }

    public void setFieldValue(int fieldID, Object value) {
        switch (fieldID) {
            case 1: {
                if (value == null) {
                    this.unsetFieldSchemas();
                    break;
                }
                this.setFieldSchemas((List)value);
                break;
            }
            case 2: {
                if (value == null) {
                    this.unsetProperties();
                    break;
                }
                this.setProperties((Map)value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.getFieldSchemas();
            }
            case 2: {
                return this.getProperties();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean isSet(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.isSetFieldSchemas();
            }
            case 2: {
                return this.isSetProperties();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof Schema) {
            return this.equals((Schema)that);
        }
        return false;
    }

    public boolean equals(Schema that) {
        if (that == null) {
            return false;
        }
        boolean this_present_fieldSchemas = this.isSetFieldSchemas();
        boolean that_present_fieldSchemas = that.isSetFieldSchemas();
        if (this_present_fieldSchemas || that_present_fieldSchemas) {
            if (!this_present_fieldSchemas || !that_present_fieldSchemas) {
                return false;
            }
            if (!((Object)this.fieldSchemas).equals(that.fieldSchemas)) {
                return false;
            }
        }
        boolean this_present_properties = this.isSetProperties();
        boolean that_present_properties = that.isSetProperties();
        if (this_present_properties || that_present_properties) {
            if (!this_present_properties || !that_present_properties) {
                return false;
            }
            if (!((Object)this.properties).equals(that.properties)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return 0;
    }

    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin();
        while (true) {
            TField field = iprot.readFieldBegin();
            if (field.type == 0) break;
            switch (field.id) {
                case 1: {
                    if (field.type == 15) {
                        TList _list48 = iprot.readListBegin();
                        this.fieldSchemas = new ArrayList<FieldSchema>(_list48.size);
                        for (int _i49 = 0; _i49 < _list48.size; ++_i49) {
                            FieldSchema _elem50 = new FieldSchema();
                            _elem50.read(iprot);
                            this.fieldSchemas.add(_elem50);
                        }
                        iprot.readListEnd();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 2: {
                    if (field.type == 13) {
                        TMap _map51 = iprot.readMapBegin();
                        this.properties = new HashMap<String, String>(2 * _map51.size);
                        for (int _i52 = 0; _i52 < _map51.size; ++_i52) {
                            String _key53 = iprot.readString();
                            String _val54 = iprot.readString();
                            this.properties.put(_key53, _val54);
                        }
                        iprot.readMapEnd();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.fieldSchemas != null) {
            oprot.writeFieldBegin(FIELD_SCHEMAS_FIELD_DESC);
            oprot.writeListBegin(new TList(12, this.fieldSchemas.size()));
            for (FieldSchema fieldSchema : this.fieldSchemas) {
                fieldSchema.write(oprot);
            }
            oprot.writeListEnd();
            oprot.writeFieldEnd();
        }
        if (this.properties != null) {
            oprot.writeFieldBegin(PROPERTIES_FIELD_DESC);
            oprot.writeMapBegin(new TMap(11, 11, this.properties.size()));
            for (Map.Entry entry : this.properties.entrySet()) {
                oprot.writeString((String)entry.getKey());
                oprot.writeString((String)entry.getValue());
            }
            oprot.writeMapEnd();
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Schema(");
        boolean first = true;
        sb.append("fieldSchemas:");
        if (this.fieldSchemas == null) {
            sb.append("null");
        } else {
            sb.append(this.fieldSchemas);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("properties:");
        if (this.properties == null) {
            sb.append("null");
        } else {
            sb.append(this.properties);
        }
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    static {
        FieldMetaData.addStructMetaDataMap(Schema.class, metaDataMap);
    }

    private static final class Isset
    implements Serializable {
        private Isset() {
        }
    }
}

