/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.tools.ajbrowser.core;

import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JOptionPane;
import org.aspectj.ajde.Ajde;
import org.aspectj.ajde.ui.swing.ErrorDialog;
import org.aspectj.tools.ajbrowser.BrowserManager;

public class BrowserErrorHandler {
    public static void handleWarning(String message) {
        JOptionPane.showMessageDialog(BrowserManager.getDefault().getRootFrame(), message, "AJBrowser Warning", 2);
    }

    public static void handleError(String errorMessage) {
        BrowserErrorHandler.handleError(errorMessage, null);
    }

    public static void handleError(String message, Throwable t) {
        String stack = BrowserErrorHandler.getStackTraceAsString(t);
        ErrorDialog errorDialog = new ErrorDialog(Ajde.getDefault().getRootFrame(), "AJBrowser Error", t, message, stack);
        errorDialog.setVisible(true);
    }

    private static String getStackTraceAsString(Throwable t) {
        StringWriter stringWriter = new StringWriter();
        if (t != null) {
            t.printStackTrace(new PrintWriter(stringWriter));
            return stringWriter.getBuffer().toString();
        }
        return "<no stack trace available>";
    }
}

