/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.bcel;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.aspectj.apache.bcel.classfile.annotation.AnnotationGen;
import org.aspectj.apache.bcel.classfile.annotation.ArrayElementValueGen;
import org.aspectj.apache.bcel.classfile.annotation.ElementNameValuePairGen;
import org.aspectj.apache.bcel.classfile.annotation.ElementValueGen;
import org.aspectj.apache.bcel.classfile.annotation.EnumElementValueGen;
import org.aspectj.weaver.AbstractAnnotationAJ;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.World;

public class BcelAnnotation
extends AbstractAnnotationAJ {
    private final AnnotationGen bcelAnnotation;

    public BcelAnnotation(AnnotationGen theBcelAnnotation, World world) {
        super(UnresolvedType.forSignature(theBcelAnnotation.getTypeSignature()).resolve(world));
        this.bcelAnnotation = theBcelAnnotation;
    }

    public Set getTargets() {
        if (!this.type.equals(UnresolvedType.AT_TARGET)) {
            return Collections.EMPTY_SET;
        }
        List values = this.bcelAnnotation.getValues();
        ElementNameValuePairGen envp = (ElementNameValuePairGen)values.get(0);
        ArrayElementValueGen aev = (ArrayElementValueGen)envp.getValue();
        ElementValueGen[] evs = aev.getElementValuesArray();
        HashSet<String> targets = new HashSet<String>();
        for (int i = 0; i < evs.length; ++i) {
            EnumElementValueGen ev = (EnumElementValueGen)evs[i];
            targets.add(ev.getEnumValueString());
        }
        return targets;
    }

    public boolean hasNameValuePair(String name, String value) {
        return this.bcelAnnotation.hasNameValuePair(name, value);
    }

    public boolean hasNamedValue(String name) {
        return this.bcelAnnotation.hasNamedValue(name);
    }

    public String stringify() {
        StringBuffer sb = new StringBuffer();
        sb.append("@").append(this.type.getClassName());
        List values = this.bcelAnnotation.getValues();
        if (values != null && values.size() != 0) {
            sb.append("(");
            Iterator iterator = values.iterator();
            while (iterator.hasNext()) {
                ElementNameValuePairGen nvPair = (ElementNameValuePairGen)iterator.next();
                sb.append(nvPair.getNameString()).append("=").append(nvPair.getValue().stringifyValue());
            }
            sb.append(")");
        }
        return sb.toString();
    }

    public boolean isRuntimeVisible() {
        return this.bcelAnnotation.isRuntimeVisible();
    }

    public AnnotationGen getBcelAnnotation() {
        return this.bcelAnnotation;
    }

    public String getStringFormOfValue(String name) {
        List annotationValues = this.bcelAnnotation.getValues();
        if (annotationValues == null || annotationValues.size() == 0) {
            return null;
        }
        Iterator iterator = annotationValues.iterator();
        while (iterator.hasNext()) {
            ElementNameValuePairGen nvPair = (ElementNameValuePairGen)iterator.next();
            if (!nvPair.getNameString().equals(name)) continue;
            return nvPair.getValue().stringifyValue();
        }
        return null;
    }
}

