/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Writable;

public class HMsg
implements Writable {
    private Type type = null;
    private HRegionInfo info = null;
    private byte[] message = null;

    public HMsg() {
        this(Type.MSG_NONE);
    }

    public HMsg(Type type) {
        this(type, new HRegionInfo(), null);
    }

    public HMsg(Type type, HRegionInfo hri) {
        this(type, hri, null);
    }

    public HMsg(Type type, HRegionInfo hri, byte[] msg) {
        if (type == null) {
            throw new NullPointerException("Message type cannot be null");
        }
        this.type = type;
        if (hri == null) {
            throw new NullPointerException("Region cannot be null");
        }
        this.info = hri;
        this.message = msg;
    }

    public HRegionInfo getRegionInfo() {
        return this.info;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isType(Type other) {
        return this.type.equals((Object)other);
    }

    public byte[] getMessage() {
        return this.message;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.type.toString());
        if (this.info != null && this.info.getRegionName().length > 0) {
            sb.append(": ");
            sb.append(this.info.getRegionNameAsString());
        }
        if (this.message != null && this.message.length > 0) {
            sb.append(": " + Bytes.toString(this.message));
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HMsg that = (HMsg)obj;
        return this.type.equals((Object)that.type) && this.info != null ? this.info.equals((Object)that.info) : that.info == null;
    }

    public int hashCode() {
        int result = this.type.hashCode();
        if (this.info != null) {
            result ^= this.info.hashCode();
        }
        return result;
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.type.ordinal());
        this.info.write(out);
        if (this.message == null || this.message.length == 0) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            Bytes.writeByteArray(out, this.message);
        }
    }

    public void readFields(DataInput in) throws IOException {
        int ordinal = in.readInt();
        this.type = Type.values()[ordinal];
        this.info.readFields(in);
        boolean hasMessage = in.readBoolean();
        if (hasMessage) {
            this.message = Bytes.readByteArray(in);
        }
    }

    public static enum Type {
        MSG_NONE,
        MSG_REGION_OPEN,
        MSG_REGION_CLOSE,
        MSG_REGION_SPLIT,
        MSG_REGION_COMPACT,
        MSG_CALL_SERVER_STARTUP,
        MSG_REGIONSERVER_STOP,
        MSG_REGION_CLOSE_WITHOUT_REPORT,
        MSG_REGIONSERVER_QUIESCE,
        MSG_REPORT_OPEN,
        MSG_REPORT_CLOSE,
        MSG_REPORT_PROCESS_OPEN,
        MSG_REPORT_SPLIT,
        MSG_REPORT_EXITING,
        MSG_REPORT_QUIESCED,
        MSG_REGION_FLUSH,
        MSG_REGION_MAJOR_COMPACT;

    }
}

